/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.streetside.CubeMapTileXY;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class TileDownloadingTask
implements Callable<List<String>> {
    private static final Logger LOGGER = Logger.getLogger(TileDownloadingTask.class.getCanonicalName());
    private static final Semaphore limitConnections = new Semaphore(6 * Config.getPref().getInt("streetside.download.threads.per.side", 64));
    private final List<ITileDownloadingTaskListener> listeners = new CopyOnWriteArrayList<ITileDownloadingTaskListener>();
    private final StreetsideAbstractImage image;
    private final CubemapUtils.CubemapFaces face;
    private final CubeMapTileXY tileId;
    protected final CubemapBuilder cb;

    public TileDownloadingTask(StreetsideAbstractImage image, CubemapUtils.CubemapFaces face, CubeMapTileXY tileId) {
        this.image = image;
        this.face = face;
        this.tileId = tileId;
        this.cb = CubemapBuilder.getInstance();
        this.addListener(this.cb);
    }

    public final void addListener(ITileDownloadingTaskListener lis) {
        this.listeners.add(lis);
    }

    public String getId() {
        return this.tileId.toString();
    }

    @Override
    public List<String> call() {
        limitConnections.acquire();
        try {
            List<String> list = this.download();
            limitConnections.release();
            return list;
        }
        catch (Throwable throwable) {
            try {
                limitConnections.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logging.trace((Throwable)e);
                return Collections.emptyList();
            }
        }
    }

    private List<String> download() {
        int zoom;
        ArrayList<String> res = new ArrayList<String>();
        int n = zoom = Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get()) ? this.image.zoomMax() : this.image.zoomMin();
        if (Boolean.TRUE.equals(StreetsideProperties.DOWNLOAD_CUBEFACE_TILES_TOGETHER.get())) {
            res.addAll(this.image.getFaceTiles(this.face, zoom).map(pair -> this.downloadTile((CubeMapTileXY)pair.a, (String)pair.b)).toList());
        } else {
            res.add(this.downloadTile(this.tileId, this.image.getTile(this.face.getValue(), this.tileId.getQuadKey(zoom))));
        }
        return res;
    }

    private String downloadTile(CubeMapTileXY tile, String url) {
        long startTime = System.currentTimeMillis();
        try {
            BufferedImage img = ImageIO.read(URI.create(url).toURL());
            if (img == null) {
                LOGGER.log(Logging.LEVEL_ERROR, "Download of BufferedImage {0} is null!", url);
            }
            this.fireTileAdded(this.image, tile, img);
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                long endTime = System.currentTimeMillis();
                long runTime = (endTime - startTime) / 1000L;
                LOGGER.log(Logging.LEVEL_DEBUG, "Loaded image for {0} in {1} seconds.", new Object[]{url, runTime});
            }
        }
        catch (IOException e) {
            LOGGER.log(Logging.LEVEL_ERROR, MessageFormat.format("Error downloading image for tileId {0}", url), e);
            return null;
        }
        return url;
    }

    private void fireTileAdded(StreetsideAbstractImage image, CubeMapTileXY tile, BufferedImage tileImage) {
        this.listeners.stream().filter(Objects::nonNull).forEach(lis -> lis.tileAdded(image, tile, tileImage));
    }
}

