/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.cache.CacheUtils;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.io.download.StreetsideDownloader;
import org.openstreetmap.josm.plugins.streetside.mode.AbstractMode;
import org.openstreetmap.josm.plugins.streetside.mode.SelectMode;
import org.openstreetmap.josm.plugins.streetside.utils.MapViewGeometryUtil;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideColorScheme;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideLayer
extends AbstractModifiableLayer
implements MainLayerManager.ActiveLayerChangeListener,
StreetsideDataListener {
    private static final Logger LOGGER = Logger.getLogger(StreetsideLayer.class.getCanonicalName());
    private static final int IMG_MARKER_RADIUS = 7;
    private static final int CA_INDICATOR_RADIUS = 15;
    private static final int CA_INDICATOR_ANGLE = 40;
    private static StreetsideLayer instance;
    private static final DataSetListenerAdapter DATASET_LISTENER;
    private final StreetsideData data;
    public AbstractMode mode;
    private StreetsideImage[] nearestImages = new StreetsideImage[0];
    private volatile TexturePaint hatched;

    private StreetsideLayer() {
        super(I18n.tr((String)"Microsoft Streetside Images", (Object[])new Object[0]));
        this.data = new StreetsideData();
        this.data.addListener(this);
    }

    public static void invalidateInstance() {
        if (StreetsideLayer.hasInstance()) {
            StreetsideLayer.getInstance().invalidate();
        }
    }

    private static synchronized void clearInstance() {
        instance = null;
    }

    public static synchronized StreetsideLayer getInstance() {
        if (instance != null) {
            return instance;
        }
        StreetsideLayer layer = new StreetsideLayer();
        layer.init();
        instance = layer;
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    private void init() {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.addDataSetListener((DataSetListener)DATASET_LISTENER);
        }
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setMode(new SelectMode());
            if (StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.OSM_AREA) {
                MainApplication.worker.execute(StreetsideDownloader::downloadOSMArea);
            }
            if (StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.VISIBLE_AREA) {
                this.mode.zoomChanged();
            }
        }
        if (!StreetsideMainDialog.getInstance().isShowing()) {
            StreetsideMainDialog.getInstance().showDialog();
        }
        if (StreetsidePlugin.getMapView() != null) {
            StreetsideMainDialog.getInstance().streetsideImageDisplay.repaint();
        }
        this.createHatchTexture();
        this.invalidate();
    }

    public void setMode(AbstractMode mode) {
        MapView mv = StreetsidePlugin.getMapView();
        if (this.mode != null && mv != null) {
            mv.removeMouseListener((MouseListener)this.mode);
            mv.removeMouseMotionListener((MouseMotionListener)this.mode);
            NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this.mode);
        }
        this.mode = mode;
        if (mode != null && mv != null) {
            mv.setNewCursor(mode.cursor, (Object)this);
            mv.addMouseListener((MouseListener)mode);
            mv.addMouseMotionListener((MouseMotionListener)mode);
            NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)mode);
            StreetsideUtils.updateHelpText();
        }
    }

    public boolean isModified() {
        return false;
    }

    public StreetsideData getData() {
        return this.data;
    }

    public synchronized StreetsideImage getNNearestImage(int n) {
        return n >= 1 && n <= this.nearestImages.length ? this.nearestImages[n - 1] : null;
    }

    public synchronized void destroy() {
        MapView mv;
        StreetsideLayer.clearInstance();
        this.setMode(null);
        AbstractMode.resetThread();
        StreetsideDownloader.stopAll();
        if (StreetsideMainDialog.hasInstance()) {
            StreetsideMainDialog.getInstance().setImage(null);
            StreetsideMainDialog.getInstance().updateImage();
        }
        if ((mv = StreetsidePlugin.getMapView()) != null) {
            mv.removeMouseListener((MouseListener)this.mode);
            mv.removeMouseMotionListener((MouseMotionListener)this.mode);
        }
        try {
            MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
            if (MainApplication.getLayerManager().getEditDataSet() != null) {
                MainApplication.getLayerManager().getEditDataSet().removeDataSetListener((DataSetListener)DATASET_LISTENER);
            }
        }
        catch (IllegalArgumentException e) {
            Logging.trace((Throwable)e);
        }
        super.destroy();
    }

    private void createHatchTexture() {
        BufferedImage bufferedImage = new BufferedImage(15, 15, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(StreetsideProperties.BACKGROUND.get());
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.3f);
        g2d.setComposite(composite);
        g2d.fillRect(0, 0, 15, 15);
        g2d.setColor(StreetsideProperties.OUTSIDE_DOWNLOADED_AREA.get());
        g2d.drawLine(0, 15, 15, 0);
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        this.hatched = new TexturePaint(bufferedImage, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics2D g, MapView mv, Bounds box) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (MainApplication.getLayerManager().getActiveLayer() == this) {
            g.setPaint(this.hatched);
            g.fill(MapViewGeometryUtil.getNonDownloadedArea(mv, this.data.getBounds()));
        }
        Class<StreetsideLayer> clazz = StreetsideLayer.class;
        synchronized (StreetsideLayer.class) {
            StreetsideImage selectedImg = this.data.getSelectedImage();
            for (int i = 0; i < this.nearestImages.length && selectedImg != null; ++i) {
                if (i == 0) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLUE);
                }
                Point selected = mv.getPoint((ILatLon)selectedImg);
                Point point = mv.getPoint((ILatLon)this.nearestImages[i]);
                g.draw(new Line2D.Double(point.getX(), point.getY(), selected.getX(), selected.getY()));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (mv != null && mv.getDist100Pixel() < 100.0) {
                for (StreetsideImage imageAbs : this.data.search(box.toBBox())) {
                    if (!imageAbs.visible() || !mv.contains(mv.getPoint((ILatLon)imageAbs))) continue;
                    this.drawImageMarker(g, imageAbs);
                }
            } else if (mv != null) {
                ArrayList<StreetsideImage> sortedImages = new ArrayList<StreetsideImage>(this.data.search(box.toBBox()));
                sortedImages.sort(Comparator.naturalOrder());
                ArrayList<StreetsideImage> imagesToPaint = new ArrayList<StreetsideImage>(sortedImages.size());
                boolean containsSelected = false;
                for (StreetsideImage image : sortedImages) {
                    if (!imagesToPaint.isEmpty() && ((StreetsideImage)imagesToPaint.getLast()).greatCircleDistance(image) > 20.0) {
                        this.paintSequence(g, mv, imagesToPaint, containsSelected);
                        containsSelected = false;
                        imagesToPaint.clear();
                    }
                    imagesToPaint.add(image);
                    if (!image.equals(this.getData().getHighlightedImage())) continue;
                    containsSelected = true;
                }
                if (!imagesToPaint.isEmpty()) {
                    this.paintSequence(g, mv, imagesToPaint, containsSelected);
                }
            }
            return;
        }
    }

    private void paintSequence(Graphics2D g, MapView mv, List<StreetsideImage> images, boolean containsSelected) {
        Color color = containsSelected ? StreetsideColorScheme.SEQ_HIGHLIGHTED : StreetsideColorScheme.SEQ_UNSELECTED;
        MapViewPath path = new MapViewPath(mv);
        path.moveTo((ILatLon)images.get(0));
        for (int i = 1; i < images.size(); ++i) {
            path.lineTo((ILatLon)images.get(i));
        }
        g.setColor(color);
        g.draw((Shape)path);
    }

    private void drawImageMarker(Graphics2D g, StreetsideAbstractImage img) {
        Color directionC;
        Color markerC;
        if (img == null || Double.isNaN(img.lat()) || Double.isNaN(img.lon())) {
            LOGGER.warning("An image is not painted, because it is null or has no LatLon!");
            return;
        }
        StreetsideImage selectedImg = this.getData().getSelectedImage();
        Point point = MainApplication.getMap().mapView.getPoint((ILatLon)img);
        if (img.equals(selectedImg)) {
            markerC = StreetsideColorScheme.SEQ_HIGHLIGHTED;
            directionC = StreetsideColorScheme.SEQ_HIGHLIGHTED_CA;
        } else {
            markerC = StreetsideColorScheme.SEQ_UNSELECTED;
            directionC = StreetsideColorScheme.SEQ_UNSELECTED_CA;
        }
        float alpha = 0.75f;
        int type = 3;
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.75f);
        g.setComposite(composite);
        g.setColor(directionC);
        g.fillArc(point.x - 15, point.y - 15, 30, 30, (int)(90.0 - img.heading() - 20.0), 40);
        g.setColor(markerC);
        g.fillOval(point.x - 7, point.y - 7, 14, 14);
        if (img.equals(this.getData().getHighlightedImage())) {
            g.setColor(Color.WHITE);
            g.setStroke(new BasicStroke(2.0f));
            g.drawOval(point.x - 7, point.y - 7, 14, 14);
        }
    }

    public Icon getIcon() {
        return StreetsidePlugin.LOGO.setSize(ImageProvider.ImageSizes.LAYER).get();
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("This layer does not support merging yet");
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new LayerListPopup.InfoAction((Layer)this)};
    }

    public Object getInfoComponent() {
        return I18n.tr((String)"Streetside layer", (Object[])new Object[0]) + "\n" + I18n.tr((String)"{0} downloaded images", (Object[])new Object[]{this.getData().getImages().stream().filter(Objects::nonNull).count()}) + "\n= " + I18n.tr((String)"{0} images in total", (Object[])new Object[]{this.getData().getImages().size()});
    }

    public String getToolTipText() {
        return I18n.tr((String)"{0} images", (Object[])new Object[]{this.getData().getImages().size()});
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() == this) {
            StreetsideUtils.updateHelpText();
        }
        if (MainApplication.getLayerManager().getEditLayer() != e.getPreviousDataLayer()) {
            if (MainApplication.getLayerManager().getEditLayer() != null) {
                MainApplication.getLayerManager().getEditLayer().getDataSet().addDataSetListener((DataSetListener)DATASET_LISTENER);
            }
            if (e.getPreviousDataLayer() != null) {
                e.getPreviousDataLayer().getDataSet().removeDataSetListener((DataSetListener)DATASET_LISTENER);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public void imagesAdded() {
        this.updateNearestImages();
    }

    @Override
    public void selectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        this.updateNearestImages();
    }

    private StreetsideImage[] getNearestImagesFromDifferentSequences(StreetsideImage target, int limit) {
        return (StreetsideImage[])this.data.search(target, 0.01).parallelStream().filter(i -> !target.equals(i)).filter(img -> img != null && img.greatCircleDistance(target) < (double)StreetsideProperties.SEQUENCE_MAX_JUMP_DISTANCE.get().intValue()).sorted(new NearestImgToTargetComparator(target)).map(StreetsideImage.class::cast).limit(limit).toArray(StreetsideImage[]::new);
    }

    private synchronized void updateNearestImages() {
        StreetsideImage selected = this.data.getSelectedImage();
        this.nearestImages = selected != null ? this.getNearestImagesFromDifferentSequences(selected, 2) : new StreetsideImage[0];
        if (MainApplication.isDisplayingMapView()) {
            StreetsideMainDialog.getInstance().redButton.setEnabled(this.nearestImages.length >= 1);
            StreetsideMainDialog.getInstance().blueButton.setEnabled(this.nearestImages.length >= 2);
        }
        if (this.nearestImages.length >= 1) {
            CacheUtils.downloadPicture(this.nearestImages[0]);
            if (this.nearestImages.length >= 2) {
                CacheUtils.downloadPicture(this.nearestImages[1]);
            }
        }
    }

    static {
        DATASET_LISTENER = new DataSetListenerAdapter(e -> {
            if (e instanceof DataChangedEvent && StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.OSM_AREA) {
                MainApplication.worker.execute(StreetsideDownloader::downloadOSMArea);
            }
        });
    }

    private record NearestImgToTargetComparator(StreetsideAbstractImage target) implements Comparator<StreetsideAbstractImage>
    {
        @Override
        public int compare(StreetsideAbstractImage img1, StreetsideAbstractImage img2) {
            return (int)Math.signum(img1.greatCircleDistance(this.target) - img2.greatCircleDistance(this.target));
        }
    }
}

