/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.plugins.buildings_tools.MyDialog;
import org.openstreetmap.josm.tools.I18n;

public class AddressDialog
extends MyDialog {
    private static String lhousenum;
    private static String lstreetname;
    private static int inc;
    private final JTextField housenum = new JTextField();
    private final JTextField streetname = new JTextField();
    private final JSpinner incSpinner;

    public AddressDialog() {
        super(I18n.tr((String)"Building address", (Object[])new Object[0]));
        this.addLabelled(I18n.tr((String)"House number:", (Object[])new Object[0]), this.housenum);
        this.addLabelled(I18n.tr((String)"Street Name:", (Object[])new Object[0]), this.streetname);
        this.housenum.setText(AddressDialog.nextHouseNum());
        this.streetname.setText(lstreetname);
        SpinnerNumberModel incModel = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        this.incSpinner = new JSpinner(incModel);
        this.incSpinner.setValue(inc);
        this.addLabelled(I18n.tr((String)"House number increment:", (Object[])new Object[0]), this.incSpinner);
        this.setContent(this.panel);
        this.setupDialog();
    }

    private static String nextHouseNum() {
        if (lhousenum == null) {
            return "";
        }
        try {
            int num = NumberFormat.getInstance().parse(lhousenum).intValue() + inc;
            return Integer.toString(num);
        }
        catch (ParseException e) {
            return lhousenum;
        }
    }

    public final void saveValues() {
        AddressDialog.saveValues(this);
    }

    private static void saveValues(AddressDialog dialog) {
        lhousenum = dialog.getHouseNum();
        lstreetname = dialog.getStreetName();
        inc = (Integer)dialog.incSpinner.getValue();
    }

    public final String getHouseNum() {
        return this.housenum.getText();
    }

    public final String getStreetName() {
        return this.streetname.getText();
    }
}

