/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.global;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.FitBaseType;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.global.HeartRateCadenceDistanceSpeed;
import org.openstreetmap.josm.plugins.fit.lib.global.IFitTimestamp;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;

public record FitEvent(Instant timestamp, byte event, byte eventType, short eventGroup, long data, long[][] unknown, FitDevDataRecord devData) implements FitData,
IFitTimestamp<FitEvent>
{
    @Override
    public FitEvent withTimestamp(Instant timestamp) {
        return new FitEvent(timestamp, this.event, this.eventType, this.eventGroup, this.data, this.unknown, this.devData);
    }

    public static FitEvent parse(boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        long event = FitBaseType.enum_.invalidValue();
        long eventType = FitBaseType.enum_.invalidValue();
        long eventGroup = FitBaseType.enum_.invalidValue();
        Instant timestamp = Instant.EPOCH;
        long data = FitBaseType.uint32.invalidValue();
        long[][] unknowns = HeartRateCadenceDistanceSpeed.NO_UNKNOWNS;
        block7: for (FitField fitField : fieldList) {
            short size = fitField.size();
            switch (fitField.fieldDefinitionNumber()) {
                case 0: {
                    event = NumberUtils.decodeByte(size, littleEndian, inputStream);
                    continue block7;
                }
                case 1: {
                    eventType = NumberUtils.decodeByte(size, littleEndian, inputStream);
                    continue block7;
                }
                case 3: {
                    data = NumberUtils.decodeLong(size, littleEndian, inputStream);
                    continue block7;
                }
                case 4: {
                    eventGroup = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block7;
                }
                case 253: {
                    timestamp = HeartRateCadenceDistanceSpeed.decodeInstant(size, littleEndian, inputStream);
                    continue block7;
                }
            }
            unknowns = (long[][])Arrays.copyOf(unknowns, unknowns.length + 1);
            unknowns[unknowns.length - 1] = new long[]{fitField.fieldDefinitionNumber(), NumberUtils.decodeLong(size, littleEndian, inputStream)};
        }
        return new FitEvent(timestamp, (byte)event, (byte)eventType, (short)eventGroup, data, unknowns, DevDataUtils.parseDevFields(littleEndian, developerFieldList, developerFields, inputStream));
    }
}

