/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.fixAddresses.GuessedValueHandler;
import org.openstreetmap.josm.plugins.fixAddresses.IProgressMonitorFinishedListener;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GuessAddressRunnable
extends PleaseWaitRunnable {
    private List<OSMAddress> addressesToGuess;
    private List<IProgressMonitorFinishedListener> finishListeners = new ArrayList<IProgressMonitorFinishedListener>();
    private boolean isRunning = false;
    private boolean canceled;
    private GuessedValueHandler[] wayGuessers = new GuessedValueHandler[]{new GuessStreetValueHandler("addr:street")};
    private GuessedValueHandler[] nodeGuessers = new GuessedValueHandler[]{new GuessedValueHandler("addr:postcode", 500.0), new GuessedValueHandler("addr:city", 5000.0), new GuessedValueHandler("addr:state", 5000.0), new GuessedValueHandler("addr:country", 5000.0), new GuessedValueHandler("addr:city", 2000.0)};

    public GuessAddressRunnable(List<OSMAddress> addresses, String title) {
        super(title != null ? title : I18n.tr((String)"Searching", (Object[])new Object[0]));
        this.setAddressEditContainer(addresses);
    }

    public void setAddressEditContainer(List<OSMAddress> nodes) {
        if (this.isRunning) {
            throw new ConcurrentModificationException();
        }
        this.addressesToGuess = nodes;
    }

    public List<OSMAddress> getAddressesToGuess() {
        return this.addressesToGuess;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addFinishListener(IProgressMonitorFinishedListener l) {
        this.finishListeners.add(l);
    }

    public void removeFinishListener(IProgressMonitorFinishedListener l) {
        this.finishListeners.remove(l);
    }

    protected void fireFinished() {
        for (IProgressMonitorFinishedListener l : this.finishListeners) {
            l.finished();
        }
        this.finishListeners.clear();
    }

    protected void cancel() {
        this.canceled = true;
    }

    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds == null || this.addressesToGuess == null) {
            return;
        }
        this.isRunning = true;
        this.canceled = false;
        this.progressMonitor.subTask(I18n.tr((String)"Searching", (Object[])new Object[0]) + "...");
        try {
            this.progressMonitor.setTicksCount(this.addressesToGuess.size());
            ArrayList<OSMAddress> shadowCopy = new ArrayList<OSMAddress>(this.addressesToGuess);
            for (OSMAddress aNode : shadowCopy) {
                Object guessedVal;
                GuessedValueHandler guesser;
                int i;
                if (!aNode.needsGuess()) {
                    this.progressMonitor.worked(1);
                    continue;
                }
                if (this.canceled) {
                    break;
                }
                this.progressMonitor.subTask(I18n.tr((String)"Guess values for ", (Object[])new Object[0]) + String.valueOf(aNode));
                for (i = 0; i < this.wayGuessers.length; ++i) {
                    guesser = this.wayGuessers[i];
                    guesser.setAddressNode(aNode);
                    for (Way way : ds.getWays()) {
                        if (this.canceled) break;
                        way.accept((OsmPrimitiveVisitor)guesser);
                    }
                    if ((guessedVal = guesser.getCurrentValue()) == null) continue;
                    aNode.setGuessedValue(guesser.getTag(), (String)guessedVal, guesser.getSourceNode());
                }
                for (i = 0; i < this.nodeGuessers.length; ++i) {
                    guesser = this.nodeGuessers[i];
                    guesser.setAddressNode(aNode);
                    guessedVal = ds.getNodes().iterator();
                    while (guessedVal.hasNext()) {
                        Node node = (Node)guessedVal.next();
                        if (this.canceled) break;
                        node.accept((OsmPrimitiveVisitor)guesser);
                    }
                    if ((guessedVal = guesser.getCurrentValue()) == null) continue;
                    aNode.setGuessedValue(guesser.getTag(), (String)guessedVal, guesser.getSourceNode());
                }
                this.progressMonitor.worked(1);
            }
        }
        finally {
            this.isRunning = false;
            this.fireFinished();
        }
    }

    private static class GuessStreetValueHandler
    extends GuessedValueHandler {
        GuessStreetValueHandler(String tag) {
            this(tag, null);
        }

        GuessStreetValueHandler(String tag, OSMAddress aNode) {
            super(tag, aNode, 200.0);
        }

        @Override
        public void visit(Node n) {
        }

        @Override
        public void visit(Way w) {
            if (TagUtils.isStreetSupportingHousenumbers(w)) {
                double dist;
                OSMAddress aNode = this.getAddressNode();
                String newVal = TagUtils.getNameValue((OsmPrimitive)w);
                if (newVal != null && (dist = OsmUtils.getMinimumDistanceToWay(aNode.getCoor(), w)) < this.minDist && dist < this.getMaxDistance()) {
                    this.minDist = dist;
                    this.currentValue = newVal;
                    this.srcNode = w;
                }
            }
        }
    }
}

