/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeAddrPointsAction
extends JosmAction {
    public MergeAddrPointsAction() {
        super(I18n.tr((String)"Merge address points", (Object[])new Object[0]), "mergeaddr", I18n.tr((String)"Move tags from address nodes inside buildings to building ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:mergeaddrpoints", (String)I18n.tr((String)"Data: {0}", (Object[])new Object[]{I18n.tr((String)"Merge address points", (Object[])new Object[0])}), (int)65535, (int)5000), true);
    }

    public void actionPerformed(ActionEvent arg0) {
        Command deleteCommand;
        if (!this.isEnabled()) {
            return;
        }
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        if (selection.isEmpty()) {
            new Notification(I18n.tr((String)"Select both address nodes and building ways to merge", (Object[])new Object[0])).setIcon(1).show();
            return;
        }
        LinkedList<Node> addrNodes = new LinkedList<Node>();
        LinkedList<Way> buildings = new LinkedList<Way>();
        if (!MergeAddrPointsAction.generateAddressesAndBuildings(selection, addrNodes, buildings)) {
            return;
        }
        Set<Way> overlappingWays = MergeAddrPointsAction.removeNodesInMoreThanOneBuilding(addrNodes, buildings);
        LinkedList<Command> cmds = new LinkedList<Command>();
        ArrayList<Pair<Node, Way>> replaced = new ArrayList<Pair<Node, Way>>();
        HashSet<Relation> modifiedRelations = new HashSet<Relation>();
        MultiConflict multiConflict = MergeAddrPointsAction.parseBuildingWays(cmds, replaced, modifiedRelations, buildings, addrNodes);
        MergeAddrPointsAction.parseRelations(cmds, replaced, modifiedRelations);
        if (!replaced.isEmpty() && (deleteCommand = DeleteCommand.delete((Collection)replaced.stream().map(p -> (Node)p.a).collect(Collectors.toList()))) != null) {
            cmds.add(deleteCommand);
        }
        MergeAddrPointsAction.generateFinalMessages(cmds, overlappingWays, multiConflict);
        if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand("Merge addresses", cmds));
        }
    }

    private static boolean generateAddressesAndBuildings(Collection<OsmPrimitive> selection, List<Node> addrNodes, List<Way> buildings) {
        block0: for (OsmPrimitive p : selection) {
            if (p.getType() == OsmPrimitiveType.NODE) {
                if (p.getReferrers().stream().map(PrimitiveId::getType).noneMatch(arg_0 -> OsmPrimitiveType.WAY.equals(arg_0))) {
                    for (String key : p.getKeys().keySet()) {
                        if (!key.startsWith("addr:")) continue;
                        addrNodes.add((Node)p);
                        continue block0;
                    }
                    continue;
                }
            }
            if (p.getType() != OsmPrimitiveType.WAY || !p.getKeys().containsKey((Object)"building")) continue;
            buildings.add((Way)p);
        }
        if (addrNodes.isEmpty()) {
            new Notification(I18n.tr((String)"No address nodes found in the selection", (Object[])new Object[0])).setIcon(0).show();
            return false;
        }
        if (buildings.isEmpty()) {
            new Notification(I18n.tr((String)"No building ways found in the selection", (Object[])new Object[0])).setIcon(0).show();
            return false;
        }
        return true;
    }

    private static Set<Way> removeNodesInMoreThanOneBuilding(List<Node> addrNodes, List<Way> buildings) {
        HashMap<Node, Way> nodeToWayMap = new HashMap<Node, Way>();
        HashSet<Way> overlappingWays = new HashSet<Way>();
        for (Way w : buildings) {
            for (Node n : addrNodes) {
                Way old;
                if (!Geometry.nodeInsidePolygon((INode)n, (List)w.getNodes()) || (old = nodeToWayMap.put(n, w)) == null) continue;
                overlappingWays.add(w);
                overlappingWays.add(old);
            }
        }
        buildings.removeAll(overlappingWays);
        return overlappingWays;
    }

    private static MultiConflict parseBuildingWays(List<Command> cmds, List<Pair<Node, Way>> replaced, Set<Relation> modifiedRelations, List<Way> buildings, List<Node> addrNodes) {
        int multi = 0;
        int conflicts = 0;
        for (Way w : buildings) {
            Node mergeNode = null;
            int oldMulti = multi;
            for (Node n : addrNodes) {
                if (!Geometry.nodeInsidePolygon((INode)n, (List)w.getNodes())) continue;
                if (mergeNode != null) {
                    ++multi;
                    break;
                }
                mergeNode = n;
            }
            if (oldMulti != multi || mergeNode == null) continue;
            conflicts += MergeAddrPointsAction.checkForConflicts(cmds, replaced, modifiedRelations, w, mergeNode);
        }
        return new MultiConflict(multi, conflicts);
    }

    private static int checkForConflicts(List<Command> cmds, List<Pair<Node, Way>> replaced, Set<Relation> modifiedRelations, Way w, Node mergeNode) {
        boolean hasConflicts = false;
        int conflicts = 0;
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry entry : mergeNode.getKeys().entrySet()) {
            String oldValue;
            String newValue = (String)entry.getValue();
            if (newValue == null || newValue.equals(oldValue = w.getKeys().get(entry.getKey()))) continue;
            if (oldValue == null) {
                tags.put((String)entry.getKey(), newValue);
                continue;
            }
            hasConflicts = true;
        }
        if (hasConflicts) {
            ++conflicts;
        }
        if (!tags.isEmpty()) {
            cmds.add((Command)new ChangePropertyCommand(Collections.singleton(w), tags));
        }
        if (!hasConflicts) {
            replaced.add((Pair<Node, Way>)Pair.create((Object)mergeNode, (Object)w));
            modifiedRelations.addAll(mergeNode.referrers(Relation.class).collect(Collectors.toList()));
        }
        return conflicts;
    }

    private static void parseRelations(List<Command> cmds, List<Pair<Node, Way>> replaced, Set<Relation> modifiedRelations) {
        for (Relation r : modifiedRelations) {
            ArrayList<RelationMember> members = new ArrayList<RelationMember>(r.getMembers());
            boolean modified = false;
            for (Pair<Node, Way> repl : replaced) {
                for (int i = 0; i < members.size(); ++i) {
                    RelationMember member = (RelationMember)members.get(i);
                    if (!((Node)repl.a).equals((Object)member.getMember())) continue;
                    members.set(i, new RelationMember(member.getRole(), (OsmPrimitive)repl.b));
                    modified = true;
                }
            }
            if (!modified) continue;
            cmds.add((Command)new ChangeMembersCommand(r, members));
        }
    }

    private static void generateFinalMessages(List<Command> cmds, Set<Way> overlappingWays, MultiConflict multiConflict) {
        int multi = multiConflict.multi;
        int conflicts = multiConflict.conflicts;
        if (multi != 0) {
            new Notification(I18n.trn((String)"There is {0} building with multiple address nodes inside", (String)"There are {0} buildings with multiple address nodes inside", (long)multi, (Object[])new Object[]{multi})).setIcon(2).show();
        }
        if (conflicts != 0) {
            new Notification(I18n.trn((String)"There is {0} building with address conflicts", (String)"There are {0} buildings with address conflicts", (long)conflicts, (Object[])new Object[]{conflicts})).setIcon(2).show();
        }
        if (!overlappingWays.isEmpty()) {
            new Notification(I18n.tr((String)"There are {0} buildings covering the same address node", (Object[])new Object[]{overlappingWays.size()})).setIcon(2).show();
        }
        if (cmds.isEmpty() && multi == 0 && conflicts == 0 && overlappingWays.isEmpty()) {
            new Notification(I18n.tr((String)"No address nodes inside buildings found", (Object[])new Object[0])).setIcon(1).show();
        }
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }

    private static class MultiConflict {
        private final int multi;
        private final int conflicts;

        public MultiConflict(int multi, int conflict) {
            this.multi = multi;
            this.conflicts = conflict;
        }
    }
}

