/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.plugins.buildings_tools.AddressDialog;
import org.openstreetmap.josm.plugins.buildings_tools.Building;
import org.openstreetmap.josm.plugins.buildings_tools.BuildingsToolsPlugin;
import org.openstreetmap.josm.plugins.buildings_tools.ToolSettings;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DrawBuildingAction
extends MapMode
implements MapViewPaintable,
DataSelectionListener,
KeyPressReleaseListener,
ModifierExListener {
    private static final long serialVersionUID = -3515263157730927711L;
    private static final String CROSSHAIR = "crosshair";
    private static final String BUILDING_STRING = "building";
    private static final String DRAW_BUILDINGS = I18n.marktr((String)"Draw buildings");
    private static final Cursor CURSOR_SILO = ImageProvider.getCursor((String)"crosshair", (String)"silo");
    private static final Cursor CURSOR_BUILDING = ImageProvider.getCursor((String)"crosshair", (String)"building");
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Cursor customCursor;
    private Mode mode = Mode.NONE;
    private Mode nextMode = Mode.NONE;
    private Color selectedColor = Color.red;
    private Point drawStartPos;
    private Point mousePos;
    private static final double MIN_LEN_WIDTH = 1.0E-6;
    final transient Building building = new Building();
    private final transient PreferenceChangedListener shapeChangeListener = event -> this.updCursor();

    public DrawBuildingAction() {
        super(I18n.tr((String)DRAW_BUILDINGS, (Object[])new Object[0]), BUILDING_STRING, I18n.tr((String)DRAW_BUILDINGS, (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)DRAW_BUILDINGS, (Object[])new Object[0])}), (int)66, (int)5003), ImageProvider.getCursor((String)CROSSHAIR, null));
        this.cursorJoinNode = ImageProvider.getCursor((String)CROSSHAIR, (String)"joinnode");
        this.cursorJoinWay = ImageProvider.getCursor((String)CROSSHAIR, (String)"joinway");
    }

    private static Cursor getCursor() {
        switch (ToolSettings.getShape()) {
            case RECTANGLE: {
                return CURSOR_BUILDING;
            }
            case CIRCLE: {
                return CURSOR_SILO;
            }
        }
        return Cursor.getPredefinedCursor(1);
    }

    private void setCursor(Cursor c) {
        MainApplication.getMap().mapView.setNewCursor(c, (Object)this);
    }

    private void showAddrDialog(Way w) {
        AddressDialog dlg = new AddressDialog();
        if (!this.alt) {
            dlg.showDialog();
            if (dlg.getValue() != 1) {
                return;
            }
        }
        dlg.saveValues();
        String tmp = dlg.getHouseNum();
        if (tmp != null && !tmp.isEmpty()) {
            w.put("addr:housenumber", tmp);
        }
        if ((tmp = dlg.getStreetName()) != null && !tmp.isEmpty()) {
            w.put("addr:street", tmp);
        }
    }

    public void enterMode() {
        super.enterMode();
        MapFrame map = MainApplication.getMap();
        this.selectedColor = new NamedColorProperty(I18n.marktr((String)"selected"), this.selectedColor).get();
        map.mapView.addMouseListener((MouseListener)((Object)this));
        map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        map.mapView.addTemporaryLayer((MapViewPaintable)this);
        map.keyDetector.addKeyListener((KeyPressReleaseListener)this);
        map.keyDetector.addModifierExListener((ModifierExListener)this);
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        Config.getPref().addKeyPreferenceChangeListener("buildings_tool.shape", this.shapeChangeListener);
        this.updateSnap(this.getLayerManager().getEditDataSet().getSelected());
        this.updCursor();
    }

    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener((MouseListener)((Object)this));
        map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        map.keyDetector.removeKeyListener((KeyPressReleaseListener)this);
        map.keyDetector.removeModifierExListener((ModifierExListener)this);
        SelectionEventManager.getInstance().removeSelectionListener((DataSelectionListener)this);
        Config.getPref().removeKeyPreferenceChangeListener("buildings_tool.shape", this.shapeChangeListener);
        if (this.mode != Mode.NONE) {
            map.mapView.repaint();
        }
        this.mode = Mode.NONE;
    }

    public final void cancelDrawing() {
        this.mode = Mode.NONE;
        MapFrame map = MainApplication.getMap();
        if (map == null || map.mapView == null) {
            return;
        }
        map.statusLine.setHeading(-1.0);
        map.statusLine.setAngle(-1.0);
        this.building.reset();
        map.mapView.repaint();
        this.updateStatusLine();
    }

    public void modifiersExChanged(int modifiers) {
        boolean oldCtrl = this.ctrl;
        boolean oldShift = this.shift;
        this.updateKeyModifiersEx(modifiers);
        if (this.ctrl != oldCtrl || this.shift != oldShift) {
            this.processMouseEvent(null);
            this.updCursor();
            if (this.mode != Mode.NONE) {
                MainApplication.getMap().mapView.repaint();
            }
        }
    }

    public void doKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            if (this.mode != Mode.NONE) {
                e.consume();
            }
            this.cancelDrawing();
        }
        if (!(ToolSettings.isTogglingBuildingTypeOnRepeatedKeyPress() && MainApplication.isDisplayingMapView() && this.getShortcut().isEvent(e))) {
            return;
        }
        e.consume();
        ToolSettings.Shape shape = ToolSettings.getShape();
        if (Objects.requireNonNull(shape) == ToolSettings.Shape.CIRCLE) {
            ToolSettings.saveShape(ToolSettings.Shape.RECTANGLE);
        } else if (shape == ToolSettings.Shape.RECTANGLE) {
            ToolSettings.saveShape(ToolSettings.Shape.CIRCLE);
        } else {
            throw new IllegalStateException("Unknown shape " + String.valueOf((Object)shape));
        }
    }

    public void doKeyReleased(KeyEvent e) {
    }

    private EastNorth getEastNorth() {
        if (!this.ctrl) {
            EastNorth p2;
            EastNorth p1;
            EastNorth enX;
            Node n = MainApplication.getMap().mapView.getNearestNode(this.mousePos, AbstractPrimitive::isUsable);
            if (n != null) {
                return BuildingsToolsPlugin.latlon2eastNorth((ILatLon)n);
            }
            WaySegment ws = MainApplication.getMap().mapView.getNearestWaySegment(this.mousePos, OsmPrimitive::isSelectable);
            if (ws != null && ((Way)ws.getWay()).get(BUILDING_STRING) != null && (enX = Geometry.closestPointToSegment((EastNorth)(p1 = BuildingsToolsPlugin.latlon2eastNorth((ILatLon)ws.getFirstNode())), (EastNorth)(p2 = BuildingsToolsPlugin.latlon2eastNorth((ILatLon)ws.getSecondNode())), (EastNorth)BuildingsToolsPlugin.latlon2eastNorth((ILatLon)MainApplication.getMap().mapView.getLatLon(this.mousePos.x, this.mousePos.y)))) != null) {
                return enX;
            }
        }
        return BuildingsToolsPlugin.latlon2eastNorth((ILatLon)MainApplication.getMap().mapView.getLatLon(this.mousePos.x, this.mousePos.y));
    }

    private boolean isRectDrawing() {
        return this.building.isRectDrawing() && (!this.shift || ToolSettings.isBBMode()) && ToolSettings.Shape.RECTANGLE == ToolSettings.getShape();
    }

    private Mode modeDrawing() {
        EastNorth p = this.getEastNorth();
        if (this.isRectDrawing()) {
            this.building.setPlaceRect(p);
            if (Math.abs(this.building.getLength()) < 1.0E-6) {
                return Mode.DRAWING;
            }
            return this.shift ? Mode.DRAWING_ANG_FIX : Mode.NONE;
        }
        if (ToolSettings.Shape.CIRCLE == ToolSettings.getShape()) {
            return this.modeDrawingCircle(p);
        }
        this.building.setPlace(p, ToolSettings.getWidth(), ToolSettings.getLenStep(), this.shift);
        if (this.building.getLength() < 1.0E-6) {
            return Mode.DRAWING;
        }
        MainApplication.getMap().statusLine.setDist(this.building.getLength());
        return ToolSettings.getWidth() == 0.0 ? Mode.DRAWING_WIDTH : Mode.NONE;
    }

    private Mode modeDrawingCircle(EastNorth p) {
        if (ToolSettings.getWidth() != 0.0) {
            this.building.setPlaceCircle(p, ToolSettings.getWidth(), this.shift);
        } else {
            this.building.setPlace(p, ToolSettings.getWidth(), ToolSettings.getLenStep(), this.shift);
        }
        if (this.building.getLength() < 1.0E-6) {
            return Mode.DRAWING;
        }
        MainApplication.getMap().statusLine.setDist(this.building.getLength());
        return Mode.NONE;
    }

    private Mode modeDrawingWidth() {
        this.building.setWidth(this.getEastNorth());
        double width = Math.abs(this.building.getWidth());
        MainApplication.getMap().statusLine.setDist(width);
        return width < 1.0E-6 ? Mode.DRAWING_WIDTH : Mode.NONE;
    }

    private Mode modeDrawingAngFix() {
        this.building.angFix(this.getEastNorth());
        return Mode.NONE;
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
            this.updateKeyModifiers(e);
        }
        if (this.mode == Mode.NONE) {
            this.nextMode = Mode.NONE;
            return;
        }
        if (this.mode == Mode.DRAWING) {
            this.nextMode = this.modeDrawing();
        } else if (this.mode == Mode.DRAWING_WIDTH) {
            this.nextMode = this.modeDrawingWidth();
        } else if (this.mode == Mode.DRAWING_ANG_FIX) {
            this.nextMode = this.modeDrawingAngFix();
        } else {
            throw new AssertionError((Object)"Invalid drawing mode");
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mode == Mode.NONE || this.building.getLength() == 0.0) {
            return;
        }
        g.setColor(this.selectedColor);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        this.building.paint(g, mv);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawingStart(MouseEvent e) {
        this.drawStartPos = this.mousePos = e.getPoint();
        EastNorth en = this.getEastNorth();
        this.building.setBase(en);
        this.mode = Mode.DRAWING;
        this.updateStatusLine();
    }

    private void drawingAdvance(MouseEvent e) {
        this.processMouseEvent(e);
        if (this.mode != Mode.NONE && this.nextMode == Mode.NONE) {
            this.drawingFinish();
        } else {
            this.mode = this.nextMode;
            this.updateStatusLine();
        }
    }

    private void drawingFinish() {
        if (this.building.getLength() != 0.0) {
            Way w = ToolSettings.Shape.CIRCLE == ToolSettings.getShape() ? this.building.createCircle() : this.building.createRectangle(this.ctrl);
            this.drawingFinish(w);
        }
        this.cancelDrawing();
    }

    private void drawingFinish(Way w) {
        if (w != null) {
            if (!this.alt || ToolSettings.isUsingAddr()) {
                for (Map.Entry<String, String> kv : ToolSettings.getTags().entrySet()) {
                    w.put(kv.getKey(), kv.getValue());
                }
            }
            if (ToolSettings.isUsingAddr()) {
                this.showAddrDialog(w);
            }
            if (ToolSettings.isAutoSelect() && (this.getLayerManager().getEditDataSet().getSelected().isEmpty() || this.shift || ToolSettings.isAutoSelectReplaceSelection())) {
                this.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[]{w});
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.requestFocusInMapView();
        if (this.mode == Mode.NONE) {
            this.drawingStart(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.NONE) {
            MainApplication.getMap().mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean dragged = true;
        if (this.drawStartPos != null) {
            dragged = e.getPoint().distance(this.drawStartPos) > 10.0;
            this.drawStartPos = null;
            if (ToolSettings.isNoClickAndDrag()) {
                return;
            }
        }
        if (this.mode == Mode.DRAWING && !dragged) {
            return;
        }
        if (this.mode == Mode.NONE) {
            return;
        }
        this.drawingAdvance(e);
    }

    private void updCursor() {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        if (!this.ctrl && this.mousePos != null) {
            Node n = MainApplication.getMap().mapView.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
            if (n != null) {
                this.setCursor(this.cursorJoinNode);
                return;
            }
            Way w = MainApplication.getMap().mapView.getNearestWay(this.mousePos, OsmPrimitive::isSelectable);
            if (w != null && w.get(BUILDING_STRING) != null) {
                this.setCursor(this.cursorJoinWay);
                return;
            }
        }
        if (this.customCursor != null && (!this.ctrl || this.isRectDrawing())) {
            this.setCursor(this.customCursor);
        } else {
            this.setCursor(DrawBuildingAction.getCursor());
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        if (this.mode != Mode.NONE) {
            MainApplication.getMap().mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.mode == Mode.NONE) {
            return I18n.tr((String)"Point on the corner of the building to start drawing", (Object[])new Object[0]);
        }
        if (this.mode == Mode.DRAWING) {
            return I18n.tr((String)"Point on opposite end of the building", (Object[])new Object[0]);
        }
        if (this.mode == Mode.DRAWING_WIDTH) {
            return I18n.tr((String)"Set width of the building", (Object[])new Object[0]);
        }
        return "";
    }

    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    public final void updateSnap(Collection<? extends OsmPrimitive> newSelection) {
        this.building.clearAngleSnap();
        if (newSelection.size() <= 10) {
            LinkedList<Node> nodes = new LinkedList<Node>();
            LinkedList<Way> ways = new LinkedList<Way>();
            for (OsmPrimitive osmPrimitive : newSelection) {
                switch (osmPrimitive.getType()) {
                    case NODE: {
                        nodes.add((Node)osmPrimitive);
                        break;
                    }
                    case WAY: {
                        ways.add((Way)osmPrimitive);
                        break;
                    }
                }
            }
            this.building.addAngleSnap(nodes.toArray(new Node[0]));
            for (Way way : ways) {
                this.building.addAngleSnap(way);
            }
        }
        this.updateCustomCursor();
    }

    private void updateCustomCursor() {
        Double angle = this.building.getDrawingAngle();
        if (angle == null || !ToolSettings.isSoftCursor()) {
            this.customCursor = null;
            return;
        }
        int R = 9;
        int r = 3;
        BufferedImage img = new BufferedImage(32, 32, 2);
        Graphics2D g = img.createGraphics();
        GeneralPath b = new GeneralPath();
        b.moveTo(16.0 - Math.cos(angle) * 9.0, 16.0 - Math.sin(angle) * 9.0);
        b.lineTo(16.0 - Math.cos(angle) * 3.0, 16.0 - Math.sin(angle) * 3.0);
        b.moveTo(16.0 + Math.cos(angle) * 9.0, 16.0 + Math.sin(angle) * 9.0);
        b.lineTo(16.0 + Math.cos(angle) * 3.0, 16.0 + Math.sin(angle) * 3.0);
        b.moveTo(16.0 + Math.sin(angle) * 9.0, 16.0 - Math.cos(angle) * 9.0);
        b.lineTo(16.0 + Math.sin(angle) * 3.0, 16.0 - Math.cos(angle) * 3.0);
        b.moveTo(16.0 - Math.sin(angle) * 9.0, 16.0 + Math.cos(angle) * 9.0);
        b.lineTo(16.0 - Math.sin(angle) * 3.0, 16.0 + Math.cos(angle) * 3.0);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.setColor(Color.WHITE);
        g.draw(b);
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        g.setColor(Color.BLACK);
        g.draw(b);
        this.customCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(16, 16), "custom crosshair");
        this.updCursor();
    }

    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.updateSnap(event.getSelection());
    }

    private static enum Mode {
        NONE,
        DRAWING,
        DRAWING_WIDTH,
        DRAWING_ANG_FIX;

    }
}

