/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import javax.measure.MeasurementException;
import javax.measure.Quantity;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.QuantityFormat;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.MixedQuantity;
import tech.uom.lib.common.function.Parser;

public abstract class AbstractQuantityFormat
extends Format
implements QuantityFormat,
Parser<CharSequence, Quantity> {
    protected static final String DEFAULT_DELIMITER = " ";
    private static final long serialVersionUID = -4628006924354248662L;

    @Override
    public abstract Appendable format(Quantity<?> var1, Appendable var2) throws IOException;

    @Override
    public abstract Quantity<?> parse(CharSequence var1, ParsePosition var2) throws IllegalArgumentException, MeasurementParseException;

    @Override
    public abstract Quantity<?> parse(CharSequence var1) throws MeasurementParseException;

    protected abstract Quantity<?> parse(CharSequence var1, int var2) throws IllegalArgumentException, MeasurementParseException;

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof MixedQuantity) {
            return this.formatMixed((MixedQuantity)obj, toAppendTo);
        }
        if (!(obj instanceof ComparableQuantity)) {
            throw new IllegalArgumentException("obj: Not an instance of Quantity");
        }
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        return this.format((ComparableQuantity)obj, toAppendTo);
    }

    @Override
    public final Quantity<?> parseObject(String source, ParsePosition pos) {
        try {
            return this.parse((CharSequence)source, pos);
        }
        catch (IllegalArgumentException | MeasurementParseException e) {
            return null;
        }
    }

    @Override
    public final String format(Quantity<?> quantity) {
        if (quantity instanceof ComparableQuantity) {
            return this.format((ComparableQuantity)quantity, new StringBuffer()).toString();
        }
        try {
            return this.format(quantity, (Appendable)new StringBuffer()).toString();
        }
        catch (IOException ex) {
            throw new MeasurementException(ex);
        }
    }

    protected final StringBuffer format(ComparableQuantity<?> quantity, StringBuffer dest) {
        try {
            return (StringBuffer)this.format(quantity, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new MeasurementException(ex);
        }
    }

    protected abstract StringBuffer formatMixed(MixedQuantity<?> var1, StringBuffer var2);
}

