/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.transform;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class QNameValidatingHandler
implements TransformerHandler {
    private final ContentHandler original;

    public QNameValidatingHandler(ContentHandler original) {
        this.original = original;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!StringUtils.isEmpty((CharSequence)prefix) && !DataValue.XMLChar.isValidNCName((String)prefix)) {
            throw new DOMException(5, "INVALID_CHARACTER_ERR: An invalid or illegal XML character is specified.");
        }
        QNameValidatingHandler.checkNamespaceUri(uri);
        this.original.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!QNameValidatingHandler.checkName(localName, qName) || !QNameValidatingHandler.checkAtts(atts)) {
            throw new DOMException(5, "INVALID_CHARACTER_ERR: An invalid or illegal XML character is specified.");
        }
        this.original.startElement(namespaceURI, localName, qName, atts);
    }

    private static boolean checkName(String localName, String qName) {
        if (!StringUtils.isEmpty((CharSequence)localName) && !DataValue.XMLChar.isValidNCName((String)localName)) {
            return false;
        }
        if (!StringUtils.isEmpty((CharSequence)qName)) {
            String[] names = qName.split(":", 2);
            return !(!names[0].isEmpty() && !DataValue.XMLChar.isValidNCName((String)names[0]) || names.length != 1 && !DataValue.XMLChar.isValidNCName((String)names[1]));
        }
        return !StringUtils.isEmpty((CharSequence)localName);
    }

    private static boolean checkAtts(Attributes atts) {
        if (atts != null && atts.getLength() > 0) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String localName = atts.getLocalName(i);
                String qName = atts.getQName(i);
                String string = localName = qName != null && qName.equals(localName) ? "" : localName;
                if (!QNameValidatingHandler.checkName(localName, qName)) {
                    return false;
                }
                if (!"xmlns".equals(localName) && !"xmlns".equals(qName) && (qName == null || !qName.startsWith("xmlns:"))) continue;
                QNameValidatingHandler.checkNamespaceUri(atts.getValue(i));
            }
        }
        return true;
    }

    private static void checkNamespaceUri(String uri) {
        if ("http://www.w3.org/1999/xhtml".equals(uri)) {
            throw new DOMException(14, "NAMESPACE_ERR: The XHTML namespace is not allowed.");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.original.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.original.endDocument();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.original.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.original.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.original.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.original.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.original.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.original.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.original.startDocument();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).comment(ch, start, length);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).endCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.original instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.original)).endEntity(name);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.original instanceof DTDHandler) {
            ((DTDHandler)((Object)this.original)).notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.original instanceof DTDHandler) {
            ((DTDHandler)((Object)this.original)).notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void setResult(Result result) throws IllegalArgumentException {
        if (this.original instanceof TransformerHandler) {
            ((TransformerHandler)this.original).setResult(result);
        }
    }

    @Override
    public void setSystemId(String systemID) {
        if (this.original instanceof TransformerHandler) {
            ((TransformerHandler)this.original).setSystemId(systemID);
        }
    }

    @Override
    public String getSystemId() {
        if (this.original instanceof TransformerHandler) {
            return ((TransformerHandler)this.original).getSystemId();
        }
        return null;
    }

    @Override
    public Transformer getTransformer() {
        if (this.original instanceof TransformerHandler) {
            return ((TransformerHandler)this.original).getTransformer();
        }
        return null;
    }
}

