/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.util.LinkedList;
import java.util.List;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.AllHandler;
import org.geotools.xml.handlers.xsi.AttributeGroupHandler;
import org.geotools.xml.handlers.xsi.AttributeHandler;
import org.geotools.xml.handlers.xsi.ChoiceHandler;
import org.geotools.xml.handlers.xsi.GroupHandler;
import org.geotools.xml.handlers.xsi.SequenceHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class ExtensionHandler
extends XSIElementHandler {
    public static final String LOCALNAME = "extension";
    private String base;
    private Object child;
    private List<XSIElementHandler> attributeDec;

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.base == null ? 1 : this.base.hashCode()) * (this.child == null ? 1 : this.child.hashCode());
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            logger.fine("Getting Handler for " + localName + " inside Extension");
            if ("all".equalsIgnoreCase(localName)) {
                AllHandler ah = new AllHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one 'all' declaration.");
                }
                this.child = ah;
                return ah;
            }
            if ("attribute".equalsIgnoreCase(localName)) {
                if (this.attributeDec == null) {
                    this.attributeDec = new LinkedList<XSIElementHandler>();
                }
                AttributeHandler ah = new AttributeHandler();
                this.attributeDec.add(ah);
                return ah;
            }
            if ("attributeGroup".equalsIgnoreCase(localName)) {
                if (this.attributeDec == null) {
                    this.attributeDec = new LinkedList<XSIElementHandler>();
                }
                AttributeGroupHandler ah = new AttributeGroupHandler();
                this.attributeDec.add(ah);
                return ah;
            }
            if ("choice".equalsIgnoreCase(localName)) {
                ChoiceHandler ah = new ChoiceHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one 'choice' declaration.");
                }
                this.child = ah;
                return ah;
            }
            if ("group".equalsIgnoreCase(localName)) {
                GroupHandler ah = new GroupHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one 'group' declaration.");
                }
                this.child = ah;
                return ah;
            }
            if ("sequence".equalsIgnoreCase(localName)) {
                SequenceHandler ah = new SequenceHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException(this.getLocalName() + " may only have one 'sequence' declaration.");
                }
                this.child = ah;
                return ah;
            }
        }
        logger.info("Handler not found for " + localName + " in Extension");
        return null;
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) {
        this.base = atts.getValue("", "base");
        if (this.base == null) {
            this.base = atts.getValue(namespaceURI, "base");
        }
    }

    public List getAttributeDeclarations() {
        return this.attributeDec;
    }

    public String getBase() {
        return this.base;
    }

    public Object getChild() {
        return this.child;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }
}

