/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.Classes;
import org.geotools.util.XArray;

public class Arguments {
    private final String[] arguments;
    public final PrintWriter out;
    public final PrintWriter err;
    public final Locale locale;
    private final String encoding;

    public Arguments(String ... args) {
        this.arguments = (String[])args.clone();
        this.locale = this.getLocale(this.getOptionalString("-locale"));
        this.encoding = this.getOptionalString("-encoding");
        PrintWriter out = null;
        IOException error = null;
        if (this.encoding != null) {
            try {
                out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true);
            }
            catch (IOException exception) {
                error = exception;
            }
        }
        if (out == null) {
            out = Arguments.getPrintWriter(System.out);
        }
        this.out = out;
        this.err = Arguments.getPrintWriter(System.err);
        if (error != null) {
            this.illegalArgument(error);
        }
    }

    private Locale getLocale(String locale) throws IllegalArgumentException {
        if (locale != null) {
            String[] s = Pattern.compile("_").split(locale);
            switch (s.length) {
                case 1: {
                    return new Locale(s[0]);
                }
                case 2: {
                    return new Locale(s[0], s[1]);
                }
                case 3: {
                    return new Locale(s[0], s[1], s[2]);
                }
            }
            this.illegalArgument(new IllegalArgumentException(MessageFormat.format("Bad local: {0}", locale)));
        }
        return Locale.getDefault();
    }

    public String getOptionalString(String name) {
        for (int i = 0; i < this.arguments.length; ++i) {
            String arg = this.arguments[i];
            if (arg == null) continue;
            arg = arg.trim();
            String value = "";
            int split = arg.indexOf(61);
            if (split >= 0) {
                value = arg.substring(split + 1).trim();
                arg = arg.substring(0, split).trim();
            }
            if (!arg.equalsIgnoreCase(name)) continue;
            this.arguments[i] = null;
            if (value.length() != 0) {
                return value;
            }
            while (++i < this.arguments.length) {
                value = this.arguments[i];
                this.arguments[i] = null;
                if (value == null) break;
                value = value.trim();
                if (split >= 0) {
                    return value;
                }
                if (!value.equals("=")) {
                    return value.startsWith("=") ? value.substring(1).trim() : value;
                }
                split = 0;
            }
            this.illegalArgument(new IllegalArgumentException(MessageFormat.format("Missing value for parameter \"{0}\".", arg)));
            return null;
        }
        return null;
    }

    public String getRequiredString(String name) {
        String value = this.getOptionalString(name);
        if (value == null) {
            this.illegalArgument(new IllegalArgumentException(MessageFormat.format("Parameter \"{0}\" is missing.", name)));
        }
        return value;
    }

    public Integer getOptionalInteger(String name) {
        String value = this.getOptionalString(name);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return null;
    }

    public int getRequiredInteger(String name) {
        String value = this.getRequiredString(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return 0;
    }

    public Double getOptionalDouble(String name) {
        String value = this.getOptionalString(name);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return null;
    }

    public double getRequiredDouble(String name) {
        String value = this.getRequiredString(name);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return Double.NaN;
    }

    public Boolean getOptionalBoolean(String name) {
        String value = this.getOptionalString(name);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            this.illegalArgument(new IllegalArgumentException(value));
        }
        return null;
    }

    public boolean getRequiredBoolean(String name) {
        String value = this.getRequiredString(name);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            this.illegalArgument(new IllegalArgumentException(value));
        }
        return false;
    }

    public boolean getFlag(String name) {
        for (int i = 0; i < this.arguments.length; ++i) {
            String arg = this.arguments[i];
            if (arg == null || !(arg = arg.trim()).equalsIgnoreCase(name)) continue;
            this.arguments[i] = null;
            return true;
        }
        return false;
    }

    public static Reader getReader(InputStream in) {
        Console candidate;
        if (in == System.in && (candidate = System.console()) != null) {
            return candidate.reader();
        }
        return new InputStreamReader(in);
    }

    public static Writer getWriter(OutputStream out) {
        Console candidate;
        if ((out == System.out || out == System.err) && (candidate = System.console()) != null) {
            return candidate.writer();
        }
        return new OutputStreamWriter(out);
    }

    public static PrintWriter getPrintWriter(PrintStream out) {
        Console candidate;
        if ((out == System.out || out == System.err) && (candidate = System.console()) != null) {
            return candidate.writer();
        }
        return new PrintWriter(out, true);
    }

    public String[] getRemainingArguments(int max) {
        int count = 0;
        String[] left = new String[Math.min(max, this.arguments.length)];
        for (String arg : this.arguments) {
            if (arg == null) continue;
            if (count >= max) {
                this.illegalArgument(new IllegalArgumentException(MessageFormat.format("Parameter \"{0}\" was not expected.", arg)));
            }
            left[count++] = arg;
        }
        return XArray.resize(left, count);
    }

    public String[] getRemainingArguments(int max, char forbiddenPrefix) {
        String[] arguments;
        for (String s : arguments = this.getRemainingArguments(max)) {
            String argument = s;
            if (argument == null || (argument = argument.trim()).length() == 0 || argument.charAt(0) != forbiddenPrefix) continue;
            this.illegalArgument(new IllegalArgumentException(MessageFormat.format("Unknow parameter: {0}", argument)));
        }
        return arguments;
    }

    public void printSummary(Exception exception) {
        String type = Classes.getShortClassName(exception);
        String message = exception.getLocalizedMessage();
        if (message == null) {
            message = Vocabulary.format(152, type);
        } else {
            this.err.print(type);
            this.err.print(": ");
        }
        this.err.println(message);
        this.err.flush();
    }

    protected void illegalArgument(Exception exception) {
        this.printSummary(exception);
        System.exit(1);
    }
}

