/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.GraphicImpl;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;

public class FillImpl
implements Fill,
Cloneable {
    public static final Fill DEFAULT = new ConstantFill(){
        final Expression COLOR = ConstantExpression.color(new Color(128, 128, 128));
        final Expression BGCOLOR = ConstantExpression.color(new Color(255, 255, 255, 0));
        final Expression OPACITY = ConstantExpression.ONE;

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        @Override
        public Expression getColor() {
            return this.COLOR;
        }

        @Override
        public Expression getOpacity() {
            return this.OPACITY;
        }

        @Override
        public Graphic getGraphicFill() {
            return null;
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object extraData) {
            this.cannotModifyConstant();
            return null;
        }
    };
    public static final Fill NULL = new ConstantFill(){

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        @Override
        public Expression getColor() {
            return ConstantExpression.NULL;
        }

        @Override
        public Expression getOpacity() {
            return ConstantExpression.NULL;
        }

        @Override
        public Graphic getGraphicFill() {
            return GraphicImpl.NULL;
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object extraData) {
            this.cannotModifyConstant();
            return null;
        }
    };
    private FilterFactory filterFactory;
    private Expression color = null;
    private Expression opacity = null;
    private Graphic graphicFill = null;

    protected FillImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public FillImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    @Override
    public Expression getColor() {
        return this.color;
    }

    @Override
    public void setColor(Expression rgb) {
        if (this.color == rgb) {
            return;
        }
        this.color = rgb;
    }

    public void setColor(String rgb) {
        if (this.color.toString().equals(rgb)) {
            return;
        }
        this.setColor(this.filterFactory.literal(rgb));
    }

    @Override
    public Expression getOpacity() {
        return this.opacity;
    }

    @Override
    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        this.opacity = opacity;
    }

    public void setOpacity(String opacity) {
        if (this.opacity.toString().equals(opacity)) {
            return;
        }
        this.setOpacity(this.filterFactory.literal(opacity));
    }

    @Override
    public Graphic getGraphicFill() {
        return this.graphicFill;
    }

    @Override
    public void setGraphicFill(Graphic graphicFill) {
        if (this.graphicFill == graphicFill) {
            return;
        }
        this.graphicFill = GraphicImpl.cast(graphicFill);
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            FillImpl clone = (FillImpl)super.clone();
            if (this.graphicFill != null) {
                clone.graphicFill = (Graphic)((Cloneable)((Object)this.graphicFill)).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone FillImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.graphicFill != null) {
            result = 1000003 * result + this.graphicFill.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FillImpl) {
            FillImpl other = (FillImpl)oth;
            return Utilities.equals(this.color, other.color) && Utilities.equals(this.opacity, other.opacity) && Utilities.equals(this.graphicFill, other.graphicFill);
        }
        return false;
    }

    static FillImpl cast(Fill fill) {
        if (fill == null) {
            return null;
        }
        if (fill instanceof FillImpl) {
            return (FillImpl)fill;
        }
        FillImpl copy = new FillImpl();
        copy.color = fill.getColor();
        copy.graphicFill = GraphicImpl.cast(fill.getGraphicFill());
        copy.opacity = fill.getOpacity();
        return copy;
    }

    public static abstract class ConstantFill
    implements Fill {
        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Fill may not be modified");
        }

        @Override
        public void setColor(Expression color) {
            this.cannotModifyConstant();
        }

        public void setBackgroundColor(Expression backgroundColor) {
            this.cannotModifyConstant();
        }

        @Override
        public void setOpacity(Expression opacity) {
            this.cannotModifyConstant();
        }

        @Override
        public void setGraphicFill(Graphic graphicFill) {
            this.cannotModifyConstant();
        }

        @Override
        public void accept(StyleVisitor visitor) {
            this.cannotModifyConstant();
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object data) {
            this.cannotModifyConstant();
            return null;
        }
    }
}

