/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;

final class ConcatenatedTransformDirect2D
extends ConcatenatedTransformDirect
implements MathTransform2D {
    private static final long serialVersionUID = 6009454091075588885L;
    private final MathTransform2D transform1;
    private final MathTransform2D transform2;

    public ConcatenatedTransformDirect2D(MathTransform2D transform1, MathTransform2D transform2) {
        super(transform1, transform2);
        this.transform1 = transform1;
        this.transform2 = transform2;
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 2 && this.getTargetDimensions() == 2;
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        assert (this.isValid());
        ptDst = this.transform1.transform(ptSrc, ptDst);
        return this.transform2.transform(ptDst, ptDst);
    }

    @Override
    public Shape createTransformedShape(Shape shape) throws TransformException {
        assert (this.isValid());
        return this.transform2.createTransformedShape(this.transform1.createTransformedShape(shape));
    }

    @Override
    public Matrix derivative(Point2D point) throws TransformException {
        XMatrix matrix1 = ConcatenatedTransformDirect2D.toXMatrix(this.transform1.derivative(point));
        XMatrix matrix2 = ConcatenatedTransformDirect2D.toXMatrix(this.transform2.derivative(this.transform1.transform(point, null)));
        matrix2.multiply(matrix1);
        return matrix2;
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }
}

