/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.geometry.Position;
import org.geotools.referencing.operation.builder.Quadrilateral;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;

class TriangulationFactory {
    private List<TINTriangle> triangles;

    protected TriangulationFactory(Quadrilateral quad, Position ... pt) throws TriangulationException {
        ArrayList<Position> vertices = new ArrayList<Position>(Arrays.asList(pt));
        if (!quad.containsAll(vertices)) {
            throw new TriangulationException("Point is outside triangles");
        }
        this.triangles = quad.getTriangles();
        for (Position vertex : vertices) {
            this.insertPoint(vertex);
        }
    }

    public List<TINTriangle> getTriangulation() {
        return this.triangles;
    }

    protected void recursiveDelaunayTest(List<TINTriangle> ChangedTriangles) throws TriangulationException {
        int i = ChangedTriangles.size();
        while (i != 0) {
            this.triangles.removeAll(ChangedTriangles);
            ChangedTriangles = this.insertTriangles(ChangedTriangles);
            i = ChangedTriangles.size();
        }
    }

    protected List<TINTriangle> insertTriangles(List<TINTriangle> trian) throws TriangulationException {
        ArrayList<TINTriangle> ChangedTriangles = new ArrayList<TINTriangle>();
        for (TINTriangle trig : trian) {
            if (trig.getAdjacentTriangles().size() <= 2) {
                this.triangles.add(trig);
                continue;
            }
            ChangedTriangles.addAll(this.delaunayCircleTest(trig));
        }
        return ChangedTriangles;
    }

    private List<TINTriangle> delaunayCircleTest(TINTriangle triangle) throws TriangulationException {
        ArrayList<TINTriangle> changedTriangles = new ArrayList<TINTriangle>();
        Iterator<TINTriangle> j = triangle.getAdjacentTriangles().iterator();
        int ct = 0;
        while (j.hasNext() && changedTriangles.size() == ct) {
            TINTriangle adjacent = j.next();
            if (triangle.getCircumCicle().contains(adjacent.p1) || triangle.getCircumCicle().contains(adjacent.p0) || triangle.getCircumCicle().contains(adjacent.p2)) {
                this.triangles.remove(triangle);
                this.triangles.remove(adjacent);
                ArrayList<TINTriangle> NewTriangles = new ArrayList<TINTriangle>(this.alternativeTriangles(triangle, adjacent));
                this.triangles.addAll(NewTriangles);
                changedTriangles = NewTriangles;
                continue;
            }
            if (this.triangles.contains(triangle)) continue;
            this.triangles.add(triangle);
        }
        return changedTriangles;
    }

    public void insertPoint(Position newVertex) throws TriangulationException {
        TINTriangle triangleContainingNewVertex = this.triangleContains(newVertex);
        if (triangleContainingNewVertex == null) {
            throw new TriangulationException("Point is outside triangles");
        }
        this.triangles.remove(triangleContainingNewVertex);
        this.recursiveDelaunayTest(triangleContainingNewVertex.subTriangles(newVertex));
    }

    private List<TINTriangle> alternativeTriangles(TINTriangle ABC, TINTriangle BCD) throws TriangulationException {
        ArrayList<Position> ABCvertices = new ArrayList<Position>();
        ArrayList<Position> BCDvertices = new ArrayList<Position>();
        ABCvertices.add(ABC.p0);
        ABCvertices.add(ABC.p1);
        ABCvertices.add(ABC.p2);
        BCDvertices.add(BCD.p0);
        BCDvertices.add(BCD.p1);
        BCDvertices.add(BCD.p2);
        ArrayList<Position> sharedVertices = new ArrayList<Position>();
        ArrayList<Position> unsharedVertices = new ArrayList<Position>();
        for (Position vertex : ABCvertices) {
            if (!BCDvertices.contains(vertex)) {
                unsharedVertices.add(vertex);
                continue;
            }
            if (BCDvertices.contains(vertex)) {
                sharedVertices.add(vertex);
                BCDvertices.remove(vertex);
                continue;
            }
            throw new TriangulationException("should never reach here");
        }
        unsharedVertices.addAll(BCDvertices);
        if (sharedVertices.size() < 2) {
            throw new TriangulationException("Unable to make alternative triangles");
        }
        ABC.removeAdjacent(BCD);
        BCD.removeAdjacent(ABC);
        TINTriangle trigA = new TINTriangle((Position)sharedVertices.get(0), (Position)unsharedVertices.get(0), (Position)unsharedVertices.get(1));
        TINTriangle trigB = new TINTriangle((Position)unsharedVertices.get(0), (Position)unsharedVertices.get(1), (Position)sharedVertices.get(1));
        trigA.addAdjacentTriangle(trigB);
        trigB.addAdjacentTriangle(trigA);
        trigA.tryToAddAdjacent(BCD.getAdjacentTriangles());
        trigA.tryToAddAdjacent(ABC.getAdjacentTriangles());
        trigB.tryToAddAdjacent(BCD.getAdjacentTriangles());
        trigB.tryToAddAdjacent(ABC.getAdjacentTriangles());
        ArrayList<TINTriangle> list = new ArrayList<TINTriangle>();
        list.add(trigA);
        list.add(trigB);
        for (TINTriangle trig : ABC.getAdjacentTriangles()) {
            trig.removeAdjacent(ABC);
            trig.tryToAddAdjacent(list);
        }
        for (TINTriangle trig : BCD.getAdjacentTriangles()) {
            trig.removeAdjacent(BCD);
            trig.tryToAddAdjacent(list);
        }
        return list;
    }

    private TINTriangle triangleContains(Position p) {
        for (TINTriangle triangle : this.triangles) {
            if (!triangle.containsOrIsVertex(p)) continue;
            return triangle;
        }
        return null;
    }
}

