/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.MessageFormat;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.util.factory.Hints;

public class HTTP_AuthorityFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String BASE_URL = "http://www.opengis.net/gml/srs/";

    public HTTP_AuthorityFactory() {
        this((Hints)null);
    }

    public HTTP_AuthorityFactory(Hints userHints) {
        this(HTTP_AuthorityFactory.getFactory(userHints, "http"));
    }

    public HTTP_AuthorityFactory(AllAuthoritiesFactory factory) {
        super(factory);
    }

    static boolean defaultAxisOrderHints(Hints hints, String authority) {
        Object value = null;
        if (hints != null) {
            value = hints.get(Hints.FORCE_AXIS_ORDER_HONORING);
        }
        if (value == null) {
            value = Hints.getSystemDefault(Hints.FORCE_AXIS_ORDER_HONORING);
        }
        if (value instanceof CharSequence) {
            String list = value.toString();
            int i = 0;
            while ((i = list.indexOf(authority, i)) >= 0) {
                int j;
                if (!(i != 0 && Character.isJavaIdentifierPart(list.charAt(i - 1)) || (j = i + authority.length()) != list.length() && Character.isJavaIdentifierPart(list.charAt(j)))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static AllAuthoritiesFactory getFactory(Hints hints, String authority) {
        if (!HTTP_AuthorityFactory.defaultAxisOrderHints(hints, authority)) {
            hints = new Hints(hints);
            hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        }
        return new AllAuthoritiesFactory(hints);
    }

    @Override
    public Citation getAuthority() {
        return Citations.HTTP_OGC;
    }

    @Override
    protected String toBackingFactoryCode(String code) throws FactoryException {
        int split;
        int length;
        if (((String)(code = ((String)code).trim())).regionMatches(true, 0, BASE_URL, 0, length = BASE_URL.length()) && ((String)(code = ((String)code).substring(length))).indexOf(47) < 0 && (split = ((String)code).indexOf(35)) >= 0 && ((String)code).indexOf(35, split + 1) < 0) {
            String authority = ((String)code).substring(0, split).trim();
            int ext = authority.lastIndexOf(46);
            if (ext > 0) {
                authority = authority.substring(0, ext);
            }
            code = ((String)code).substring(split + 1).trim();
            code = authority + ":" + (String)code;
            return code;
        }
        throw new NoSuchAuthorityCodeException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "code", code), BASE_URL, (String)code);
    }
}

