/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.util.Classes;

abstract class AuthorityFactoryProxy {
    private static final List<Class<? extends IdentifiedObject>> TYPES = new ArrayList<Class>(Arrays.asList(CoordinateOperation.class, OperationMethod.class, ParameterDescriptor.class, ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class, ImageCRS.class, DerivedCRS.class, VerticalCRS.class, TemporalCRS.class, EngineeringCRS.class, CompoundCRS.class, CoordinateReferenceSystem.class, CoordinateSystemAxis.class, CartesianCS.class, EllipsoidalCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, VerticalCS.class, TimeCS.class, CoordinateSystem.class, PrimeMeridian.class, Ellipsoid.class, GeodeticDatum.class, ImageDatum.class, VerticalDatum.class, TemporalDatum.class, EngineeringDatum.class, Datum.class, IdentifiedObject.class));

    AuthorityFactoryProxy() {
    }

    public static AuthorityFactoryProxy getInstance(AuthorityFactory factory, Class<? extends IdentifiedObject> type) {
        AbstractAuthorityFactory.ensureNonNull("type", type);
        AbstractAuthorityFactory.ensureNonNull("factory", factory);
        type = AuthorityFactoryProxy.getType(type);
        if (factory instanceof CRSAuthorityFactory) {
            CRSAuthorityFactory crsFactory = (CRSAuthorityFactory)factory;
            if (type.equals(ProjectedCRS.class)) {
                return new Projected(crsFactory);
            }
            if (type.equals(GeographicCRS.class)) {
                return new Geographic(crsFactory);
            }
            if (type.equals(CoordinateReferenceSystem.class)) {
                return new CRS(crsFactory);
            }
        }
        return new Default(factory, type);
    }

    public static Class<? extends IdentifiedObject> getType(Class<? extends IdentifiedObject> type) throws IllegalArgumentException {
        for (Class<? extends IdentifiedObject> candidate : TYPES) {
            if (!candidate.isAssignableFrom(type)) continue;
            return candidate;
        }
        throw new IllegalArgumentException(MessageFormat.format("Class '{0}' is illegal. It must be '{1}' or a derivated class.", type, IdentifiedObject.class));
    }

    public abstract Class<? extends IdentifiedObject> getType();

    public abstract AuthorityFactory getAuthorityFactory();

    public final Set<String> getAuthorityCodes() throws FactoryException {
        return this.getAuthorityFactory().getAuthorityCodes(this.getType());
    }

    public abstract IdentifiedObject create(String var1) throws NoSuchAuthorityCodeException, FactoryException;

    public String toString() {
        return this.toString(AuthorityFactoryProxy.class);
    }

    final String toString(Class owner) {
        AuthorityFactory factory = this.getAuthorityFactory();
        return Classes.getShortName(owner) + "[" + Classes.getShortName(this.getType()) + " in " + Classes.getShortClassName(factory) + "(\"" + factory.getAuthority().getTitle() + "\")]";
    }

    private static final class Projected
    extends CRS {
        protected Projected(CRSAuthorityFactory factory) {
            super(factory);
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return ProjectedCRS.class;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            return this.factory.createProjectedCRS(code);
        }
    }

    private static final class Geographic
    extends CRS {
        protected Geographic(CRSAuthorityFactory factory) {
            super(factory);
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return GeographicCRS.class;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            return this.factory.createGeographicCRS(code);
        }
    }

    private static class CRS
    extends AuthorityFactoryProxy {
        protected final CRSAuthorityFactory factory;

        protected CRS(CRSAuthorityFactory factory) {
            this.factory = factory;
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return CoordinateReferenceSystem.class;
        }

        @Override
        public final AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            return this.factory.createCoordinateReferenceSystem(code);
        }
    }

    private static final class Default
    extends AuthorityFactoryProxy {
        private static final Class[] PARAMETERS = new Class[]{String.class};
        private final AuthorityFactory factory;
        private final Class<? extends IdentifiedObject> type;
        private final Method method;

        Default(AuthorityFactory factory, Class<? extends IdentifiedObject> type) throws IllegalArgumentException {
            Method[] candidates;
            this.factory = factory;
            this.type = type;
            for (Method c : candidates = factory.getClass().getMethods()) {
                if (!c.getName().startsWith("create") || !type.equals(c.getReturnType()) || !Arrays.equals(PARAMETERS, c.getParameterTypes())) continue;
                this.method = c;
                return;
            }
            throw new IllegalArgumentException(MessageFormat.format("Type \"{0}\" is unknow in this context.", type));
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return this.type;
        }

        @Override
        public AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            try {
                return (IdentifiedObject)this.method.invoke((Object)this.factory, code);
            }
            catch (InvocationTargetException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof FactoryException) {
                    throw (FactoryException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new FactoryException(cause.getLocalizedMessage(), cause);
            }
            catch (IllegalAccessException exception) {
                throw new FactoryException(exception.getLocalizedMessage(), exception);
            }
        }
    }
}

