/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.BinaryPrefix;
import javax.measure.MetricPrefix;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import org.geotools.measure.PrefixDefinition;
import org.geotools.measure.UnitDefinition;
import org.geotools.measure.UnitFormatter;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.AnnotatedUnit;
import tech.units.indriya.unit.BaseUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;

public class BaseUnitFormatter
implements UnitFormatter {
    private static final char MIDDLE_DOT = '\u00b7';
    private static final String[] METRIC_PREFIX_SYMBOLS = Stream.of(MetricPrefix.values()).map(Prefix::getSymbol).collect(Collectors.toList()).toArray(new String[0]);
    private static final UnitConverter[] METRIC_PREFIX_CONVERTERS = Stream.of(MetricPrefix.values()).map(MultiplyConverter::ofPrefix).collect(Collectors.toList()).toArray(new UnitConverter[0]);
    private static final String[] BINARY_PREFIX_SYMBOLS = Stream.of(BinaryPrefix.values()).map(Prefix::getSymbol).collect(Collectors.toList()).toArray(new String[0]);
    private static final UnitConverter[] BINARY_PREFIX_CONVERTERS = Stream.of(BinaryPrefix.values()).map(MultiplyConverter::ofPrefix).collect(Collectors.toList()).toArray(new UnitConverter[0]);
    final Map<String, Unit<?>> nameToUnit = new HashMap();
    final Map<Unit<?>, String> unitToName = new HashMap();

    public BaseUnitFormatter(List<UnitDefinition> unitDefinitions) {
        for (UnitDefinition unitDefinition : unitDefinitions) {
            Unit<?> unit = unitDefinition.getUnit();
            String unitSymbol = unitDefinition.getSymbolOverride() != null ? unitDefinition.getSymbolOverride() : unit.getSymbol();
            this.addLabel(unit, unitSymbol);
            for (PrefixDefinition prefix : unitDefinition.getPrefixes()) {
                this.addUnit(unit, unitSymbol, prefix);
            }
            for (String alias : unitDefinition.getAliases()) {
                this.addAlias(unit, alias);
            }
            for (PrefixDefinition prefix : unitDefinition.getPrefixes()) {
                for (String alias : unitDefinition.getAliases()) {
                    this.addAlias(unit, alias, prefix);
                }
            }
        }
    }

    private void addUnit(Unit<?> unit, String unitSymbol, PrefixDefinition prefix) {
        Unit<?> prefixedUnit = unit.prefix(prefix.getPrefix());
        String prefixString = prefix.getPrefix().getSymbol();
        String prefixedSymbol = prefixString + unitSymbol;
        this.addLabel(prefixedUnit, prefixedSymbol);
        for (String prefixAlias : prefix.getPrefixAliases()) {
            this.addLabel(prefixedUnit, prefixAlias + unitSymbol);
        }
    }

    private void addAlias(Unit<?> unit, String unitSymbol, PrefixDefinition prefix) {
        Unit<?> prefixedUnit = unit.prefix(prefix.getPrefix());
        String prefixString = prefix.getPrefix().getSymbol();
        String prefixedSymbol = prefixString + unitSymbol;
        this.addAlias(prefixedUnit, prefixedSymbol);
        for (String prefixAlias : prefix.getPrefixAliases()) {
            this.addAlias(prefixedUnit, prefixAlias + unitSymbol);
        }
    }

    public final Unit<?> parseObject(String source, ParsePosition pos) throws MeasurementParseException {
        return this.parseProductUnit(source, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLabel(Unit<?> unit, String label) {
        if (!this.isValidIdentifier(label)) {
            throw new IllegalArgumentException("Label: " + label + " is not a valid identifier.");
        }
        BaseUnitFormatter baseUnitFormatter = this;
        synchronized (baseUnitFormatter) {
            this.nameToUnit.put(label, unit);
            this.unitToName.put(unit, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAlias(Unit<?> unit, String alias) {
        if (!this.isValidIdentifier(alias)) {
            throw new IllegalArgumentException("Alias: " + alias + " is not a valid identifier.");
        }
        BaseUnitFormatter baseUnitFormatter = this;
        synchronized (baseUnitFormatter) {
            this.nameToUnit.put(alias, unit);
        }
    }

    protected boolean isValidIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return BaseUnitFormatter.isUnitIdentifierPart(name.charAt(0));
    }

    protected static boolean isUnitIdentifierPart(char ch) {
        return Character.isLetter(ch) || !Character.isWhitespace(ch) && !Character.isDigit(ch) && ch != '\u00b7' && ch != '*' && ch != '/' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '^' && ch != '+' && ch != '-';
    }

    protected String nameFor(Unit<?> unit) {
        String label = this.unitToName.get(unit);
        if (label != null) {
            return label;
        }
        if (unit instanceof BaseUnit) {
            return ((BaseUnit)unit).getSymbol();
        }
        if (unit instanceof AlternateUnit) {
            return ((AlternateUnit)unit).getSymbol();
        }
        if (unit instanceof TransformedUnit) {
            TransformedUnit tfmUnit = (TransformedUnit)unit;
            if (tfmUnit.getSymbol() != null) {
                return tfmUnit.getSymbol();
            }
            Unit baseUnit = tfmUnit.getParentUnit();
            UnitConverter cvtr = tfmUnit.getConverter();
            StringBuilder result = new StringBuilder();
            String baseUnitName = baseUnit.toString();
            String prefix = this.prefixFor(cvtr);
            if (baseUnitName.indexOf(183) >= 0 || baseUnitName.indexOf(42) >= 0 || baseUnitName.indexOf(47) >= 0) {
                result.append('(');
                result.append(baseUnitName);
                result.append(')');
            } else {
                result.append(baseUnitName);
            }
            if (prefix != null) {
                result.insert(0, prefix);
            } else if (cvtr instanceof AddConverter) {
                result.append('+');
                result.append(((AddConverter)cvtr).getOffset());
            } else if (cvtr instanceof MultiplyConverter) {
                Number scaleFactor = ((MultiplyConverter)cvtr).getFactor();
                if (scaleFactor instanceof RationalNumber) {
                    RationalNumber rational = (RationalNumber)scaleFactor;
                    RationalNumber reciprocal = rational.reciprocal();
                    if (reciprocal.isInteger()) {
                        result.append('/');
                        result.append(reciprocal.toString());
                    } else {
                        result.append('*');
                        result.append(scaleFactor);
                    }
                } else {
                    result.append('*');
                    result.append(scaleFactor);
                }
            } else {
                return "[" + baseUnit + "?]";
            }
            return result.toString();
        }
        if (unit instanceof AnnotatedUnit) {
            AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
            StringBuilder annotable = new StringBuilder(this.nameFor(annotatedUnit.getActualUnit()));
            if (annotatedUnit.getAnnotation() != null) {
                annotable.append('{');
                annotable.append(annotatedUnit.getAnnotation());
                annotable.append('}');
            }
            return annotable.toString();
        }
        return null;
    }

    protected String prefixFor(UnitConverter converter) {
        for (int i = 0; i < METRIC_PREFIX_CONVERTERS.length; ++i) {
            if (!METRIC_PREFIX_CONVERTERS[i].equals(converter)) continue;
            return METRIC_PREFIX_SYMBOLS[i];
        }
        for (int j = 0; j < BINARY_PREFIX_CONVERTERS.length; ++j) {
            if (!BINARY_PREFIX_CONVERTERS[j].equals(converter)) continue;
            return BINARY_PREFIX_SYMBOLS[j];
        }
        return null;
    }

    public Unit<? extends Quantity> parseSingleUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
        int startIndex = pos.getIndex();
        String name = BaseUnitFormatter.readIdentifier(csq, pos);
        Unit<?> unit = this.nameToUnit.get(name);
        BaseUnitFormatter.check(unit != null, name + " not recognized", csq, startIndex);
        return unit;
    }

    public Unit<? extends Quantity> parseProductUnit(CharSequence csq, ParsePosition pos) throws MeasurementParseException {
        Unit<Object> result = null;
        if (csq == null) {
            throw new MeasurementParseException("Cannot parse null", csq, pos.getIndex());
        }
        String name = csq.toString();
        result = this.nameToUnit.get(name);
        if (result != null) {
            return result;
        }
        result = AbstractUnit.ONE;
        Token token = BaseUnitFormatter.nextToken(csq, pos);
        switch (token) {
            case IDENTIFIER: {
                result = this.parseSingleUnit(csq, pos);
                break;
            }
            case OPEN_PAREN: {
                pos.setIndex(pos.getIndex() + 1);
                result = this.parseProductUnit(csq, pos);
                token = BaseUnitFormatter.nextToken(csq, pos);
                BaseUnitFormatter.check(token == Token.CLOSE_PAREN, "')' expected", csq, pos.getIndex());
                pos.setIndex(pos.getIndex() + 1);
                break;
            }
        }
        token = BaseUnitFormatter.nextToken(csq, pos);
        while (true) {
            switch (token) {
                case EXPONENT: {
                    Exponent e = BaseUnitFormatter.readExponent(csq, pos);
                    if (e.pow != 1) {
                        result = result.pow(e.pow);
                    }
                    if (e.root == 1) break;
                    result = result.root(e.root);
                    break;
                }
                case MULTIPLY: {
                    pos.setIndex(pos.getIndex() + 1);
                    token = BaseUnitFormatter.nextToken(csq, pos);
                    if (token == Token.INTEGER) {
                        long n = BaseUnitFormatter.readLong(csq, pos);
                        if (n == 1L) break;
                        result = result.multiply(n);
                        break;
                    }
                    if (token == Token.FLOAT) {
                        double d = BaseUnitFormatter.readDouble(csq, pos);
                        if (d == 1.0) break;
                        result = result.multiply(d);
                        break;
                    }
                    result = result.multiply(this.parseProductUnit(csq, pos));
                    break;
                }
                case DIVIDE: {
                    pos.setIndex(pos.getIndex() + 1);
                    token = BaseUnitFormatter.nextToken(csq, pos);
                    if (token == Token.INTEGER) {
                        long n = BaseUnitFormatter.readLong(csq, pos);
                        if (n == 1L) break;
                        result = result.divide(n);
                        break;
                    }
                    if (token == Token.FLOAT) {
                        double d = BaseUnitFormatter.readDouble(csq, pos);
                        if (d == 1.0) break;
                        result = result.divide(d);
                        break;
                    }
                    result = result.divide(this.parseProductUnit(csq, pos));
                    break;
                }
                case PLUS: {
                    pos.setIndex(pos.getIndex() + 1);
                    token = BaseUnitFormatter.nextToken(csq, pos);
                    if (token == Token.INTEGER) {
                        long n = BaseUnitFormatter.readLong(csq, pos);
                        if (n == 1L) break;
                        result = result.shift(n);
                        break;
                    }
                    if (token == Token.FLOAT) {
                        double d = BaseUnitFormatter.readDouble(csq, pos);
                        if (d == 1.0) break;
                        result = result.shift(d);
                        break;
                    }
                    throw new MeasurementParseException("not a number", csq, pos.getIndex());
                }
                case EOF: 
                case CLOSE_PAREN: {
                    return result;
                }
                default: {
                    throw new MeasurementParseException("unexpected token " + token, csq, pos.getIndex());
                }
            }
            token = BaseUnitFormatter.nextToken(csq, pos);
        }
    }

    private static Token nextToken(CharSequence csq, ParsePosition pos) {
        int length = csq.length();
        while (pos.getIndex() < length) {
            char c = csq.charAt(pos.getIndex());
            if (BaseUnitFormatter.isUnitIdentifierPart(c)) {
                return Token.IDENTIFIER;
            }
            if (c == '(') {
                return Token.OPEN_PAREN;
            }
            if (c == ')') {
                return Token.CLOSE_PAREN;
            }
            if (c == '^' || c == '\u00b9' || c == '\u00b2' || c == '\u00b3') {
                return Token.EXPONENT;
            }
            if (c == '*') {
                if (csq.length() == pos.getIndex() + 1) {
                    throw new MeasurementParseException("unexpected token " + Token.EOF, csq, pos.getIndex());
                }
                char c2 = csq.charAt(pos.getIndex() + 1);
                return c2 == '*' ? Token.EXPONENT : Token.MULTIPLY;
            }
            if (c == '\u00b7') {
                return Token.MULTIPLY;
            }
            if (c == '/') {
                return Token.DIVIDE;
            }
            if (c == '+') {
                return Token.PLUS;
            }
            if (c == '-' || Character.isDigit(c)) {
                int index = pos.getIndex() + 1;
                while (index < length && (Character.isDigit(c) || c == '-' || c == '.' || c == 'E')) {
                    if ((c = csq.charAt(index++)) != '.') continue;
                    return Token.FLOAT;
                }
                return Token.INTEGER;
            }
            pos.setIndex(pos.getIndex() + 1);
        }
        return Token.EOF;
    }

    private static void check(boolean expr, String message, CharSequence csq, int index) throws MeasurementParseException {
        if (!expr) {
            throw new MeasurementParseException((CharSequence)(message + " (in " + csq + " at index " + index + ")"), index);
        }
    }

    private static Exponent readExponent(CharSequence csq, ParsePosition pos) {
        char c = csq.charAt(pos.getIndex());
        if (c == '^') {
            pos.setIndex(pos.getIndex() + 1);
        } else if (c == '*') {
            pos.setIndex(pos.getIndex() + 2);
        }
        int length = csq.length();
        int pow = 0;
        boolean isPowNegative = false;
        boolean parseRoot = false;
        block13: while (pos.getIndex() < length) {
            c = csq.charAt(pos.getIndex());
            switch (c) {
                case '-': {
                    isPowNegative = true;
                    break;
                }
                case '\u00b9': {
                    pow = pow * 10 + 1;
                    break;
                }
                case '\u00b2': {
                    pow = pow * 10 + 2;
                    break;
                }
                case '\u00b3': {
                    pow = pow * 10 + 3;
                    break;
                }
                case ':': {
                    parseRoot = true;
                    break block13;
                }
                default: {
                    if (c < '0' || c > '9') break block13;
                    pow = pow * 10 + (c - 48);
                }
            }
            pos.setIndex(pos.getIndex() + 1);
        }
        if (pow == 0) {
            pow = 1;
        }
        int root = 0;
        boolean isRootNegative = false;
        if (parseRoot) {
            pos.setIndex(pos.getIndex() + 1);
            block14: while (pos.getIndex() < length) {
                c = csq.charAt(pos.getIndex());
                switch (c) {
                    case '-': {
                        isRootNegative = true;
                        break;
                    }
                    case '\u00b9': {
                        root = root * 10 + 1;
                        break;
                    }
                    case '\u00b2': {
                        root = root * 10 + 2;
                        break;
                    }
                    case '\u00b3': {
                        root = root * 10 + 3;
                        break;
                    }
                    default: {
                        if (c < '0' || c > '9') break block14;
                        root = root * 10 + (c - 48);
                    }
                }
                pos.setIndex(pos.getIndex() + 1);
            }
        }
        if (root == 0) {
            root = 1;
        }
        return new Exponent(isPowNegative ? -pow : pow, isRootNegative ? -root : root);
    }

    private static long readLong(CharSequence csq, ParsePosition pos) {
        int length = csq.length();
        int result = 0;
        boolean isNegative = false;
        while (pos.getIndex() < length) {
            char c = csq.charAt(pos.getIndex());
            if (c == '-') {
                isNegative = true;
            } else {
                if (c < '0' || c > '9') break;
                result = result * 10 + (c - 48);
            }
            pos.setIndex(pos.getIndex() + 1);
        }
        return isNegative ? (long)(-result) : (long)result;
    }

    private static double readDouble(CharSequence csq, ParsePosition pos) {
        int end;
        int length = csq.length();
        int start = pos.getIndex();
        for (end = start + 1; end < length && "0123456789+-.E".indexOf(csq.charAt(end)) >= 0; ++end) {
        }
        pos.setIndex(end + 1);
        return Double.parseDouble(csq.subSequence(start, end).toString());
    }

    private static String readIdentifier(CharSequence csq, ParsePosition pos) {
        int start;
        int length = csq.length();
        int i = start = pos.getIndex();
        while (++i < length && BaseUnitFormatter.isUnitIdentifierPart(csq.charAt(i))) {
        }
        pos.setIndex(i);
        return csq.subSequence(start, i).toString();
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        int root;
        int pow;
        int i;
        ProductUnit powerUnit;
        String name = this.nameFor(unit);
        if (name != null) {
            return appendable.append(name);
        }
        if (!(unit instanceof ProductUnit)) {
            throw new IllegalArgumentException("Cannot format given Object as a Unit");
        }
        ProductUnit productUnit = (ProductUnit)unit;
        if (productUnit.getUnitCount() == 1 && productUnit.getUnit(0) instanceof ProductUnit && this.nameFor(powerUnit = (ProductUnit)productUnit.getUnit(0)) == null) {
            return this.format(ProductUnit.ofPow(powerUnit, productUnit.getUnitPow(0)), appendable);
        }
        int invNbr = 0;
        boolean start = true;
        for (i = 0; i < productUnit.getUnitCount(); ++i) {
            pow = productUnit.getUnitPow(i);
            if (pow >= 0) {
                if (!start) {
                    appendable.append('\u00b7');
                }
                name = this.nameFor(productUnit.getUnit(i));
                root = productUnit.getUnitRoot(i);
                BaseUnitFormatter.append(appendable, name, pow, root);
                start = false;
                continue;
            }
            ++invNbr;
        }
        if (invNbr != 0) {
            if (start) {
                appendable.append('1');
            }
            appendable.append('/');
            if (invNbr > 1) {
                appendable.append('(');
            }
            start = true;
            for (i = 0; i < productUnit.getUnitCount(); ++i) {
                pow = productUnit.getUnitPow(i);
                if (pow >= 0) continue;
                name = this.nameFor(productUnit.getUnit(i));
                root = productUnit.getUnitRoot(i);
                if (!start) {
                    appendable.append('\u00b7');
                }
                BaseUnitFormatter.append(appendable, name, -pow, root);
                start = false;
            }
            if (invNbr > 1) {
                appendable.append(')');
            }
        }
        return appendable;
    }

    private static void append(Appendable appendable, CharSequence symbol, int pow, int root) throws IOException {
        appendable.append(symbol);
        if (pow != 1 || root != 1) {
            if (pow == 2 && root == 1) {
                appendable.append('\u00b2');
            } else if (pow == 3 && root == 1) {
                appendable.append('\u00b3');
            } else {
                appendable.append('^');
                appendable.append(String.valueOf(pow));
                if (root != 1) {
                    appendable.append(':');
                    appendable.append(String.valueOf(root));
                }
            }
        }
    }

    @Override
    public Unit<?> parse(CharSequence csq) throws MeasurementParseException {
        return this.parse(csq, new ParsePosition(0));
    }

    @Override
    public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
        return this.parseObject(csq.toString(), cursor);
    }

    public String toString() {
        return this.getClass().toString();
    }

    private static enum Token {
        EOF,
        IDENTIFIER,
        OPEN_PAREN,
        CLOSE_PAREN,
        EXPONENT,
        MULTIPLY,
        DIVIDE,
        PLUS,
        INTEGER,
        FLOAT;

    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }
}

