/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import java.util.ArrayList;
import org.geotools.gml3.bindings.SurfaceTypeBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class SurfaceArrayPropertyTypeBinding
extends org.geotools.gml3.bindings.SurfaceArrayPropertyTypeBinding
implements Comparable {
    protected GeometryFactory gf;

    public SurfaceArrayPropertyTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    @Override
    public Class getType() {
        return MultiPolygon.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Node child : node.getChildren()) {
            Object nodeValue = child.getValue();
            if (nodeValue instanceof MultiPolygon) {
                MultiPolygon surface = (MultiPolygon)nodeValue;
                for (int i = 0; i < surface.getNumGeometries(); ++i) {
                    Polygon polygon = (Polygon)surface.getGeometryN(i);
                    polygons.add(polygon);
                }
                continue;
            }
            if (!(nodeValue instanceof Polygon)) continue;
            Polygon polygon = (Polygon)nodeValue;
            polygons.add(polygon);
        }
        return this.gf.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }

    public int compareTo(Object o) {
        if (o instanceof SurfaceTypeBinding) {
            return 1;
        }
        return 0;
    }
}

