/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class MultiGeometryTypeBinding
extends AbstractComplexBinding {
    GeometryFactory factory;

    public MultiGeometryTypeBinding(GeometryFactory factory) {
        this.factory = factory;
    }

    @Override
    public QName getTarget() {
        return GML.MultiGeometryType;
    }

    public Class getType() {
        return GeometryCollection.class;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (node.hasChild(Geometry.class)) {
            geometries.addAll(node.getChildValues(Geometry.class));
        }
        if (node.hasChild(Geometry[].class)) {
            Geometry[] g;
            for (Geometry geometry : g = node.getChildValue(Geometry[].class)) {
                geometries.add(geometry);
            }
        }
        return this.factory.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if (GML.geometryMember.getLocalPart().equals(name.getLocalPart())) {
            GeometryCollection multiGeometry = (GeometryCollection)object;
            Geometry[] members = new Geometry[multiGeometry.getNumGeometries()];
            for (int i = 0; i < members.length; ++i) {
                members[i] = multiGeometry.getGeometryN(i);
            }
            GML3EncodingUtils.setChildIDs((Geometry)multiGeometry);
            return members;
        }
        return null;
    }
}

