/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.Position1D;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.Position3D;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml.producer.CoordinateFormatter;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.CoordinateSequence;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionListTypeBinding
extends AbstractComplexBinding {
    CoordinateFormatter formatter;

    public DirectPositionListTypeBinding(CoordinateFormatter formatter) {
        this.formatter = formatter;
    }

    public DirectPositionListTypeBinding() {
    }

    @Override
    public QName getTarget() {
        return GML.DirectPositionListType;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        int coordCount;
        int crsDimension = GML3ParsingUtils.dimensions(node);
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] values = (Double[])value;
        BigInteger coordinatesCount = (BigInteger)node.getAttributeValue("count");
        if (coordinatesCount == null) {
            coordinatesCount = BigInteger.valueOf(values.length / crsDimension);
        }
        if ((coordCount = coordinatesCount.intValue()) == 0) {
            return new Position[0];
        }
        int dim = values.length / coordCount;
        if (dim < 1) {
            throw new IllegalArgumentException("dimension must be greater or equal to 1");
        }
        Position[] dps = new Position[coordCount];
        if (dim == 1) {
            for (int i = 0; i < coordCount; ++i) {
                dps[i] = new Position1D(crs);
                dps[i].setOrdinate(0, values[i]);
            }
        } else if (dim == 2) {
            int ordinateIdx = 0;
            for (int coordIndex = 0; coordIndex < coordCount; ++coordIndex) {
                dps[coordIndex] = new Position2D(crs);
                dps[coordIndex].setOrdinate(0, values[ordinateIdx]);
                dps[coordIndex].setOrdinate(1, values[ordinateIdx + 1]);
                ordinateIdx += crsDimension;
            }
        } else {
            int ordinateIdx = 0;
            for (int coordIndex = 0; coordIndex < coordCount; ++coordIndex) {
                dps[coordIndex] = new Position3D(crs);
                dps[coordIndex].setOrdinate(0, values[ordinateIdx]);
                dps[coordIndex].setOrdinate(1, values[ordinateIdx + 1]);
                dps[coordIndex].setOrdinate(2, values[ordinateIdx + 2]);
                ordinateIdx += crsDimension;
            }
        }
        return dps;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        CoordinateSequence cs = (CoordinateSequence)object;
        StringBuffer sb = new StringBuffer();
        int dim = CoordinateSequences.coordinateDimension(cs);
        int size = cs.size();
        int nOrdWithSpace = size * dim - 1;
        int count = 0;
        for (int i = 0; i < size; ++i) {
            for (int d = 0; d < dim; ++d) {
                double ordinate = cs.getOrdinate(i, d);
                if (this.formatter != null) {
                    this.formatter.format(ordinate, sb);
                } else {
                    sb.append(ordinate);
                }
                if (count < nOrdWithSpace) {
                    sb.append(" ");
                }
                ++count;
            }
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }
}

