/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.GeoPkgExtension;
import org.geotools.geopkg.GeoPkgExtensionFactory;
import org.geotools.geopkg.GeoPkgMetadata;
import org.geotools.geopkg.GeoPkgMetadataReference;
import org.geotools.util.logging.Logging;

public class GeoPkgMetadataExtension
extends GeoPkgExtension {
    static final Logger LOGGER = Logging.getLogger(GeoPkgMetadataExtension.class);
    static final String DEFINITION = "http://www.geopackage.org/spec121/#extension_metadata";
    public static final String NAME = "gpkg_metadata";

    protected GeoPkgMetadataExtension(GeoPackage geoPackage) {
        super(NAME, DEFINITION, GeoPkgExtension.Scope.ReadWrite, geoPackage);
    }

    /*
     * Exception decompiling
     */
    public List<GeoPkgMetadata> getMetadatas() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GeoPkgMetadata getMetadata(Long id) throws SQLException {
        if (id == null) {
            return null;
        }
        try (Connection cx = this.getConnection();){
            String sql = String.format("SELECT * FROM %s where id = ?", NAME);
            try (PreparedStatement ps = cx.prepareStatement(sql);){
                ps.setLong(1, id);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        GeoPkgMetadata geoPkgMetadata = this.mapMetadata(rs);
                        return geoPkgMetadata;
                    }
                }
            }
        }
        return null;
    }

    public void addMetadata(GeoPkgMetadata metadata) throws SQLException {
        String sql = String.format("INSERT INTO %s(md_scope, md_standard_uri, mime_type, metadata) VALUES(?, ?, ?, ?)", NAME);
        try (Connection cx = this.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, metadata.getScope().getSqlValue());
            ps.setString(2, metadata.getStandardURI());
            ps.setString(3, metadata.getMimeType());
            ps.setString(4, metadata.metadata);
            ps.executeUpdate();
            metadata.setId(this.getGeneratedKey(ps));
        }
    }

    public void updateMetadata(GeoPkgMetadata metadata) throws SQLException {
        String sql = String.format("UPDATE %s set md_scope = ?, md_standard_uri = ?, mime_type = ?, metadata = ? WHERE id = ?", NAME);
        try (Connection cx = this.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, metadata.getScope().getSqlValue());
            ps.setString(2, metadata.getStandardURI());
            ps.setString(3, metadata.getMimeType());
            ps.setString(4, metadata.getMetadata());
            ps.setLong(5, metadata.getId());
            ps.executeUpdate();
        }
    }

    public void removeMetadata(GeoPkgMetadata metadata) throws SQLException {
        String sql = String.format("DELETE from %s WHERE id = ?", NAME);
        try (Connection cx = this.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setLong(1, metadata.getId());
            ps.executeUpdate();
        }
    }

    private GeoPkgMetadata mapMetadata(ResultSet rs) throws SQLException {
        return new GeoPkgMetadata(rs.getLong("id"), this.getMetadataScope(rs), rs.getString("md_standard_uri"), rs.getString("mime_type"), rs.getString("metadata"));
    }

    private GeoPkgMetadata.Scope getMetadataScope(ResultSet rs) throws SQLException {
        Optional<GeoPkgMetadata.Scope> enumValue;
        String scope = rs.getString("md_scope");
        if (scope != null && (enumValue = Arrays.stream(GeoPkgMetadata.Scope.values()).filter(s -> scope.equals(s.getSqlValue())).findFirst()).isPresent()) {
            return enumValue.get();
        }
        LOGGER.log(Level.FINE, "md_scope is supposed to be non null and in a finite set of values defined by the spec, but got '" + scope + "' instead. Using the default value, 'dataset'.");
        return GeoPkgMetadata.Scope.Dataset;
    }

    public List<GeoPkgMetadataReference> getReferences(GeoPkgMetadata metadata) throws SQLException {
        try (Connection cx = this.getConnection();){
            ArrayList<GeoPkgMetadataReference> arrayList;
            block22: {
                if (!this.isRegistered(cx)) {
                    List<GeoPkgMetadataReference> list = null;
                    return list;
                }
                String sql = String.format("SELECT rowid, * FROM %s where md_file_id = ?", "gpkg_metadata_reference");
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setLong(1, metadata.getId());
                    ArrayList<GeoPkgMetadataReference> references = new ArrayList<GeoPkgMetadataReference>();
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            references.add(this.mapReference(rs, metadata));
                        }
                    }
                    arrayList = references;
                    if (ps == null) break block22;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return arrayList;
        }
    }

    private GeoPkgMetadataReference mapReference(ResultSet rs, GeoPkgMetadata metadata) throws SQLException {
        Long rowId = rs.getLong("row_id_value");
        if (rs.wasNull()) {
            rowId = null;
        }
        return new GeoPkgMetadataReference(rs.getLong("rowid"), this.getReferenceScope(rs.getString("reference_scope")), rs.getString("table_name"), rs.getString("column_name"), rowId, this.toDate(rs.getString("timestamp")), metadata, this.getMetadata(rs.getLong("md_parent_id")));
    }

    private Date toDate(String timestamp) throws SQLException {
        try {
            return GeoPackage.getDateFormat().parse(timestamp);
        }
        catch (ParseException e) {
            throw new SQLException(e);
        }
    }

    private GeoPkgMetadataReference.Scope getReferenceScope(String scope) throws SQLException {
        Optional<GeoPkgMetadataReference.Scope> enumValue;
        if (scope != null && (enumValue = Arrays.stream(GeoPkgMetadataReference.Scope.values()).filter(s -> scope.equals(s.getSqlValue())).findFirst()).isPresent()) {
            return enumValue.get();
        }
        LOGGER.log(Level.FINE, "reference_scope is supposed to be non null and in a finite set of values defined by the spec, but got '" + scope + "' instead. Using the default value, 'dataset'.");
        return GeoPkgMetadataReference.Scope.GeoPackage;
    }

    public void addReference(GeoPkgMetadataReference reference) throws SQLException {
        String sql = String.format("INSERT INTO %s(reference_scope, table_name, column_name, row_id_value, timestamp, md_file_id, md_parent_id) VALUES(?, ?, ?, ?, ?, ?, ?)", "gpkg_metadata_reference");
        try (Connection cx = this.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, reference.getScope().getSqlValue());
            ps.setString(2, reference.getTable());
            ps.setString(3, reference.getColumn());
            ps.setObject(4, reference.getRowId());
            ps.setString(5, GeoPackage.getDateFormat().format(reference.getTimestamp()));
            ps.setLong(6, reference.getMetadata().getId());
            GeoPkgMetadata metadataParent = reference.getMetadataParent();
            if (metadataParent != null) {
                ps.setLong(7, metadataParent.getId());
            } else {
                ps.setNull(7, -5);
            }
            ps.executeUpdate();
            reference.setId(this.getGeneratedKey(ps));
        }
    }

    public void updateReference(GeoPkgMetadataReference reference) throws SQLException {
        String sql = String.format("UPDATE %s set reference_scope = ?, table_name = ?, column_name = ?, row_id_value = ?, timestamp = ?, md_file_id = ?,md_parent_id = ? where rowid = ?", "gpkg_metadata_reference");
        try (Connection cx = this.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, reference.getScope().getSqlValue());
            ps.setString(2, reference.getTable());
            ps.setString(3, reference.getColumn());
            ps.setObject(4, reference.getRowId());
            ps.setString(5, GeoPackage.getDateFormat().format(reference.getTimestamp()));
            ps.setLong(6, reference.getMetadata().getId());
            GeoPkgMetadata metadataParent = reference.getMetadataParent();
            if (metadataParent != null) {
                ps.setLong(7, metadataParent.getId());
            } else {
                ps.setNull(7, -5);
            }
            ps.setLong(8, reference.getId());
            ps.executeUpdate();
        }
    }

    public void removeReference(GeoPkgMetadataReference reference) throws SQLException {
        String sql = String.format("DELETE FROM %s WHERE rowid = ?", "gpkg_metadata_reference");
        try (Connection cx = this.getConnection();
             PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setLong(1, reference.getId());
            ps.executeUpdate();
        }
    }

    public static class Factory
    implements GeoPkgExtensionFactory {
        @Override
        public GeoPkgExtension getExtension(String name, GeoPackage geoPackage) {
            if (GeoPkgMetadataExtension.NAME.equals(name)) {
                return new GeoPkgMetadataExtension(geoPackage);
            }
            return null;
        }

        @Override
        public GeoPkgExtension getExtension(Class extensionClass, GeoPackage geoPackage) {
            if (GeoPkgMetadataExtension.class.equals((Object)extensionClass)) {
                return new GeoPkgMetadataExtension(geoPackage);
            }
            return null;
        }
    }
}

