/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.filter.v1_0.OGC;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class OGCFunctionTypeBinding
extends AbstractComplexBinding {
    private FilterFactory factory;

    public OGCFunctionTypeBinding(FilterFactory factory) {
        this.factory = factory;
    }

    @Override
    public QName getTarget() {
        return OGC.FunctionType;
    }

    public Class getType() {
        return Function.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Expression[] args = new Expression[node.getChildren().size()];
        for (int i = 0; i < node.getChildren().size(); ++i) {
            Node child = node.getChildren().get(i);
            args[i] = (Expression)child.getValue();
        }
        String name = (String)node.getAttribute("name").getValue();
        return this.factory.function(name, args);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        Function function = (Function)object;
        if ("expression".equals(name.getLocalPart())) {
            return function.getParameters();
        }
        if ("name".equals(name.getLocalPart())) {
            return function.getName();
        }
        return null;
    }
}

