/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;

public class NearestVisitor
implements FeatureCalc,
FeatureAttributeVisitor {
    private Expression expr;
    private Class attributeClass;
    private NearestAccumulator accumulator;
    boolean visited = false;
    double shortestDistance = Double.MAX_VALUE;
    private Object valueToMatch;
    private Object nearest;

    public NearestVisitor(Expression expression, Object valueToMatch) {
        this.expr = expression;
        this.valueToMatch = valueToMatch;
    }

    @Override
    public void visit(Feature feature) {
        Object attribValue;
        if (this.visited) {
            return;
        }
        if (this.attributeClass == null) {
            PropertyDescriptor desc = (PropertyDescriptor)this.expr.evaluate(feature.getType());
            this.attributeClass = desc.getType().getBinding();
            if (this.accumulator == null) {
                this.accumulator = this.getAccumulator(this.attributeClass);
            }
        }
        if ((attribValue = this.expr.evaluate(feature)) == null) {
            return;
        }
        this.visited |= this.accumulator.visit(attribValue);
    }

    private NearestAccumulator<?> getAccumulator(Class<?> attributeClass) {
        if (Number.class.isAssignableFrom(attributeClass)) {
            Double convertedTarget = Converters.convert(this.valueToMatch, Double.class);
            return new NumberAccumulator(convertedTarget);
        }
        if (Date.class.isAssignableFrom(attributeClass)) {
            Date convertedTarget = Converters.convert(this.valueToMatch, Date.class);
            return new DateAccumulator(convertedTarget);
        }
        if (Geometry.class.isAssignableFrom(attributeClass)) {
            Geometry convertedTarget = Converters.convert(this.valueToMatch, Geometry.class);
            return new GeometryAccumulator(convertedTarget);
        }
        if (Comparable.class.isAssignableFrom(attributeClass)) {
            Comparable convertedTarget = (Comparable)Converters.convert(this.valueToMatch, attributeClass);
            return new ComparableAccumulator(convertedTarget);
        }
        throw new IllegalArgumentException("Don't know how to compute nearest for target class " + attributeClass);
    }

    public void reset() {
        this.visited = false;
        this.accumulator = null;
        this.attributeClass = null;
        this.nearest = null;
    }

    public void setValue(Comparable nearest) {
        this.nearest = nearest;
        this.visited = true;
    }

    public void setValue(Comparable maxBelow, Comparable minAbove) {
        if (maxBelow == null) {
            this.nearest = minAbove;
        } else if (minAbove == null) {
            this.nearest = maxBelow;
        } else {
            NearestAccumulator<?> accumulator = this.getAccumulator(maxBelow.getClass());
            accumulator.visit(maxBelow);
            accumulator.visit(minAbove);
            this.nearest = accumulator.getNearest();
        }
    }

    public Object getNearestMatch() throws IllegalStateException {
        if (this.nearest == null && this.accumulator != null) {
            this.nearest = this.accumulator.getNearest();
        }
        return this.nearest;
    }

    @Override
    public CalcResult getResult() {
        return new AbstractCalcResult(){

            @Override
            public Object getValue() {
                return NearestVisitor.this.getNearestMatch();
            }
        };
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getValueToMatch() {
        return this.valueToMatch;
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.expr);
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        return CalcUtil.reflectInputTypes(1, inputTypes);
    }

    class GeometryAccumulator
    implements NearestAccumulator<Geometry> {
        Geometry targetValue;
        double distance = Double.MAX_VALUE;
        Geometry nearest;

        public GeometryAccumulator(Geometry targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public boolean visit(Geometry value) {
            double d = this.targetValue.distance(value);
            if (d < this.distance) {
                this.distance = d;
                this.nearest = value;
            }
            return d == 0.0;
        }

        @Override
        public Geometry getNearest() {
            return this.nearest;
        }
    }

    class DateAccumulator
    implements NearestAccumulator<Date> {
        long targetValue;
        long difference = Long.MAX_VALUE;
        Date nearest;

        public DateAccumulator(Date targetValue) {
            this.targetValue = targetValue.getTime();
        }

        @Override
        public boolean visit(Date value) {
            long v = value.getTime();
            long d = Math.abs(v - this.targetValue);
            if (d < this.difference) {
                this.difference = d;
                this.nearest = value;
            }
            return d == 0L;
        }

        @Override
        public Date getNearest() {
            return this.nearest;
        }
    }

    class NumberAccumulator
    implements NearestAccumulator<Number> {
        double targetValue;
        double difference = Double.MAX_VALUE;
        Number nearest;

        public NumberAccumulator(Number targetValue) {
            this.targetValue = targetValue.doubleValue();
        }

        @Override
        public boolean visit(Number value) {
            double v = value.doubleValue();
            double d = Math.abs(v - this.targetValue);
            if (d < this.difference) {
                this.difference = d;
                this.nearest = value;
            }
            return d == 0.0;
        }

        @Override
        public Number getNearest() {
            return this.nearest;
        }
    }

    static class ComparableAccumulator
    implements NearestAccumulator<Comparable> {
        private Comparable minAbove;
        private Comparable maxBelow;
        private Comparable targetValue;

        public ComparableAccumulator(Comparable targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public boolean visit(Comparable value) {
            int aboveBelow = value.compareTo(this.targetValue);
            boolean exact = false;
            if (aboveBelow == 0) {
                this.minAbove = this.maxBelow = value;
                exact = true;
            } else if (aboveBelow > 0) {
                if (this.minAbove == null || this.minAbove.compareTo(value) > 0) {
                    this.minAbove = value;
                }
            } else if (aboveBelow < 0 && (this.maxBelow == null || this.maxBelow.compareTo(value) < 0)) {
                this.maxBelow = value;
            }
            return exact;
        }

        @Override
        public Comparable getNearest() {
            int diffBelow;
            if (this.maxBelow == null) {
                return this.minAbove;
            }
            if (this.minAbove == null) {
                return this.maxBelow;
            }
            int diffAbove = Math.abs(this.targetValue.compareTo(this.minAbove));
            if (diffAbove < (diffBelow = Math.abs(this.targetValue.compareTo(this.maxBelow)))) {
                return this.minAbove;
            }
            return this.maxBelow;
        }
    }

    static interface NearestAccumulator<T> {
        public boolean visit(T var1);

        public T getNearest();
    }
}

