/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index;

import java.util.ArrayList;
import org.geotools.data.shapefile.index.DataDefinition;
import org.geotools.data.shapefile.index.TreeException;

public class Data {
    private DataDefinition def;
    private ArrayList<Object> values;

    public Data(DataDefinition def) {
        this.def = def;
        this.values = new ArrayList(def.getFieldsCount());
    }

    public final boolean isValid() {
        if (this.getValuesCount() != this.def.getFieldsCount()) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < this.def.getFieldsCount(); ++i) {
            if (this.def.getField(i).getFieldClass().isInstance(this.getValue(i))) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public Data addValue(Object val) throws TreeException {
        if (this.values.size() == this.def.getFieldsCount()) {
            throw new TreeException("Max number of values reached!");
        }
        int pos = this.values.size();
        if (!val.getClass().equals(this.def.getField(pos).getFieldClass())) {
            throw new TreeException("Wrong class type, was expecting " + this.def.getField(pos).getFieldClass());
        }
        this.values.add(val);
        return this;
    }

    public DataDefinition getDefinition() {
        return this.def;
    }

    public int getValuesCount() {
        return this.values.size();
    }

    public Object getValue(int i) {
        return this.values.get(i);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                ret.append(" - ");
            }
            ret.append(this.def.getField(i).getFieldClass());
            ret.append(": ");
            ret.append(this.values.get(i));
        }
        return ret.toString();
    }

    public void clear() {
        this.values.clear();
    }
}

