/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.shapefile.ShapefileFeatureReader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.fid.IndexedFidReader;
import org.geotools.data.shapefile.index.Data;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.locationtech.jts.geom.Geometry;

class IndexedShapefileFeatureReader
extends ShapefileFeatureReader {
    protected CloseableIterator<Data> goodRecs;
    private Data next;

    public IndexedShapefileFeatureReader(SimpleFeatureType schema, ShapefileReader shp, DbaseFileReader dbf, IndexedFidReader fidReader, CloseableIterator<Data> goodRecs) throws IOException {
        super(schema, shp, dbf, fidReader);
        this.goodRecs = goodRecs;
        this.fidReader = fidReader;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.goodRecs != null) {
                this.goodRecs.close();
            }
            this.goodRecs = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        while (this.nextFeature == null && this.goodRecs.hasNext()) {
            DbaseFileReader.Row row;
            this.next = (Data)this.goodRecs.next();
            Long l = (Long)this.next.getValue(1);
            this.shp.goTo((int)l.longValue());
            ShapefileReader.Record record = this.shp.nextRecord();
            Geometry geometry = this.getGeometry(record);
            if (geometry == SKIP) continue;
            if (this.dbf != null) {
                ((IndexedDbaseFileReader)this.dbf).goTo(record.number);
                row = this.dbf.readRow();
            } else {
                row = null;
            }
            this.nextFeature = this.buildFeature(record.number, geometry, row, record.envelope());
        }
        return this.nextFeature != null;
    }
}

