/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.DelegatingFeatureReader;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.OperationNotFoundException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;

public class ReprojectFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    SimpleFeatureType originalType;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer transformer;
    Map<Name, GeometryCoordinateSequenceTransformer> transformers;

    public ReprojectFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType schema, MathTransform transform) {
        this.reader = reader;
        this.schema = schema;
        this.transformer = new GeometryCoordinateSequenceTransformer();
        this.transformer.setMathTransform(transform);
    }

    public ReprojectFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, CoordinateReferenceSystem cs) throws SchemaException, OperationNotFoundException, NoSuchElementException, FactoryException {
        this(reader, FeatureTypes.transform(reader.getFeatureType(), cs, false, true));
    }

    public ReprojectFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType schema) throws SchemaException, OperationNotFoundException, NoSuchElementException, FactoryException {
        this.originalType = reader.getFeatureType();
        this.schema = schema;
        this.reader = reader;
        this.transformers = new HashMap<Name, GeometryCoordinateSequenceTransformer>();
        for (int i = 0; i < this.originalType.getDescriptors().size(); ++i) {
            CoordinateReferenceSystem target;
            GeometryDescriptor descr;
            CoordinateReferenceSystem original;
            if (!(this.originalType.getDescriptor(i) instanceof GeometryDescriptor) || CRS.equalsIgnoreMetadata(original = (descr = (GeometryDescriptor)this.originalType.getDescriptor(i)).getCoordinateReferenceSystem(), target = ((GeometryDescriptor)schema.getDescriptor(descr.getName())).getCoordinateReferenceSystem())) continue;
            GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform(CRS.findMathTransform(original, target, true));
            this.transformers.put(this.originalType.getDescriptor(i).getName(), transformer);
        }
        if (this.transformers.isEmpty()) {
            throw new IllegalArgumentException("Nothing to be reprojected! (check before using wrapper)");
        }
    }

    protected GeometryCoordinateSequenceTransformer getTransformer(Name attributeName) {
        if (this.transformer != null) {
            return this.transformer;
        }
        return this.transformers.get(attributeName);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getDelegate() {
        return this.reader;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = this.reader.next();
        Object[] attributes = next.getAttributes().toArray();
        try {
            for (int i = 0; i < this.schema.getDescriptors().size(); ++i) {
                GeometryDescriptor descr;
                GeometryCoordinateSequenceTransformer transformer;
                if (!(this.schema.getDescriptor(i) instanceof GeometryDescriptor) || !(attributes[i] instanceof Geometry) || (transformer = this.getTransformer((descr = (GeometryDescriptor)this.originalType.getDescriptor(i)).getName())) == null) continue;
                attributes[i] = transformer.transform((Geometry)attributes[i]);
                JTS.setCRS((Geometry)attributes[i], ((GeometryDescriptor)this.schema.getDescriptor(i)).getCoordinateReferenceSystem());
            }
        }
        catch (TransformException e) {
            throw new DataSourceException("A transformation exception occurred while reprojecting data on the fly", e);
        }
        SimpleFeature reprojected = SimpleFeatureBuilder.build(this.schema, attributes, next.getID());
        if (next.hasUserData()) {
            reprojected.getUserData().putAll(next.getUserData());
        }
        return reprojected;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

