/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.Scale2OpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;
import org.huldra.math.BigInt;

public class Scale2BilinearOpImage
extends Scale2OpImage {
    protected boolean dataINT = false;
    protected byte[][] byteLookupTable;
    protected InterpolationBilinear interpB = null;
    private static final int FRACTION_THRESHOLD_I = 128;
    private static final int FULL_WEIGHT_SHIFT = 8;
    private InterpolationBilinear bilinearInterpolator;

    public Scale2BilinearOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, double scaleX, double scaleY, double transX, double transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues, useRoiAccessor);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues, boolean useRoiAccessor) {
        int i;
        double destinationNoData;
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel && ImageUtil.isBinary(source.getSampleModel())) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        int numBands = this.getSampleModel().getNumBands();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = new BigInt(this.invScaleXRational.num % this.invScaleXRational.denom);
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = new BigInt(this.invScaleXRational.num);
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = new BigInt(this.invScaleYRational.num % this.invScaleYRational.denom);
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = new BigInt(this.invScaleYRational.num);
        }
        this.interpolator = interp;
        Range nod = nodata;
        double[] destNod = null;
        double d = backgroundValues != null && backgroundValues.length > 0 ? backgroundValues[0] : (destinationNoData = nod != null ? nod.getMin().doubleValue() : Double.NaN);
        if (!Double.isNaN(destinationNoData)) {
            destNod = new double[]{destinationNoData};
        }
        if (interp instanceof InterpolationBilinear) {
            this.isBilinearNew = true;
            this.interpB = (InterpolationBilinear)interp;
            this.interp = this.interpB;
            this.interpB.setROIBounds(this.roiBounds);
            if (nod == null) {
                nod = this.interpB.getNoDataRange();
            }
            if (destNod == null) {
                destNod = new double[]{this.interpB.getDestinationNoData()};
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        }
        if (this.destinationNoDataDouble != null && this.destinationNoDataDouble.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, this.destinationNoDataDouble[0]);
            this.destinationNoDataDouble = tmp;
        }
        if (this.hasROI) {
            this.useRoiAccessor = useRoiAccessor;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift = 29 - this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        this.destinationNoDataByte = new byte[numBands];
        this.destinationNoDataShort = new short[numBands];
        this.destinationNoDataUShort = new short[numBands];
        this.destinationNoDataInt = new int[numBands];
        this.destinationNoDataFloat = new float[numBands];
        for (i = 0; i < numBands; ++i) {
            this.destinationNoDataByte[i] = (byte)((int)this.destinationNoDataDouble[i] & 0xFF);
            this.destinationNoDataUShort[i] = (short)((short)this.destinationNoDataDouble[i] & 0xFFFF);
            this.destinationNoDataShort[i] = (short)this.destinationNoDataDouble[i];
            this.destinationNoDataInt[i] = (int)this.destinationNoDataDouble[i];
            this.destinationNoDataFloat[i] = (float)this.destinationNoDataDouble[i];
        }
        if (this.hasNoData) {
            this.byteLookupTable = new byte[numBands][256];
            for (i = 0; i < this.byteLookupTable[0].length; ++i) {
                for (int b = 0; b < numBands; ++b) {
                    this.byteLookupTable[b][i] = this.noData.contains(i) ? this.destinationNoDataByte[b] : (byte)i;
                }
            }
        } else {
            for (i = 0; i < numBands; ++i) {
                this.destinationNoDataByte[i] = (byte)((int)this.backgroundValues[i] & 0xFF);
                this.destinationNoDataUShort[i] = (short)((short)this.backgroundValues[i] & 0xFFFF);
                this.destinationNoDataShort[i] = (short)this.backgroundValues[i];
                this.destinationNoDataInt[i] = (int)this.backgroundValues[i];
                this.destinationNoDataFloat[i] = (float)this.backgroundValues[i];
            }
        }
        if (this.hasNoData && this.destinationNoDataDouble != null) {
            this.setProperty("GC_NODATA", new NoDataContainer(this.destinationNoDataDouble));
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
        int denstinationDataType = this.getSampleModel().getDataType();
        if (!(this.caseA || denstinationDataType != 0 && denstinationDataType != 2 && denstinationDataType != 1 && denstinationDataType != 3)) {
            this.bilinearInterpolator = new InterpolationBilinear(this.subsampleBits, nodata, false, destinationNoData, denstinationDataType);
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.computeRect(sources[0], sources[0].getBounds(), dest, destRect);
    }

    protected void computeRect(Raster source, Rectangle srcRect, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useRoiAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags(new RenderedImage[]{this.srcROIImage}, this.srcROIImage)[0], this.srcROIImage.getColorModel());
                roiScanlineStride = roiAccessor.getScanlineStride();
                yposRoi = new int[dheight];
            } else {
                roiIter = RandomIterFactory.create(this.srcROIImgExt, this.roiRect, true, true);
            }
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        float[] xfracValuesFloat = new float[dwidth];
        float[] yfracValuesFloat = new float[dheight];
        this.dataType = dest.getSampleModel().getDataType();
        if (this.dataType < 4) {
            this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        } else {
            this.preComputePositionsFloat(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValuesFloat, yfracValuesFloat, roiScanlineStride, yposRoi);
        }
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValuesFloat, yfracValuesFloat, roiAccessor, yposRoi, roiScanlineStride, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValuesFloat, yfracValuesFloat, roiAccessor, yposRoi, roiScanlineStride, roiIter);
            }
        }
        if (dstAccessor.isDataCopy()) {
            if (dstAccessor.needsClamping()) {
                dstAccessor.clampDataArrays();
            }
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int s00 = srcData[pos] & 0xFF;
                        int s01 = srcData[pos + srcPixelStride] & 0xFF;
                        int s10 = srcData[pos + srcScanlineStride] & 0xFF;
                        int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFF;
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstData[dstPixelOffset] = (byte)(s & 0xFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int s00 = srcData[pos] & 0xFF;
                            int s01 = srcData[pos + srcPixelStride] & 0xFF;
                            int s10 = srcData[pos + srcScanlineStride] & 0xFF;
                            int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFF;
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                            int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                            int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                            if (baseIndex > roiDataLength) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                            } else {
                                int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                                dstData[dstPixelOffset] = (byte)(s & 0xFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                        int firstX = src.getX() + xpos[0] / srcPixelStride;
                        int w01 = this.roiBounds.contains(firstX, y0) ? roiIter.getSample(firstX, y0, 0) : 0;
                        int w11 = this.roiBounds.contains(firstX, y0 + 1) ? roiIter.getSample(firstX, y0 + 1, 0) : 0;
                        int previousX = firstX;
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            int w00 = w01;
                            int w10 = w11;
                            w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                            int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                            if (previousX != x0) {
                                w00 = this.roiBounds.contains(x0, y0) ? roiIter.getSample(x0, y0, 0) : 0;
                                w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                            }
                            previousX = x0 + 1;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                            } else {
                                int s00 = srcData[posx + posy] & 0xFF;
                                int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                                int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                                int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                                int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                                dstData[dstPixelOffset] = (byte)(s & 0xFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            int w00 = 0;
            int w01 = 0;
            int w10 = 0;
            int w11 = 0;
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy] & 0xFF;
                        int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                        int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                        w00 = this.byteLookupTable[k][s00] == this.destinationNoDataByte[k] ? 0 : 1;
                        w01 = this.byteLookupTable[k][s01] == this.destinationNoDataByte[k] ? 0 : 1;
                        w10 = this.byteLookupTable[k][s10] == this.destinationNoDataByte[k] ? 0 : 1;
                        w11 = this.byteLookupTable[k][s11] == this.destinationNoDataByte[k] ? 0 : 1;
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataByte[k] : (byte)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k) & 0xFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int baseIndex;
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy] & 0xFF;
                        int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                        int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else {
                            w00 = this.byteLookupTable[k][s00] == this.destinationNoDataByte[k] ? 0 : w00;
                            w01 = this.byteLookupTable[k][s01] == this.destinationNoDataByte[k] ? 0 : w01;
                            w10 = this.byteLookupTable[k][s10] == this.destinationNoDataByte[k] ? 0 : w10;
                            w11 = this.byteLookupTable[k][s11] == this.destinationNoDataByte[k] ? 0 : w11;
                            dstData[dstPixelOffset] = (byte)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k) & 0xFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                        int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                        int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                        int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else {
                            int s00 = srcData[posx + posy] & 0xFF;
                            int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                            int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                            int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                            w00 = this.byteLookupTable[k][s00] == this.destinationNoDataByte[k] ? 0 : w00;
                            w01 = this.byteLookupTable[k][s01] == this.destinationNoDataByte[k] ? 0 : w01;
                            w10 = this.byteLookupTable[k][s10] == this.destinationNoDataByte[k] ? 0 : w10;
                            w11 = this.byteLookupTable[k][s11] == this.destinationNoDataByte[k] ? 0 : w11;
                            dstData[dstPixelOffset] = (byte)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k) & 0xFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int s00 = srcData[pos] & 0xFFFF;
                        int s01 = srcData[pos + srcPixelStride] & 0xFFFF;
                        int s10 = srcData[pos + srcScanlineStride] & 0xFFFF;
                        int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFFFF;
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int s00 = srcData[pos] & 0xFFFF;
                            int s01 = srcData[pos + srcPixelStride] & 0xFFFF;
                            int s10 = srcData[pos + srcScanlineStride] & 0xFFFF;
                            int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFFFF;
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFFFF : 0;
                            int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFFFF : 0;
                            int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFFFF : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFFFF : 0;
                            if (baseIndex > roiDataLength) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                            } else {
                                int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                                dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                            int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                            int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                            int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                            } else {
                                int s00 = srcData[posx + posy] & 0xFFFF;
                                int s01 = srcData[posx + srcPixelStride + posy] & 0xFFFF;
                                int s10 = srcData[posx + posy + srcScanlineStride] & 0xFFFF;
                                int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF;
                                int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                                dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        short s00 = (short)(srcData[posx + posy] & 0xFFFF);
                        short s01 = (short)(srcData[posx + srcPixelStride + posy] & 0xFFFF);
                        short s10 = (short)(srcData[posx + posy + srcScanlineStride] & 0xFFFF);
                        short s11 = (short)(srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF);
                        int w00 = this.noData.contains(s00) ? 0 : 1;
                        int w01 = this.noData.contains(s01) ? 0 : 1;
                        int w10 = this.noData.contains(s10) ? 0 : 1;
                        int w11 = this.noData.contains(s11) ? 0 : 1;
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataUShort[k] : (short)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k) & 0xFFFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int baseIndex;
                        int posx = xpos[i];
                        short s00 = (short)(srcData[posx + posy] & 0xFFFF);
                        short s01 = (short)(srcData[posx + srcPixelStride + posy] & 0xFFFF);
                        short s10 = (short)(srcData[posx + posy + srcScanlineStride] & 0xFFFF);
                        short s11 = (short)(srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF);
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFFFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFFFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFFFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFFFF : 0;
                        if (baseIndex > roiDataLength) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else {
                            w00 = this.noData.contains(s00) ? 0 : w00;
                            w01 = this.noData.contains(s01) ? 0 : w01;
                            w10 = this.noData.contains(s10) ? 0 : w10;
                            w11 = this.noData.contains(s11) ? 0 : w11;
                            dstData[dstPixelOffset] = (short)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k) & 0xFFFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                        int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                        int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                        int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else {
                            short s00 = (short)(srcData[posx + posy] & 0xFFFF);
                            short s01 = (short)(srcData[posx + srcPixelStride + posy] & 0xFFFF);
                            short s10 = (short)(srcData[posx + posy + srcScanlineStride] & 0xFFFF);
                            short s11 = (short)(srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF);
                            w00 = this.noData.contains(s00) ? 0 : w00;
                            w01 = this.noData.contains(s01) ? 0 : w01;
                            w10 = this.noData.contains(s10) ? 0 : w10;
                            w11 = this.noData.contains(s11) ? 0 : w11;
                            dstData[dstPixelOffset] = (short)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k) & 0xFFFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short s00 = srcData[pos];
                        short s01 = srcData[pos + srcPixelStride];
                        short s10 = srcData[pos + srcScanlineStride];
                        short s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstData[dstPixelOffset] = (short)s;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            short s00 = srcData[pos];
                            short s01 = srcData[pos + srcPixelStride];
                            short s10 = srcData[pos + srcScanlineStride];
                            short s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            if (baseIndex > roiDataLength) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                            } else {
                                int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                                dstData[dstPixelOffset] = (short)s;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                            int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                            int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                            int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                            } else {
                                short s00 = srcData[posx + posy];
                                short s01 = srcData[posx + srcPixelStride + posy];
                                short s10 = srcData[posx + posy + srcScanlineStride];
                                short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                                dstData[dstPixelOffset] = (short)s;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        short s00 = srcData[posx + posy];
                        short s01 = srcData[posx + srcPixelStride + posy];
                        short s10 = srcData[posx + posy + srcScanlineStride];
                        short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00 = this.noData.contains(s00) ? 0 : 1;
                        int w01 = this.noData.contains(s01) ? 0 : 1;
                        int w10 = this.noData.contains(s10) ? 0 : 1;
                        int w11 = this.noData.contains(s11) ? 0 : 1;
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataShort[k] : (short)this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        short s00 = srcData[posx + posy];
                        short s01 = srcData[posx + srcPixelStride + posy];
                        short s10 = srcData[posx + posy + srcScanlineStride];
                        short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : w00;
                            w01 = this.noData.contains(s01) ? (byte)0 : w01;
                            w10 = this.noData.contains(s10) ? (byte)0 : w10;
                            w11 = this.noData.contains(s11) ? (byte)0 : w11;
                            dstData[dstPixelOffset] = (short)this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                        int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                        int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                        int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else {
                            short s00 = srcData[posx + posy];
                            short s01 = srcData[posx + srcPixelStride + posy];
                            short s10 = srcData[posx + posy + srcScanlineStride];
                            short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                            w00 = this.noData.contains(s00) ? 0 : w00;
                            w01 = this.noData.contains(s01) ? 0 : w01;
                            w10 = this.noData.contains(s10) ? 0 : w10;
                            w11 = this.noData.contains(s11) ? 0 : w11;
                            dstData[dstPixelOffset] = (short)this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int s;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int s00 = srcData[pos];
                        int s01 = srcData[pos + srcPixelStride];
                        int s10 = srcData[pos + srcScanlineStride];
                        int s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        dstData[dstPixelOffset] = s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int s00 = srcData[pos];
                            int s01 = srcData[pos + srcPixelStride];
                            int s10 = srcData[pos + srcScanlineStride];
                            int s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            dstData[dstPixelOffset] = baseIndex > roiDataLength ? this.destinationNoDataInt[k] : (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataInt[k] : this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k));
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                            int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                            int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                            int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                            } else {
                                int s00 = srcData[posx + posy];
                                int s01 = srcData[posx + srcPixelStride + posy];
                                int s10 = srcData[posx + posy + srcScanlineStride];
                                int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                dstData[dstPixelOffset] = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy];
                        int s01 = srcData[posx + srcPixelStride + posy];
                        int s10 = srcData[posx + posy + srcScanlineStride];
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00 = this.noData.contains(s00) ? 0 : 1;
                        int w01 = this.noData.contains(s01) ? 0 : 1;
                        int w10 = this.noData.contains(s10) ? 0 : 1;
                        int w11 = this.noData.contains(s11) ? 0 : 1;
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataInt[k] : this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy];
                        int s01 = srcData[posx + srcPixelStride + posy];
                        int s10 = srcData[posx + posy + srcScanlineStride];
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : w00;
                            w01 = this.noData.contains(s01) ? (byte)0 : w01;
                            w10 = this.noData.contains(s10) ? (byte)0 : w10;
                            w11 = this.noData.contains(s11) ? (byte)0 : w11;
                            dstData[dstPixelOffset] = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                        int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                        int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                        int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else {
                            int s00 = srcData[posx + posy];
                            int s01 = srcData[posx + srcPixelStride + posy];
                            int s10 = srcData[posx + posy + srcScanlineStride];
                            int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                            w00 = this.noData.contains(s00) ? 0 : w00;
                            w01 = this.noData.contains(s01) ? 0 : w01;
                            w10 = this.noData.contains(s10) ? 0 : w10;
                            w11 = this.noData.contains(s11) ? 0 : w11;
                            dstData[dstPixelOffset] = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], k);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, float[] xfrac, float[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        float s;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float s00 = srcData[pos];
                        float s01 = srcData[pos + srcPixelStride];
                        float s10 = srcData[pos + srcScanlineStride];
                        float s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        float s0 = (s01 - s00) * xfrac[i] + s00;
                        float s1 = (s11 - s10) * xfrac[i] + s10;
                        dstData[dstPixelOffset] = s = (s1 - s0) * yfrac[j] + s0;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            float s;
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            float s00 = srcData[pos];
                            float s01 = srcData[pos + srcPixelStride];
                            float s10 = srcData[pos + srcScanlineStride];
                            float s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            dstData[dstPixelOffset] = baseIndex > roiDataLength ? this.destinationNoDataFloat[k] : (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataFloat[k] : (s = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataFloat[k]).floatValue()));
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                            int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                            int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                            int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                            } else {
                                float s;
                                float s00 = srcData[posx + posy];
                                float s01 = srcData[posx + srcPixelStride + posy];
                                float s10 = srcData[posx + posy + srcScanlineStride];
                                float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                dstData[dstPixelOffset] = s = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataFloat[k]).floatValue();
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        float s00 = srcData[posx + posy];
                        float s01 = srcData[posx + srcPixelStride + posy];
                        float s10 = srcData[posx + posy + srcScanlineStride];
                        float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        boolean w00z = this.noData.contains(s00);
                        boolean w01z = this.noData.contains(s01);
                        boolean w10z = this.noData.contains(s10);
                        boolean w11z = this.noData.contains(s11);
                        dstData[dstPixelOffset] = w00z && w01z && w10z && w11z ? this.destinationNoDataFloat[k] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00z, w01z, w10z, w11z, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataFloat[k]).floatValue();
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        float s00 = srcData[posx + posy];
                        float s01 = srcData[posx + srcPixelStride + posy];
                        float s10 = srcData[posx + posy + srcScanlineStride];
                        float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : w00;
                            w01 = this.noData.contains(s01) ? (byte)0 : w01;
                            w10 = this.noData.contains(s10) ? (byte)0 : w10;
                            w11 = this.noData.contains(s11) ? (byte)0 : w11;
                            dstData[dstPixelOffset] = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataFloat[k]).floatValue();
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                        int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                        int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                        int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else {
                            float s00 = srcData[posx + posy];
                            float s01 = srcData[posx + srcPixelStride + posy];
                            float s10 = srcData[posx + posy + srcScanlineStride];
                            float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                            w00 = this.noData.contains(s00) ? 0 : w00;
                            w01 = this.noData.contains(s01) ? 0 : w01;
                            w10 = this.noData.contains(s10) ? 0 : w10;
                            w11 = this.noData.contains(s11) ? 0 : w11;
                            dstData[dstPixelOffset] = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataFloat[k]).floatValue();
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, float[] xfrac, float[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        double s;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double s00 = srcData[pos];
                        double s01 = srcData[pos + srcPixelStride];
                        double s10 = srcData[pos + srcScanlineStride];
                        double s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        double s0 = (s01 - s00) * (double)xfrac[i] + s00;
                        double s1 = (s11 - s10) * (double)xfrac[i] + s10;
                        dstData[dstPixelOffset] = s = (s1 - s0) * (double)yfrac[j] + s0;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            double s;
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            double s00 = srcData[pos];
                            double s01 = srcData[pos + srcPixelStride];
                            double s10 = srcData[pos + srcScanlineStride];
                            double s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            dstData[dstPixelOffset] = baseIndex > roiDataLength ? this.destinationNoDataDouble[k] : (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataDouble[k] : (s = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataDouble[k]).doubleValue()));
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                            int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                            int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                            int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                            } else {
                                double s;
                                double s00 = srcData[posx + posy];
                                double s01 = srcData[posx + srcPixelStride + posy];
                                double s10 = srcData[posx + posy + srcScanlineStride];
                                double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                dstData[dstPixelOffset] = s = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataDouble[k]).doubleValue();
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        double s00 = srcData[posx + posy];
                        double s01 = srcData[posx + srcPixelStride + posy];
                        double s10 = srcData[posx + posy + srcScanlineStride];
                        double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        boolean w00z = this.noData.contains(s00);
                        boolean w01z = this.noData.contains(s01);
                        boolean w10z = this.noData.contains(s10);
                        boolean w11z = this.noData.contains(s11);
                        dstData[dstPixelOffset] = w00z && w01z && w10z && w11z ? this.destinationNoDataDouble[k] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00z, w01z, w10z, w11z, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataDouble[k]).doubleValue();
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        double s00 = srcData[posx + posy];
                        double s01 = srcData[posx + srcPixelStride + posy];
                        double s10 = srcData[posx + posy + srcScanlineStride];
                        double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : w00;
                            w01 = this.noData.contains(s01) ? (byte)0 : w01;
                            w10 = this.noData.contains(s10) ? (byte)0 : w10;
                            w11 = this.noData.contains(s11) ? (byte)0 : w11;
                            dstData[dstPixelOffset] = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataDouble[k]).doubleValue();
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        int w00 = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? roiIter.getSample(x0, y0, 0) : 0;
                        int w01 = this.roiBounds.contains(x0 + 1, y0) ? roiIter.getSample(x0 + 1, y0, 0) : 0;
                        int w10 = this.roiBounds.contains(x0, y0 + 1) ? roiIter.getSample(x0, y0 + 1, 0) : 0;
                        int n = w11 = this.roiBounds.contains(x0 + 1, y0 + 1) ? roiIter.getSample(x0 + 1, y0 + 1, 0) : 0;
                        if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                            double s00 = srcData[posx + posy];
                            double s01 = srcData[posx + srcPixelStride + posy];
                            double s10 = srcData[posx + posy + srcScanlineStride];
                            double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                            w00 = this.noData.contains(s00) ? 0 : w00;
                            w01 = this.noData.contains(s01) ? 0 : w01;
                            w10 = this.noData.contains(s10) ? 0 : w10;
                            w11 = this.noData.contains(s11) ? 0 : w11;
                            dstData[dstPixelOffset] = InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00 == 0, w01 == 0, w10 == 0, w11 == 0, xfrac[i], yfrac[j], this.dataType, this.destinationNoDataDouble[k]).doubleValue();
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    int computeValue(int s00, int s01, int s10, int s11, int w00, int w01, int w10, int w11, int xfrac, int yfrac, int k) {
        return this.bilinearInterpolator.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac);
    }
}

