/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Bag<Item>
implements Iterable<Item> {
    private int N = 0;
    private Node first = null;

    public Bag() {
        assert (this.check());
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public void add(Item item) {
        Node oldfirst = this.first;
        this.first = new Node();
        this.first.item = item;
        this.first.next = oldfirst;
        ++this.N;
        assert (this.check());
    }

    private boolean check() {
        if (this.N == 0) {
            if (this.first != null) {
                return false;
            }
        } else if (this.N == 1) {
            if (this.first == null) {
                return false;
            }
            if (this.first.next != null) {
                return false;
            }
        } else if (this.first.next == null) {
            return false;
        }
        int numberOfNodes = 0;
        Node x = this.first;
        while (x != null) {
            ++numberOfNodes;
            x = x.next;
        }
        return numberOfNodes == this.N;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator();
    }

    private class Node {
        private Item item;
        private Node next;

        private Node() {
        }
    }

    private class ListIterator
    implements Iterator<Item> {
        private Node current;

        private ListIterator() {
            this.current = Bag.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }
}

