/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.export;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cache.CacheUtils;
import org.openstreetmap.josm.tools.Logging;

public class StreetsideExportDownloadThread
extends Thread
implements ICachedLoaderListener {
    private static final Logger LOGGER = Logger.getLogger(StreetsideExportDownloadThread.class.getCanonicalName());
    private final ArrayBlockingQueue<BufferedImage> queue;
    private final ArrayBlockingQueue<StreetsideAbstractImage> queueImages;
    private final StreetsideImage image;

    public StreetsideExportDownloadThread(StreetsideImage image, ArrayBlockingQueue<BufferedImage> queue, ArrayBlockingQueue<StreetsideAbstractImage> queueImages) {
        this.queue = queue;
        this.image = image;
        this.queueImages = queueImages;
    }

    @Override
    public void run() {
        CacheUtils.downloadPicture(this.image, CacheUtils.PICTURE.THUMBNAIL, this);
        CacheUtils.submit(this.image.id(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        try {
            Class<StreetsideExportDownloadThread> clazz = StreetsideExportDownloadThread.class;
            synchronized (StreetsideExportDownloadThread.class) {
                this.queue.put(ImageIO.read(new ByteArrayInputStream(data.getContent())));
                this.queueImages.put(this.image);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
        }
        {
            return;
        }
    }
}

