/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;

public class WebLinkAction
extends AbstractAction {
    private static final long serialVersionUID = 6157320554869780625L;
    private static final Logger LOGGER = Logger.getLogger(WebLinkAction.class.getCanonicalName());
    private URL url;

    public WebLinkAction(String name, URL url) {
        super(name, ImageProvider.get((String)"link", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SMALLICON));
        this.setURL(url);
    }

    public final void setURL(URL url) {
        this.url = url;
        this.setEnabled(url != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.url != null) {
                OpenBrowser.displayUrl((URI)this.url.toURI());
            }
        }
        catch (URISyntaxException e1) {
            String msg = String.valueOf(this.url) + " in a browser";
            LOGGER.log(Logging.LEVEL_WARN, msg, e1);
            new Notification(msg).setIcon(2).show();
        }
    }
}

