/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.actions.ImageReloadAction;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ThreeSixtyDegreeViewerPanel;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.WebLinkAction;
import org.openstreetmap.josm.plugins.streetside.utils.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideViewerPanel
extends JPanel
implements StreetsideDataListener {
    private static final long serialVersionUID = 4141847503072417190L;
    private static final Logger LOGGER = Logger.getLogger(StreetsideViewerPanel.class.getCanonicalName());
    private static ThreeSixtyDegreeViewerPanel threeSixtyDegreeViewerPanel;
    private WebLinkAction imgLinkAction;
    private AbstractProperty.ValueChangeListener<Boolean> imageLinkChangeListener;

    public StreetsideViewerPanel() {
        super(new BorderLayout());
        SwingUtilities.invokeLater(this::initializeAndStartGUI);
        this.selectedImageChanged(null, null);
        this.setToolTipText(I18n.tr((String)"Select Microsoft Streetside from the Imagery menu, then click on a blue vector bubble..", (Object[])new Object[0]));
    }

    public static CubemapBox getCubemapBox() {
        return threeSixtyDegreeViewerPanel.getCubemapBox();
    }

    public static ThreeSixtyDegreeViewerPanel getThreeSixtyDegreeViewerPanel() {
        return threeSixtyDegreeViewerPanel;
    }

    private synchronized void initializeAndStartGUI() {
        try {
            threeSixtyDegreeViewerPanel = new ThreeSixtyDegreeViewerPanel();
        }
        catch (NoClassDefFoundError e) {
            Logging.trace((Throwable)e);
            return;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            GraphicsUtils.PlatformHelper.run(threeSixtyDegreeViewerPanel::initialize);
        }
        this.add((Component)((Object)threeSixtyDegreeViewerPanel), "Center");
        this.revalidate();
        this.repaint();
        JPanel checkPanel = new JPanel();
        ImageReloadAction imgReloadAction = new ImageReloadAction("Reload");
        StreetsideButton imgReloadButton = new StreetsideButton(imgReloadAction);
        JCheckBox highResImageryCheck = new JCheckBox("High resolution");
        highResImageryCheck.setSelected(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get());
        highResImageryCheck.addActionListener(action -> StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.put(Boolean.valueOf(highResImageryCheck.isSelected())));
        StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.addListener(valueChange -> highResImageryCheck.setSelected(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get()));
        checkPanel.add((Component)highResImageryCheck, "West");
        checkPanel.add((Component)imgReloadButton, "East");
        JPanel privacyLink = new JPanel();
        this.imgLinkAction = new WebLinkAction("Report a privacy concern with this image", null);
        privacyLink.add(new StreetsideButton(this.imgLinkAction, true));
        checkPanel.add((Component)privacyLink, "Last");
        this.add((Component)((Object)threeSixtyDegreeViewerPanel), "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.add((Component)checkPanel, "North");
        bottomPanel.add((Component)privacyLink, "South");
        this.add((Component)bottomPanel, "Last");
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public synchronized void selectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        if (newImage != null) {
            String newImageId;
            LOGGER.info(() -> String.format("Selected Streetside image changed from %s to %s.", oldImage != null ? oldImage.id() : "\u2039none\u203a", newImage.id()));
            String string = newImageId = CubemapBuilder.getInstance().getCubemap() != null ? CubemapBuilder.getInstance().getCubemap().id() : newImage.id();
            if (newImageId != null) {
                this.updateLinksToNewImage(newImageId);
            } else {
                if (this.imageLinkChangeListener != null) {
                    StreetsideProperties.CUBEMAP_LINK_TO_BLUR_EDITOR.removeListener(this.imageLinkChangeListener);
                    this.imageLinkChangeListener = null;
                }
                this.imgLinkAction.setURL(null);
            }
        }
    }

    private void updateLinksToNewImage(String newImageId) {
        Matcher matcher = Pattern.compile("/tiles/hs([0-9]*)").matcher(newImageId);
        if (matcher.find()) {
            String bubbleId = CubemapUtils.convertQuaternary2Decimal(matcher.group(1));
            this.imageLinkChangeListener = b -> this.imgLinkAction.setURL(StreetsideURL.MainWebsite.streetsidePrivacyLink(bubbleId));
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                LOGGER.log(Logging.LEVEL_DEBUG, "Privacy link set for Streetside image {0} quadKey {1}", new Object[]{bubbleId, newImageId});
            }
            this.imageLinkChangeListener.valueChanged(null);
            StreetsideProperties.CUBEMAP_LINK_TO_BLUR_EDITOR.addListener(this.imageLinkChangeListener);
        }
    }
}

