/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.streetside.CubeMapTileXY;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;

public final class CacheUtils {
    private static final IgnoreDownload ignoreDownload = new IgnoreDownload();

    private CacheUtils() {
    }

    public static Map<CubeMapTileXY, StreetsideCache> downloadPicture(StreetsideImage img) {
        return CacheUtils.downloadPicture(img, PICTURE.BOTH);
    }

    public static Map<CubeMapTileXY, StreetsideCache> downloadCubemap(StreetsideImage cm) {
        return CacheUtils.downloadPicture(cm, PICTURE.CUBEMAP);
    }

    public static Map<CubeMapTileXY, StreetsideCache> downloadPicture(StreetsideImage img, PICTURE pic) {
        return CacheUtils.downloadPicture(img, pic, ignoreDownload);
    }

    public static Map<CubeMapTileXY, StreetsideCache> downloadPicture(StreetsideImage img, PICTURE pic, ICachedLoaderListener lis) {
        if (img.id() == null) {
            return Collections.emptyMap();
        }
        return switch (pic.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> {
                HashMap<CubeMapTileXY, StreetsideCache> jobs = new HashMap<CubeMapTileXY, StreetsideCache>(1 + (int)Math.round(Math.pow(4.0, img.zoomMax())));
                jobs.putAll(CacheUtils.downloadPicture(img, PICTURE.THUMBNAIL, lis));
                jobs.putAll(CacheUtils.downloadPicture(img, PICTURE.FULL_IMAGE, lis));
                yield Collections.unmodifiableMap(jobs);
            }
            case 1 -> img.getFaceTiles(CubemapUtils.CubemapFaces.FRONT, img.zoomMax()).collect(Collectors.toMap(p -> (CubeMapTileXY)p.a, p -> CacheUtils.submit((String)p.b, lis)));
            case 3 -> CubemapBuilder.getInstance().downloadCubemapImages(img);
            case 0 -> Collections.singletonMap(null, CacheUtils.submit(img.getThumbnail(), lis));
        };
    }

    public static StreetsideCache submit(String key, ICachedLoaderListener lis) {
        try {
            StreetsideCache cache = new StreetsideCache(key);
            cache.submit(lis, false);
            return cache;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static enum PICTURE {
        THUMBNAIL,
        FULL_IMAGE,
        BOTH,
        CUBEMAP;

    }

    private static class IgnoreDownload
    implements ICachedLoaderListener {
        private IgnoreDownload() {
        }

        public void loadingFinished(CacheEntry arg0, CacheEntryAttributes arg1, ICachedLoaderListener.LoadResult arg2) {
        }
    }
}

