/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.AddrInterpolation;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.AddrInterpolation.EscapeDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class AddrInterpolationDialog
extends JDialog
implements ActionListener {
    private Way selectedStreet;
    private Way addrInterpolationWay;
    private Relation associatedStreetRelation;
    private ArrayList<Node> houseNumberNodes;
    private static String lastIncrement = "";
    private static int lastAccuracyIndex;
    private static String lastCity;
    private static String lastState;
    private static String lastPostCode;
    private static String lastCountry;
    private static String lastFullAddress;
    private static boolean lastConvertToHousenumber;
    private EscapeDialog dialog;
    private JRadioButton streetNameButton;
    private JRadioButton streetRelationButton;
    private JTextField startTextField;
    private JTextField endTextField;
    private JTextField incrementTextField;
    private JTextField cityTextField;
    private JTextField stateTextField;
    private JTextField postCodeTextField;
    private JTextField countryTextField;
    private JTextField fullTextField;
    private Checkbox cbConvertToHouseNumbers;
    private boolean relationChanged;
    private boolean interpolationMethodSet;
    String[] addrInterpolationTags = new String[]{"odd", "even", "all", "alphabetic", "Numeric"};
    String[] addrInterpolationStrings = new String[]{I18n.tr((String)"Odd", (Object[])new Object[0]), I18n.tr((String)"Even", (Object[])new Object[0]), I18n.tr((String)"All", (Object[])new Object[0]), I18n.tr((String)"Alphabetic", (Object[])new Object[0]), I18n.tr((String)"Numeric", (Object[])new Object[0])};
    private static final int NUMERIC_INDEX = 4;
    private JComboBox<String> addrInterpolationList;
    String[] addrInclusionTags = new String[]{"actual", "estimate", "potential"};
    String[] addrInclusionStrings = new String[]{I18n.tr((String)"Actual", (Object[])new Object[0]), I18n.tr((String)"Estimate", (Object[])new Object[0]), I18n.tr((String)"Potential", (Object[])new Object[0])};
    private JComboBox<String> addrInclusionList;
    private Collection<Command> commandGroup;
    private Relation editedRelation;
    private static final Pattern PATTERN_NUMERIC;

    public AddrInterpolationDialog(String name) {
        if (!this.findAndSaveSelections()) {
            return;
        }
        JPanel editControlsPane = this.createEditControls();
        this.showDialog(editControlsPane, name);
    }

    private void showDialog(JPanel editControlsPane, String name) {
        this.dialog = new EscapeDialog((Frame)MainApplication.getMainFrame(), name, true);
        this.dialog.add(editControlsPane);
        this.dialog.setSize(new Dimension(300, 500));
        this.dialog.setLocation(new Point(100, 300));
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (AddrInterpolationDialog.this.addrInterpolationWay != null) {
                    AddrInterpolationDialog.this.startTextField.requestFocus();
                } else {
                    AddrInterpolationDialog.this.cityTextField.requestFocus();
                }
            }
        });
        this.dialog.setVisible(true);
        AddrInterpolationDialog.updateFields(this);
    }

    private static void updateFields(AddrInterpolationDialog dialog) {
        lastIncrement = dialog.incrementTextField.getText();
        lastCity = dialog.cityTextField.getText();
        lastState = dialog.stateTextField.getText();
        lastPostCode = dialog.postCodeTextField.getText();
        lastCountry = dialog.countryTextField.getText();
        lastFullAddress = dialog.fullTextField.getText();
        lastConvertToHousenumber = dialog.cbConvertToHouseNumbers.getState();
    }

    private JPanel createEditControls() {
        JPanel editControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        editControlsPane.setLayout(gridbag);
        editControlsPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        String streetName = this.selectedStreet.get("name");
        String streetRelation = this.findRelation();
        if ("".equals(streetRelation)) {
            streetRelation = " (Create new)";
        }
        this.streetNameButton = new JRadioButton(I18n.tr((String)"Name: {0}", (Object[])new Object[]{streetName}));
        this.streetRelationButton = new JRadioButton(I18n.tr((String)"Relation: {0}", (Object[])new Object[]{streetRelation}));
        if (this.associatedStreetRelation == null) {
            this.streetNameButton.setSelected(true);
        } else {
            this.streetRelationButton.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.streetNameButton);
        group.add(this.streetRelationButton);
        JPanel radioButtonPanel = new JPanel(new BorderLayout());
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Associate with street using:", (Object[])new Object[0])));
        radioButtonPanel.add((Component)this.streetNameButton, "North");
        radioButtonPanel.add((Component)this.streetRelationButton, "South");
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.gridwidth = 0;
        editControlsPane.add((Component)radioButtonPanel, c);
        JLabel numberingLabel = new JLabel(I18n.tr((String)"Numbering Scheme:", (Object[])new Object[0]));
        this.addrInterpolationList = new JComboBox<String>(this.addrInterpolationStrings);
        JLabel incrementLabel = new JLabel(I18n.tr((String)"Increment:", (Object[])new Object[0]));
        this.incrementTextField = new JTextField(lastIncrement, 100);
        this.incrementTextField.setEnabled(false);
        JLabel startLabel = new JLabel(I18n.tr((String)"Starting #:", (Object[])new Object[0]));
        JLabel endLabel = new JLabel(I18n.tr((String)"Ending #:", (Object[])new Object[0]));
        this.startTextField = new JTextField(10);
        this.endTextField = new JTextField(10);
        JLabel inclusionLabel = new JLabel(I18n.tr((String)"Accuracy:", (Object[])new Object[0]));
        this.addrInclusionList = new JComboBox<String>(this.addrInclusionStrings);
        this.addrInclusionList.setSelectedIndex(lastAccuracyIndex);
        this.getExistingMapKeys();
        JLabel[] textLabels = new JLabel[]{startLabel, endLabel, numberingLabel, incrementLabel, inclusionLabel};
        Component[] editFields = new Component[]{this.startTextField, this.endTextField, this.addrInterpolationList, this.incrementTextField, this.addrInclusionList};
        AddrInterpolationDialog.addEditControlRows(textLabels, editFields, editControlsPane);
        this.cbConvertToHouseNumbers = new Checkbox(I18n.tr((String)"Convert way to individual house numbers.", (Object[])new Object[0]), null, lastConvertToHousenumber);
        if (this.addrInterpolationWay == null) {
            this.addrInterpolationList.setEnabled(false);
            this.startTextField.setEnabled(false);
            this.endTextField.setEnabled(false);
            this.cbConvertToHouseNumbers.setEnabled(false);
        }
        JPanel optionPanel = this.createOptionalFields();
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.gridwidth = 0;
        editControlsPane.add((Component)optionPanel, c);
        KeyAdapter enterProcessor = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AddrInterpolationDialog.this.validateAndSave()) {
                    AddrInterpolationDialog.this.dialog.dispose();
                }
            }
        };
        this.endTextField.addKeyListener(enterProcessor);
        this.cityTextField.addKeyListener(enterProcessor);
        this.addrInterpolationList.addKeyListener(enterProcessor);
        this.incrementTextField.addKeyListener(enterProcessor);
        this.addrInterpolationList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (!AddrInterpolationDialog.this.interpolationMethodSet && AddrInterpolationDialog.this.autoDetectInterpolationMethod()) {
                    AddrInterpolationDialog.this.interpolationMethodSet = true;
                }
            }
        });
        this.addrInterpolationList.addActionListener(e -> {
            int selectedIndex = this.addrInterpolationList.getSelectedIndex();
            this.incrementTextField.setEnabled(selectedIndex == 4);
        });
        editControlsPane.add((Component)this.cbConvertToHouseNumbers, c);
        if (!this.houseNumberNodes.isEmpty()) {
            JLabel houseNumberNodeNote = new JLabel(I18n.tr((String)"Will associate {0} additional house number nodes", (Object[])new Object[]{this.houseNumberNodes.size()}));
            editControlsPane.add((Component)houseNumberNodeNote, c);
        }
        editControlsPane.add((Component)new UrlLabel("https://wiki.openstreetmap.org/wiki/JOSM/Plugins/AddrInterpolation", I18n.tr((String)"More information about this feature", (Object[])new Object[0]), 2), c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(15, 0, 0, 0);
        c.anchor = 22;
        JButton okButton = new JButton(I18n.tr((String)"OK", (Object[])new Object[0]), ImageProvider.get((String)"ok"));
        editControlsPane.add((Component)okButton, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.anchor = 21;
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]), ImageProvider.get((String)"cancel"));
        editControlsPane.add((Component)cancelButton, c);
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        return editControlsPane;
    }

    private boolean autoDetectInterpolationMethod() {
        String startValueString = AddrInterpolationDialog.readTextField(this.startTextField);
        String endValueString = AddrInterpolationDialog.readTextField(this.endTextField);
        if (startValueString == null || endValueString == null) {
            return false;
        }
        if (AddrInterpolationDialog.isLong(startValueString) && AddrInterpolationDialog.isLong(endValueString)) {
            long startValue = Long.parseLong(startValueString);
            long endValue = Long.parseLong(endValueString);
            if (AddrInterpolationDialog.isEven(startValue)) {
                if (AddrInterpolationDialog.isEven(endValue)) {
                    this.selectInterpolationMethod("even");
                } else {
                    this.selectInterpolationMethod("all");
                }
            } else if (!AddrInterpolationDialog.isEven(endValue)) {
                this.selectInterpolationMethod("odd");
            } else {
                this.selectInterpolationMethod("all");
            }
        } else {
            char startingChar = startValueString.charAt(startValueString.length() - 1);
            char endingChar = endValueString.charAt(endValueString.length() - 1);
            if (!AddrInterpolationDialog.isNumeric("" + startingChar) && !AddrInterpolationDialog.isNumeric("" + endingChar)) {
                this.selectInterpolationMethod("alphabetic");
                return true;
            }
            if (AddrInterpolationDialog.isNumeric("" + startingChar) && !AddrInterpolationDialog.isNumeric("" + endingChar) && (endingChar = Character.toUpperCase(endingChar)) >= 'A' && endingChar <= 'Z') {
                this.selectInterpolationMethod("alphabetic");
                return true;
            }
            return false;
        }
        return true;
    }

    private void selectInterpolationMethod(String currentMethod) {
        int currentIndex = 0;
        if (AddrInterpolationDialog.isLong(currentMethod)) {
            currentIndex = this.addrInterpolationTags.length - 1;
            this.incrementTextField.setText(currentMethod);
            this.incrementTextField.setEnabled(true);
        } else {
            for (int i = 0; i < this.addrInterpolationTags.length; ++i) {
                if (!this.addrInterpolationTags[i].equals(currentMethod)) continue;
                currentIndex = i;
                break;
            }
        }
        this.addrInterpolationList.setSelectedIndex(currentIndex);
    }

    private void selectInclusion(String currentMethod) {
        int currentIndex = 0;
        for (int i = 0; i < this.addrInclusionTags.length; ++i) {
            if (!this.addrInclusionTags[i].equals(currentMethod)) continue;
            currentIndex = i;
            break;
        }
        this.addrInclusionList.setSelectedIndex(currentIndex);
    }

    private JPanel createOptionalFields() {
        JPanel editControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        editControlsPane.setLayout(gridbag);
        editControlsPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel[] optionalTextLabels = new JLabel[]{new JLabel(I18n.tr((String)"City:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"State:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"Post Code:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"Country:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"Full Address:", (Object[])new Object[0]))};
        this.cityTextField = new JTextField(lastCity, 100);
        this.stateTextField = new JTextField(lastState, 100);
        this.postCodeTextField = new JTextField(lastPostCode, 20);
        this.countryTextField = new JTextField(lastCountry, 2);
        this.fullTextField = new JTextField(lastFullAddress, 300);
        this.countryTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField jtextfield = (JTextField)e.getSource();
                String text = jtextfield.getText();
                int length = text.length();
                if (length == jtextfield.getColumns()) {
                    e.consume();
                } else if (length > jtextfield.getColumns()) {
                    e.consume();
                } else if (!e.isActionKey()) {
                    e.setKeyChar(Character.toUpperCase(e.getKeyChar()));
                }
            }
        });
        Component[] optionalEditFields = new Component[]{this.cityTextField, this.stateTextField, this.postCodeTextField, this.countryTextField, this.fullTextField};
        AddrInterpolationDialog.addEditControlRows(optionalTextLabels, optionalEditFields, editControlsPane);
        JPanel optionPanel = new JPanel(new BorderLayout());
        Border groupBox = BorderFactory.createEtchedBorder();
        TitledBorder titleBorder = BorderFactory.createTitledBorder(groupBox, I18n.tr((String)"Optional Information:", (Object[])new Object[0]), 1, 2);
        optionPanel.setBorder(titleBorder);
        optionPanel.add((Component)editControlsPane, "Center");
        return optionPanel;
    }

    private void getExistingMapKeys() {
        for (Node node : this.houseNumberNodes) {
            AddrInterpolationDialog.checkNodeForAddressTags((Tagged)node);
        }
        if (this.addrInterpolationWay != null) {
            String currentInclusion;
            String currentMethod = this.addrInterpolationWay.get("addr:interpolation");
            if (currentMethod != null) {
                this.selectInterpolationMethod(currentMethod);
                this.interpolationMethodSet = true;
            }
            if ((currentInclusion = this.addrInterpolationWay.get("addr:inclusion")) != null) {
                this.selectInclusion(currentInclusion);
            }
            Node firstNode = this.addrInterpolationWay.getNode(0);
            Node lastNode = this.addrInterpolationWay.getNode(this.addrInterpolationWay.getNodesCount() - 1);
            String value = firstNode.get("addr:housenumber");
            if (value != null) {
                this.startTextField.setText(value);
            }
            if ((value = lastNode.get("addr:housenumber")) != null) {
                this.endTextField.setText(value);
            }
            AddrInterpolationDialog.checkNodeForAddressTags((Tagged)firstNode);
            AddrInterpolationDialog.checkNodeForAddressTags((Tagged)lastNode);
        }
    }

    private static void checkNodeForAddressTags(Tagged checkNode) {
        String value = checkNode.get("addr:city");
        if (value != null) {
            lastCity = value;
        }
        if ((value = checkNode.get("addr:state")) != null) {
            lastState = value;
        }
        if ((value = checkNode.get("addr:postcode")) != null) {
            lastPostCode = value;
        }
        if ((value = checkNode.get("addr:country")) != null) {
            lastCountry = value;
        }
        if ((value = checkNode.get("addr:full")) != null) {
            lastFullAddress = value;
        }
    }

    private String findRelation() {
        DataSet currentDataSet = MainApplication.getLayerManager().getEditDataSet();
        if (currentDataSet != null) {
            for (Relation relation : currentDataSet.getRelations()) {
                if (!"associatedStreet".equals(relation.get("type"))) continue;
                for (RelationMember relationMember : relation.getMembers()) {
                    if (!relationMember.isWay()) continue;
                    StringBuilder relationDescription = new StringBuilder();
                    Way way = (Way)relationMember.getMember();
                    if (way != this.selectedStreet) continue;
                    this.associatedStreetRelation = relation;
                    relationDescription.append(way.getId()).append('(');
                    if (relation.getKeys().containsKey((Object)"name")) {
                        relationDescription.append(relation.get("name"));
                    } else {
                        relationDescription.append(this.selectedStreet.get("name"));
                    }
                    relationDescription.append(')');
                    return relationDescription.toString();
                }
            }
        }
        return "";
    }

    private boolean findAndSaveSelections() {
        boolean isValid = false;
        int namedWayCount = 0;
        int unNamedWayCount = 0;
        DataSet currentDataSet = MainApplication.getLayerManager().getEditDataSet();
        if (currentDataSet != null) {
            for (Way way : currentDataSet.getSelectedWays()) {
                if (way.getKeys().containsKey((Object)"name")) {
                    ++namedWayCount;
                    this.selectedStreet = way;
                    continue;
                }
                ++unNamedWayCount;
                this.addrInterpolationWay = way;
            }
            this.houseNumberNodes = new ArrayList();
            for (Node node : currentDataSet.getSelectedNodes()) {
                if (!node.getKeys().containsKey((Object)"addr:housenumber")) continue;
                this.houseNumberNodes.add(node);
            }
            if (this.addrInterpolationWay != null && this.addrInterpolationWay.getNodesCount() > 2) {
                for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 2; ++i) {
                    Node testNode = this.addrInterpolationWay.getNode(i);
                    if (!testNode.getKeys().containsKey((Object)"addr:housenumber")) continue;
                    this.houseNumberNodes.add(testNode);
                }
            }
        }
        if (namedWayCount != 1) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please select a street to associate with address interpolation way", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        } else if (unNamedWayCount != 1) {
            if (!this.houseNumberNodes.isEmpty()) {
                isValid = true;
            } else {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please select address interpolation way for this street", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    private static void addEditControlRows(JLabel[] labels, Component[] editFields, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridx = 0;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 0.0;
            container.add((Component)labels[i], c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            container.add(editFields[i], c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            if (this.validateAndSave()) {
                this.dialog.dispose();
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            this.dialog.dispose();
        }
    }

    private static String baseAlpha(String strValue) {
        if (strValue.length() > 0) {
            return strValue.substring(0, strValue.length() - 1);
        }
        return "";
    }

    private static char lastChar(String strValue) {
        if (strValue.length() > 0) {
            return strValue.charAt(strValue.length() - 1);
        }
        return '\u0000';
    }

    private static boolean isLong(String input) {
        try {
            long val = Long.parseLong(input);
            return val > 0L;
        }
        catch (NumberFormatException e) {
            Logging.trace((Throwable)e);
            return false;
        }
    }

    private static boolean isEven(long input) {
        return input % 2L == 0L;
    }

    private static boolean isNumeric(String s) {
        return PATTERN_NUMERIC.matcher(s).matches();
    }

    private void interpolateAlphaSection(int startNodeIndex, int endNodeIndex, String endValueString, char startingChar, char endingChar) {
        String baseAlpha = AddrInterpolationDialog.baseAlpha(endValueString);
        int nSegments = endNodeIndex - startNodeIndex;
        double[] segmentLengths = new double[nSegments];
        double totalLength = this.calculateSegmentLengths(startNodeIndex, endNodeIndex, segmentLengths);
        int nHouses = endingChar - startingChar - 1;
        if (nHouses > 0) {
            double houseSpacing = totalLength / (double)(nHouses + 1);
            Node lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex);
            int currentSegment = 0;
            int currentChar = startingChar;
            while (nHouses > 0) {
                double distanceNeeded;
                for (distanceNeeded = houseSpacing; distanceNeeded > segmentLengths[currentSegment]; distanceNeeded -= segmentLengths[currentSegment]) {
                    lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex + ++currentSegment);
                }
                double proportion = distanceNeeded / segmentLengths[currentSegment];
                Node toNode = this.addrInterpolationWay.getNode(startNodeIndex + 1 + currentSegment);
                LatLon newHouseNumberPosition = lastHouseNode.getCoor().interpolate(toNode.getCoor(), proportion);
                Node newHouseNumberNode = new Node(newHouseNumberPosition);
                if ((currentChar = (char)(currentChar + '\u0001')) > 90 && currentChar < 97) {
                    currentChar = 97;
                }
                String newHouseNumber = baseAlpha + (char)currentChar;
                newHouseNumberNode.put("addr:housenumber", newHouseNumber);
                this.commandGroup.add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newHouseNumberNode));
                this.houseNumberNodes.add(newHouseNumberNode);
                lastHouseNode = newHouseNumberNode;
                int n = currentSegment;
                segmentLengths[n] = segmentLengths[n] - distanceNeeded;
                --nHouses;
            }
        }
    }

    private void createAlphaInterpolation(String startValueString, String endValueString) {
        char startingChar = AddrInterpolationDialog.lastChar(startValueString);
        char endingChar = AddrInterpolationDialog.lastChar(endValueString);
        if (AddrInterpolationDialog.isLong(startValueString)) {
            startingChar = '@';
        }
        int startIndex = 0;
        for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 1; ++i) {
            char anchorChar;
            Node testNode = this.addrInterpolationWay.getNode(i);
            String endNodeNumber = testNode.get("addr:housenumber");
            if (endNodeNumber == null || "".equals(endNodeNumber) || (anchorChar = AddrInterpolationDialog.lastChar(endNodeNumber)) <= startingChar || anchorChar >= endingChar) continue;
            this.interpolateAlphaSection(startIndex, i, endNodeNumber, startingChar, anchorChar);
            startingChar = anchorChar;
            startValueString = endNodeNumber;
            startIndex = i;
        }
        this.interpolateAlphaSection(startIndex, this.addrInterpolationWay.getNodesCount() - 1, endValueString, startingChar, endingChar);
    }

    private double calculateSegmentLengths(int startNodeIndex, int endNodeIndex, double[] segmentLengths) {
        Node fromNode = this.addrInterpolationWay.getNode(startNodeIndex);
        double totalLength = 0.0;
        int nSegments = segmentLengths.length;
        for (int segment = 0; segment < nSegments; ++segment) {
            Node toNode = this.addrInterpolationWay.getNode(startNodeIndex + 1 + segment);
            segmentLengths[segment] = fromNode.greatCircleDistance((ILatLon)toNode);
            totalLength += segmentLengths[segment];
            fromNode = toNode;
        }
        return totalLength;
    }

    private void interpolateNumericSection(int startNodeIndex, int endNodeIndex, long startingAddr, long endingAddr, long increment) {
        int nSegments = endNodeIndex - startNodeIndex;
        double[] segmentLengths = new double[nSegments];
        double totalLength = this.calculateSegmentLengths(startNodeIndex, endNodeIndex, segmentLengths);
        int nHouses = (int)((endingAddr - startingAddr) / increment) - 1;
        if (nHouses > 0) {
            double houseSpacing = totalLength / (double)(nHouses + 1);
            Node lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex);
            int currentSegment = 0;
            long currentHouseNumber = startingAddr;
            while (nHouses > 0) {
                double distanceNeeded;
                for (distanceNeeded = houseSpacing; distanceNeeded > segmentLengths[currentSegment]; distanceNeeded -= segmentLengths[currentSegment]) {
                    lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex + ++currentSegment);
                }
                double proportion = distanceNeeded / segmentLengths[currentSegment];
                Node toNode = this.addrInterpolationWay.getNode(startNodeIndex + 1 + currentSegment);
                LatLon newHouseNumberPosition = lastHouseNode.getCoor().interpolate(toNode.getCoor(), proportion);
                Node newHouseNumberNode = new Node(newHouseNumberPosition);
                String newHouseNumber = Long.toString(currentHouseNumber += increment);
                newHouseNumberNode.put("addr:housenumber", newHouseNumber);
                this.commandGroup.add((Command)new AddCommand(MainApplication.getLayerManager().getEditDataSet(), (OsmPrimitive)newHouseNumberNode));
                this.houseNumberNodes.add(newHouseNumberNode);
                lastHouseNode = newHouseNumberNode;
                int n = currentSegment;
                segmentLengths[n] = segmentLengths[n] - distanceNeeded;
                --nHouses;
            }
        }
    }

    private void createNumericInterpolation(String startValueString, String endValueString, long increment) {
        long startingAddr = Long.parseLong(startValueString);
        long endingAddr = Long.parseLong(endValueString);
        int startIndex = 0;
        for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 1; ++i) {
            long anchorAddrNumber;
            Node testNode = this.addrInterpolationWay.getNode(i);
            String strEndNodeNumber = testNode.get("addr:housenumber");
            if (strEndNodeNumber == null || !AddrInterpolationDialog.isLong(strEndNodeNumber) || (anchorAddrNumber = Long.parseLong(strEndNodeNumber)) <= startingAddr || anchorAddrNumber >= endingAddr) continue;
            this.interpolateNumericSection(startIndex, i, startingAddr, anchorAddrNumber, increment);
            startingAddr = anchorAddrNumber;
            startValueString = strEndNodeNumber;
            startIndex = i;
        }
        this.interpolateNumericSection(startIndex, this.addrInterpolationWay.getNodesCount() - 1, startingAddr, endingAddr, increment);
    }

    private void convertWayToHousenumbers(String selectedMethod, String startValueString, String endValueString, String incrementString) {
        if ("alphabetic".equals(selectedMethod)) {
            this.createAlphaInterpolation(startValueString, endValueString);
        } else {
            long increment = 1L;
            if ("odd".equals(selectedMethod) || "even".equals(selectedMethod)) {
                increment = 2L;
            } else if ("Numeric".equals(selectedMethod)) {
                increment = Long.parseLong(incrementString);
            }
            this.createNumericInterpolation(startValueString, endValueString, increment);
        }
        this.removeAddressInterpolationWay();
    }

    private void removeAddressInterpolationWay() {
        Command deleteCommand = DeleteCommand.delete(Collections.singleton(this.addrInterpolationWay), (boolean)true);
        if (deleteCommand != null) {
            this.commandGroup.add(deleteCommand);
        }
        this.addrInterpolationWay = null;
    }

    private boolean validateAndSave() {
        String startValueString = AddrInterpolationDialog.readTextField(this.startTextField);
        String endValueString = AddrInterpolationDialog.readTextField(this.endTextField);
        String incrementString = AddrInterpolationDialog.readTextField(this.incrementTextField);
        String city = AddrInterpolationDialog.readTextField(this.cityTextField);
        String state = AddrInterpolationDialog.readTextField(this.stateTextField);
        String postCode = AddrInterpolationDialog.readTextField(this.postCodeTextField);
        String country = AddrInterpolationDialog.readTextField(this.countryTextField);
        String fullAddress = AddrInterpolationDialog.readTextField(this.fullTextField);
        String selectedMethod = this.getInterpolationMethod();
        if (this.addrInterpolationWay != null) {
            Long startAddr = 0L;
            Long endAddr = 0L;
            if (!"alphabetic".equals(selectedMethod)) {
                Long[] addrArray = new Long[]{startAddr, endAddr};
                if (!AddrInterpolationDialog.validAddressNumbers(startValueString, endValueString, addrArray)) {
                    return false;
                }
                startAddr = addrArray[0];
                endAddr = addrArray[1];
            }
            String errorMessage = "";
            switch (selectedMethod) {
                case "odd": {
                    if (!AddrInterpolationDialog.isEven(startAddr) && !AddrInterpolationDialog.isEven(endAddr)) break;
                    errorMessage = I18n.tr((String)"Expected odd numbers for addresses", (Object[])new Object[0]);
                    break;
                }
                case "even": {
                    if (AddrInterpolationDialog.isEven(startAddr) && AddrInterpolationDialog.isEven(endAddr)) break;
                    errorMessage = I18n.tr((String)"Expected even numbers for addresses", (Object[])new Object[0]);
                    break;
                }
                case "alphabetic": {
                    errorMessage = AddrInterpolationDialog.validateAlphaAddress(startValueString, endValueString);
                    break;
                }
                case "Numeric": {
                    if (AddrInterpolationDialog.validNumericIncrementString(incrementString, startAddr, endAddr)) break;
                    errorMessage = I18n.tr((String)"Expected valid number for increment", (Object[])new Object[0]);
                    break;
                }
            }
            if (!"".equals(errorMessage)) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), errorMessage, I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                return false;
            }
        }
        if (country != null && country.length() != 2) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Country code must be 2 letters", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            return false;
        }
        this.commandGroup = new LinkedList<Command>();
        String streetName = this.selectedStreet.get("name");
        DataSet currentDataSet = MainApplication.getLayerManager().getEditDataSet();
        if (this.addrInterpolationWay != null) {
            Node firstNode = this.addrInterpolationWay.getNode(0);
            Node lastNode = this.addrInterpolationWay.getNode(this.addrInterpolationWay.getNodesCount() - 1);
            currentDataSet.clearSelection(new PrimitiveId[]{this.addrInterpolationWay});
            currentDataSet.clearSelection(new PrimitiveId[]{lastNode});
            String interpolationTagValue = selectedMethod;
            if ("Numeric".equals(selectedMethod)) {
                interpolationTagValue = incrementString;
            }
            if (this.cbConvertToHouseNumbers.getState()) {
                this.convertWayToHousenumbers(selectedMethod, startValueString, endValueString, incrementString);
            } else {
                this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)this.addrInterpolationWay, "addr:interpolation", interpolationTagValue));
                this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)this.addrInterpolationWay, "addr:inclusion", this.getInclusionMethod()));
            }
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)firstNode, "addr:housenumber", startValueString));
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)lastNode, "addr:housenumber", endValueString));
            this.houseNumberNodes.add(firstNode);
            this.houseNumberNodes.add(lastNode);
        }
        if (this.streetRelationButton.isSelected()) {
            if (this.associatedStreetRelation == null) {
                this.createRelation(currentDataSet, streetName);
            }
            this.editedRelation = new Relation(this.associatedStreetRelation);
            if (this.addrInterpolationWay != null) {
                this.addToRelation(this.associatedStreetRelation, (OsmPrimitive)this.addrInterpolationWay, "house");
            }
        }
        for (Node node : this.houseNumberNodes) {
            if (this.streetRelationButton.isSelected()) {
                this.addToRelation(this.associatedStreetRelation, (OsmPrimitive)node, "house");
            }
            HashMap<String, String> tags = new HashMap<String, String>();
            if (city != null || this.streetNameButton.isSelected()) {
                tags.put("addr:street", streetName);
            }
            tags.put("addr:city", city);
            tags.put("addr:state", state);
            tags.put("addr:postcode", postCode);
            tags.put("addr:country", country);
            tags.put("addr:full", fullAddress);
            this.commandGroup.add((Command)new ChangePropertyCommand(currentDataSet, Collections.singleton(node), tags));
        }
        if (this.relationChanged) {
            this.commandGroup.add((Command)new ChangeCommand(currentDataSet, (OsmPrimitive)this.associatedStreetRelation, (OsmPrimitive)this.editedRelation));
        }
        if (!this.commandGroup.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Address Interpolation", (Object[])new Object[0]), this.commandGroup));
            MainApplication.getLayerManager().getEditLayer().invalidate();
        }
        return true;
    }

    private static boolean validNumericIncrementString(String incrementString, long startingAddr, long endingAddr) {
        if (!AddrInterpolationDialog.isLong(incrementString)) {
            return false;
        }
        long testIncrement = Long.parseLong(incrementString);
        if (testIncrement <= 0L || testIncrement > endingAddr) {
            return false;
        }
        return (endingAddr - startingAddr) % testIncrement == 0L;
    }

    private void createRelation(DataSet currentDataSet, String streetName) {
        this.associatedStreetRelation = new Relation();
        this.associatedStreetRelation.put("name", streetName);
        this.associatedStreetRelation.put("type", "associatedStreet");
        RelationMember newStreetMember = new RelationMember("street", (OsmPrimitive)this.selectedStreet);
        this.associatedStreetRelation.addMember(newStreetMember);
        this.commandGroup.add((Command)new AddCommand(currentDataSet, (OsmPrimitive)this.associatedStreetRelation));
    }

    private static String readTextField(JTextField field) {
        String value = field.getText();
        if (value != null && "".equals(value = value.trim())) {
            value = null;
        }
        return value;
    }

    private void addToRelation(Relation relation, OsmPrimitive testMember, String role) {
        boolean isFound = false;
        for (RelationMember relationMember : relation.getMembers()) {
            if (testMember != relationMember.getMember()) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            RelationMember newMember = new RelationMember(role, testMember);
            this.editedRelation.addMember(newMember);
            this.relationChanged = true;
        }
    }

    private static String validateAlphaAddress(String startValueString, String endValueString) {
        String errorMessage = "";
        if ("".equals(startValueString) || "".equals(endValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for starting and ending address", (Object[])new Object[0]);
        } else {
            char startingChar = AddrInterpolationDialog.lastChar(startValueString);
            char endingChar = AddrInterpolationDialog.lastChar(endValueString);
            boolean isOk = false;
            if (AddrInterpolationDialog.isNumeric("" + startingChar) && !AddrInterpolationDialog.isNumeric("" + endingChar)) {
                if ((endingChar = Character.toUpperCase(endingChar)) >= 'A' && endingChar <= 'Z') {
                    isOk = true;
                }
            } else if (!AddrInterpolationDialog.isNumeric("" + startingChar) && !AddrInterpolationDialog.isNumeric("" + endingChar)) {
                isOk = true;
            }
            if (!isOk) {
                errorMessage = I18n.tr((String)"Alphabetic address must end with a letter", (Object[])new Object[0]);
            }
            if (endValueString.length() > 1) {
                String numEnd;
                String numStart = AddrInterpolationDialog.baseAlpha(startValueString);
                if (AddrInterpolationDialog.isNumeric(startValueString)) {
                    numStart = startValueString;
                }
                if (!numStart.equals(numEnd = AddrInterpolationDialog.baseAlpha(endValueString))) {
                    errorMessage = I18n.tr((String)"Starting and ending numbers must be the same for alphabetic addresses", (Object[])new Object[0]);
                }
            }
            if (startingChar >= endingChar) {
                errorMessage = I18n.tr((String)"Starting address letter must be less than ending address letter", (Object[])new Object[0]);
            }
        }
        return errorMessage;
    }

    private static boolean validAddressNumbers(String startValueString, String endValueString, Long[] addrArray) {
        String errorMessage = "";
        if (!AddrInterpolationDialog.isLong(startValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for starting address", (Object[])new Object[0]);
        }
        if (!AddrInterpolationDialog.isLong(endValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for ending address", (Object[])new Object[0]);
        }
        if ("".equals(errorMessage)) {
            addrArray[0] = Long.parseLong(startValueString);
            addrArray[1] = Long.parseLong(endValueString);
            if (addrArray[1] <= addrArray[0]) {
                errorMessage = I18n.tr((String)"Starting address number must be less than ending address number", (Object[])new Object[0]);
            }
        }
        if ("".equals(errorMessage)) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), errorMessage, I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        return false;
    }

    private String getInterpolationMethod() {
        int selectedIndex = this.addrInterpolationList.getSelectedIndex();
        return this.addrInterpolationTags[selectedIndex];
    }

    private String getInclusionMethod() {
        int selectedIndex;
        lastAccuracyIndex = selectedIndex = this.addrInclusionList.getSelectedIndex();
        return this.addrInclusionTags[selectedIndex];
    }

    static {
        lastCity = "";
        lastState = "";
        lastPostCode = "";
        lastCountry = "";
        lastFullAddress = "";
        PATTERN_NUMERIC = Pattern.compile("^[0-9]+$");
    }
}

