/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImageLayer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImportImagePlugin;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.tools.Logging;

public class LayerPropertiesDialog
extends JFrame {
    private final List<String> supportedCRS;
    private ImageLayer imageLayer;
    private JPanel mainPanel;
    private JPanel jPanel;
    private JPanel buttonPanel;
    private JTabbedPane jTabbedPane;
    private JPanel infoPanel;
    private JPanel crsPanel;
    private JButton okButton;
    private JLabel defaultCRSLabel;
    private JTextField searchField;
    private JScrollPane crsListScrollPane;
    private JList<String> crsJList;
    private JButton useDefaultCRSButton;
    private JButton applySelectedCRSButton;
    private JButton setSelectedCRSAsDefaultButton;
    private JCheckBox eastingFirstCheckBox;

    public LayerPropertiesDialog(ImageLayer imageLayer, List<String> supportedCRS) {
        super(imageLayer.getName());
        this.supportedCRS = supportedCRS;
        this.imageLayer = imageLayer;
        this.initialize();
    }

    public LayerPropertiesDialog(List<String> supportedCRS) {
        this.supportedCRS = supportedCRS;
        this.initialize();
    }

    private void initialize() {
        this.setMinimumSize(new Dimension(404, 485));
        this.setContentPane(this.getMainPanel());
        this.setPreferredSize(new Dimension(404, 485));
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(null);
            this.mainPanel.add((Component)this.getJPanel(), null);
            this.mainPanel.add((Component)this.getButtonPanel(), null);
        }
        return this.mainPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBounds(new Rectangle(0, 0, 391, 406));
            this.jPanel.add((Component)this.getJTabbedPane(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(null);
            this.buttonPanel.setBounds(new Rectangle(0, 405, 391, 46));
            this.buttonPanel.add((Component)this.getOkButton(), null);
        }
        return this.buttonPanel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("General Information", null, this.getInfoPanel(), null);
            this.jTabbedPane.addTab("Source Reference System", null, this.getCrsPanel(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            JLabel lowerRightValueLabel = new JLabel();
            lowerRightValueLabel.setBounds(new Rectangle(210, 315, 134, 16));
            lowerRightValueLabel.setHorizontalAlignment(4);
            lowerRightValueLabel.setText((float)this.imageLayer.getBbox().getMinX() + ", " + (float)this.imageLayer.getBbox().getMaxY());
            JLabel lowerLeftValueLabel = new JLabel();
            lowerLeftValueLabel.setBounds(new Rectangle(30, 315, 133, 16));
            lowerLeftValueLabel.setHorizontalAlignment(2);
            lowerLeftValueLabel.setText((float)this.imageLayer.getBbox().getMinX() + ", " + (float)this.imageLayer.getBbox().getMinY());
            JLabel upperRightValueLabel = new JLabel();
            upperRightValueLabel.setBounds(new Rectangle(210, 255, 138, 16));
            upperRightValueLabel.setHorizontalAlignment(4);
            upperRightValueLabel.setText((float)this.imageLayer.getBbox().getMaxX() + ", " + (float)this.imageLayer.getBbox().getMaxY());
            JLabel upperLeftValueLabel = new JLabel();
            upperLeftValueLabel.setBounds(new Rectangle(30, 255, 133, 16));
            upperLeftValueLabel.setHorizontalAlignment(2);
            upperLeftValueLabel.setText((float)this.imageLayer.getBbox().getMaxX() + ", " + (float)this.imageLayer.getBbox().getMinY());
            JLabel lowerRightLabel = new JLabel();
            lowerRightLabel.setBounds(new Rectangle(287, 344, 74, 16));
            lowerRightLabel.setText("Lower Right");
            JLabel upperRightLabel = new JLabel();
            upperRightLabel.setBounds(new Rectangle(285, 225, 91, 16));
            upperRightLabel.setText("Upper Right");
            JLabel lowerLeftLabel = new JLabel();
            lowerLeftLabel.setBounds(new Rectangle(15, 345, 92, 16));
            lowerLeftLabel.setText("Lower Left");
            JLabel upperLeftLabel = new JLabel();
            upperLeftLabel.setBounds(new Rectangle(15, 224, 91, 16));
            upperLeftLabel.setText("Upper Left");
            JLabel extentLabel = new JLabel();
            extentLabel.setBounds(new Rectangle(120, 195, 136, 16));
            extentLabel.setEnabled(false);
            extentLabel.setHorizontalAlignment(0);
            extentLabel.setDisplayedMnemonic(0);
            extentLabel.setText("Extent");
            JLabel crsValueLabel = new JLabel();
            crsValueLabel.setBounds(new Rectangle(150, 150, 226, 16));
            String crsDescription = "";
            try {
                crsDescription = ((ReferenceIdentifier)this.imageLayer.getBbox().getCoordinateReferenceSystem().getIdentifiers().iterator().next()).toString();
            }
            catch (Exception e) {
                Logging.debug((Throwable)e);
            }
            crsValueLabel.setText(crsDescription + "(" + this.imageLayer.getBbox().getCoordinateReferenceSystem().getName().toString() + ")");
            JLabel crsLabel = new JLabel();
            crsLabel.setBounds(new Rectangle(15, 150, 118, 16));
            crsLabel.setText("Reference System");
            JLabel sizeValueLabel = new JLabel();
            sizeValueLabel.setBounds(new Rectangle(150, 105, 226, 16));
            sizeValueLabel.setText(this.imageLayer.getImage().getHeight() + " x " + this.imageLayer.getImage().getWidth());
            JLabel sizeLabel = new JLabel();
            sizeLabel.setBounds(new Rectangle(15, 105, 121, 16));
            sizeLabel.setText("Image size");
            JLabel imageFileValueLabel = new JLabel();
            imageFileValueLabel.setBounds(new Rectangle(150, 60, 226, 16));
            imageFileValueLabel.setText(this.imageLayer.getImageFile().getAbsolutePath());
            imageFileValueLabel.setToolTipText(this.imageLayer.getImageFile().getAbsolutePath());
            JLabel imageFileLabel = new JLabel();
            imageFileLabel.setBounds(new Rectangle(15, 60, 121, 16));
            imageFileLabel.setText("Image file");
            JLabel layerNameValueLabel = new JLabel();
            layerNameValueLabel.setBounds(new Rectangle(150, 15, 226, 16));
            layerNameValueLabel.setText(this.imageLayer.getName());
            JLabel layerNameLabel = new JLabel();
            layerNameLabel.setBounds(new Rectangle(15, 15, 121, 16));
            layerNameLabel.setText("Layer name");
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(null);
            this.infoPanel.setFont(new Font("Dialog", 1, 12));
            this.infoPanel.add((Component)layerNameLabel, null);
            this.infoPanel.add((Component)layerNameValueLabel, null);
            this.infoPanel.add((Component)imageFileLabel, null);
            this.infoPanel.add((Component)imageFileValueLabel, null);
            this.infoPanel.add((Component)sizeLabel, null);
            this.infoPanel.add((Component)sizeValueLabel, null);
            this.infoPanel.add((Component)crsLabel, null);
            this.infoPanel.add((Component)crsValueLabel, null);
            this.infoPanel.add((Component)extentLabel, null);
            this.infoPanel.add((Component)upperLeftLabel, null);
            this.infoPanel.add((Component)lowerLeftLabel, null);
            this.infoPanel.add((Component)upperRightLabel, null);
            this.infoPanel.add((Component)lowerRightLabel, null);
            this.infoPanel.add((Component)upperLeftValueLabel, null);
            this.infoPanel.add((Component)upperRightValueLabel, null);
            this.infoPanel.add((Component)lowerLeftValueLabel, null);
            this.infoPanel.add((Component)lowerRightValueLabel, null);
        }
        return this.infoPanel;
    }

    private JPanel getCrsPanel() {
        if (this.crsPanel == null) {
            JLabel currentCRSValueLabel = new JLabel();
            currentCRSValueLabel.setBounds(new Rectangle(78, 33, 297, 16));
            String crsDescription = "unknown";
            try {
                crsDescription = ((ReferenceIdentifier)this.imageLayer.getSourceRefSys().getIdentifiers().iterator().next()).toString();
            }
            catch (Exception e) {
                Logging.debug((Throwable)e);
            }
            currentCRSValueLabel.setText(crsDescription);
            JLabel currentCRSLabel = new JLabel();
            currentCRSLabel.setBounds(new Rectangle(15, 33, 52, 16));
            currentCRSLabel.setText("Current:");
            JLabel tabDescriptionLabel = new JLabel();
            tabDescriptionLabel.setBounds(new Rectangle(15, 9, 361, 16));
            tabDescriptionLabel.setText("Set here the source reference system of the image");
            JLabel eastingFirstLabel = new JLabel();
            eastingFirstLabel.setBounds(new Rectangle(315, 210, 76, 46));
            eastingFirstLabel.setHorizontalTextPosition(11);
            eastingFirstLabel.setHorizontalAlignment(0);
            eastingFirstLabel.setText("<html>Easting<br>first</html>");
            JLabel searchFieldLabel = new JLabel();
            searchFieldLabel.setBounds(new Rectangle(298, 114, 84, 16));
            searchFieldLabel.setDisplayedMnemonic(0);
            searchFieldLabel.setHorizontalTextPosition(11);
            searchFieldLabel.setHorizontalAlignment(0);
            searchFieldLabel.setText("Search");
            this.defaultCRSLabel = new JLabel();
            this.defaultCRSLabel.setBounds(new Rectangle(15, 89, 361, 16));
            this.defaultCRSLabel.setText(PluginOperations.defaultSourceCRSDescription);
            JLabel defaultCRSDescriptorLabel = new JLabel();
            defaultCRSDescriptorLabel.setBounds(new Rectangle(15, 63, 226, 16));
            defaultCRSDescriptorLabel.setText("Default Reference System:");
            this.crsPanel = new JPanel();
            this.crsPanel.setLayout(null);
            this.crsPanel.add((Component)defaultCRSDescriptorLabel, null);
            this.crsPanel.add((Component)this.defaultCRSLabel, null);
            this.crsPanel.add((Component)this.getSearchField(), null);
            this.crsPanel.add((Component)this.getCrsListScrollPane(), null);
            this.crsPanel.add((Component)this.getUseDefaultCRSButton(), null);
            this.crsPanel.add((Component)this.getApplySelectedCRSButton(), null);
            this.crsPanel.add((Component)this.getSetSelectedCRSAsDefaultButton(), null);
            this.crsPanel.add((Component)searchFieldLabel, null);
            this.crsPanel.add((Component)this.getEastingFirstCheckBox(), null);
            this.crsPanel.add((Component)eastingFirstLabel, null);
            this.crsPanel.add((Component)tabDescriptionLabel, null);
            this.crsPanel.add((Component)currentCRSLabel, null);
            this.crsPanel.add((Component)currentCRSValueLabel, null);
        }
        return this.crsPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(134, 5, 136, 31));
            this.okButton.setText("OK");
            this.okButton.addActionListener(e -> {
                this.setVisible(false);
                this.dispose();
            });
        }
        return this.okButton;
    }

    private JTextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = new JTextField();
            this.searchField.setBounds(new Rectangle(13, 111, 282, 20));
            this.searchField.setToolTipText("Enter keywords or EPSG codes");
            this.searchField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    for (String type : LayerPropertiesDialog.this.supportedCRS) {
                        if (!type.contains(LayerPropertiesDialog.this.searchField.getText())) continue;
                        LayerPropertiesDialog.this.crsJList.setSelectedIndex(LayerPropertiesDialog.this.supportedCRS.indexOf(type));
                        LayerPropertiesDialog.this.crsJList.ensureIndexIsVisible(LayerPropertiesDialog.this.supportedCRS.indexOf(type));
                        break;
                    }
                }
            });
        }
        return this.searchField;
    }

    private JScrollPane getCrsListScrollPane() {
        if (this.crsListScrollPane == null) {
            this.crsListScrollPane = new JScrollPane();
            this.crsListScrollPane.setBounds(new Rectangle(15, 135, 301, 241));
            this.crsListScrollPane.setViewportView(this.getCrsJList());
        }
        return this.crsListScrollPane;
    }

    private JList<String> getCrsJList() {
        if (this.crsJList == null) {
            this.crsJList = new JList<String>(this.supportedCRS.toArray(new String[0]));
            this.crsJList.addListSelectionListener(new ListSelectionHandler());
        }
        return this.crsJList;
    }

    private JButton getUseDefaultCRSButton() {
        if (this.useDefaultCRSButton == null) {
            this.useDefaultCRSButton = new JButton();
            this.useDefaultCRSButton.setBounds(new Rectangle(253, 54, 118, 28));
            this.useDefaultCRSButton.setText("Apply Default");
            this.useDefaultCRSButton.addActionListener(e -> {
                try {
                    this.setCursor(new Cursor(3));
                    if (PluginOperations.defaultSourceCRS != null) {
                        this.imageLayer.resample(PluginOperations.defaultSourceCRS);
                    } else {
                        JOptionPane.showMessageDialog(this.getContentPane(), "<html>No default reference system available.<br>Please select one from the list</html>");
                    }
                }
                catch (IOException | FactoryException e1) {
                    Logging.error((Throwable)e1);
                }
                finally {
                    this.setCursor(new Cursor(0));
                }
            });
        }
        return this.useDefaultCRSButton;
    }

    private JButton getApplySelectedCRSButton() {
        if (this.applySelectedCRSButton == null) {
            this.applySelectedCRSButton = new JButton();
            this.applySelectedCRSButton.setBounds(new Rectangle(315, 135, 69, 61));
            this.applySelectedCRSButton.setHorizontalAlignment(0);
            this.applySelectedCRSButton.setHorizontalTextPosition(11);
            this.applySelectedCRSButton.setText("<html>Apply<br>Selection</html>");
            this.applySelectedCRSButton.addActionListener(e -> {
                String selection = this.crsJList.getSelectedValue();
                String code = selection.substring(selection.indexOf("[-") + 2, selection.indexOf("-]"));
                try {
                    CoordinateReferenceSystem newRefSys = CRS.decode((String)code, (boolean)this.eastingFirstCheckBox.isSelected());
                    this.setCursor(new Cursor(3));
                    this.imageLayer.resample(newRefSys);
                }
                catch (IOException | FactoryException e1) {
                    Logging.error((Throwable)e1);
                }
                finally {
                    this.setCursor(new Cursor(0));
                }
            });
        }
        return this.applySelectedCRSButton;
    }

    private JButton getSetSelectedCRSAsDefaultButton() {
        if (this.setSelectedCRSAsDefaultButton == null) {
            this.setSelectedCRSAsDefaultButton = new JButton();
            this.setSelectedCRSAsDefaultButton.setBounds(new Rectangle(315, 300, 69, 61));
            this.setSelectedCRSAsDefaultButton.setText("<html>Set as<br>Default</html>");
            this.setSelectedCRSAsDefaultButton.addActionListener(e -> {
                if (this.crsJList.getSelectedValue() != null) {
                    String selection = this.crsJList.getSelectedValue();
                    String code = selection.substring(selection.indexOf("[-") + 2, selection.indexOf("-]"));
                    try {
                        PluginOperations.defaultSourceCRS = CRS.decode((String)code, (boolean)this.eastingFirstCheckBox.isSelected());
                        PluginOperations.defaultSourceCRSDescription = selection;
                        ImportImagePlugin.pluginProps.setProperty("default_crs_eastingfirst", "" + this.eastingFirstCheckBox.isSelected());
                        ImportImagePlugin.pluginProps.setProperty("default_crs_srid", code);
                        try (BufferedWriter fileWriter = Files.newBufferedWriter(Paths.get(ImportImagePlugin.PLUGINPROPERTIES_PATH, new String[0]), new OpenOption[0]);){
                            ImportImagePlugin.pluginProps.store(fileWriter, null);
                        }
                        this.defaultCRSLabel.setText(selection);
                    }
                    catch (IOException | FactoryException e2) {
                        Logging.error((Throwable)e2);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Please make a selection from the list.");
                }
            });
        }
        return this.setSelectedCRSAsDefaultButton;
    }

    private JCheckBox getEastingFirstCheckBox() {
        if (this.eastingFirstCheckBox == null) {
            this.eastingFirstCheckBox = new JCheckBox();
            this.eastingFirstCheckBox.setBounds(new Rectangle(345, 255, 21, 21));
            this.eastingFirstCheckBox.setSelected(true);
        }
        return this.eastingFirstCheckBox;
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                LayerPropertiesDialog.this.searchField.setText(LayerPropertiesDialog.this.supportedCRS.get(e.getLastIndex()));
                LayerPropertiesDialog.this.searchField.setEditable(true);
            }
        }
    }
}

