/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gpx;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.IGpxWaypointVisitor;
import org.openstreetmap.josm.tools.Logging;

public class ElevationProfile
implements IElevationProfile,
IGpxWaypointVisitor {
    public static final int WAYPOINT_START = 0;
    public static final int WAYPOINT_END = 1;
    public static final int WAYPOINT_MIN = 2;
    public static final int WAYPOINT_MAX = 3;
    private String name;
    private int minHeight;
    private int maxHeight;
    private int avrgHeight;
    private double dist;
    private Instant start;
    private Instant end;
    private final WayPoint[] importantWayPoints = new WayPoint[4];
    private IElevationProfile parent;
    private int sumEle;
    private List<WayPoint> wayPoints;
    private int numWayPoints;
    private int gain;
    private int lastEle;
    private Bounds bounds;
    private static boolean ignoreZeroHeight = true;

    public ElevationProfile(String name) {
        this(name, null, null, 0);
    }

    public ElevationProfile(String name, IElevationProfile parent, List<WayPoint> wayPoints, int sliceSize) {
        this.name = name;
        this.parent = parent;
        this.setWayPoints(wayPoints);
    }

    public static boolean isIgnoreZeroHeight() {
        return ignoreZeroHeight;
    }

    public static void setIgnoreZeroHeight(boolean ignoreZeroHeight) {
        ElevationProfile.ignoreZeroHeight = ignoreZeroHeight;
    }

    @Override
    public void updateElevationData() {
        this.updateValues();
    }

    protected void updateValues() {
        if (this.wayPoints == null) {
            return;
        }
        int n = this.wayPoints.size();
        if (n == 0) {
            return;
        }
        this.start = Instant.EPOCH;
        this.end = Instant.now();
        this.minHeight = Integer.MAX_VALUE;
        this.maxHeight = Integer.MIN_VALUE;
        this.sumEle = 0;
        this.gain = 0;
        this.lastEle = 0;
        for (WayPoint wayPoint : this.wayPoints) {
            this.visitWayPoint(wayPoint);
        }
        if (this.minHeight == Integer.MAX_VALUE && this.maxHeight == Integer.MIN_VALUE) {
            this.minHeight = 0;
            this.maxHeight = 0;
            this.setMinWayPoint(this.wayPoints.get(0));
            this.setMaxWayPoint(this.wayPoints.get(n - 1));
        }
        this.setStart(this.wayPoints.get(0));
        this.setEnd(this.wayPoints.get(n - 1));
        this.avrgHeight = this.sumEle / n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setMinWayPoint(WayPoint wp) {
        this.importantWayPoints[2] = wp;
        this.minHeight = (int)ElevationHelper.getElevation(wp);
    }

    protected void setMaxWayPoint(WayPoint wp) {
        this.importantWayPoints[3] = wp;
        this.maxHeight = (int)ElevationHelper.getElevation(wp);
    }

    protected void setAvrgHeight(int avrgHeight) {
        this.avrgHeight = avrgHeight;
    }

    protected void setStart(WayPoint wp) {
        this.importantWayPoints[0] = wp;
        if (wp.getInstant() != null) {
            this.start = wp.getInstant();
        }
    }

    protected void setEnd(WayPoint wp) {
        this.importantWayPoints[1] = wp;
        if (wp.getInstant() != null) {
            this.end = wp.getInstant();
        }
    }

    public void setParent(IElevationProfile parent) {
        this.parent = parent;
    }

    public void setWayPoints(List<WayPoint> wayPoints) {
        if (this.wayPoints != wayPoints) {
            this.wayPoints = new ArrayList<WayPoint>(wayPoints);
            this.numWayPoints = wayPoints != null ? wayPoints.size() : 0;
            this.updateValues();
        }
    }

    protected boolean checkIndex(int index) {
        return index >= 0 && index < this.getNumberOfWayPoints();
    }

    @Override
    public int elevationValueAt(int i) {
        if (this.checkIndex(i)) {
            return (int)ElevationHelper.getElevation(this.wayPoints.get(i));
        }
        throw new IndexOutOfBoundsException(String.format("Invalid index: %d, expected 0..%d", i, this.getNumberOfWayPoints()));
    }

    @Override
    public int getAverageHeight() {
        return this.avrgHeight;
    }

    @Override
    public List<IElevationProfile> getChildren() {
        return null;
    }

    @Override
    public Instant getEnd() {
        return this.end;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getHeightDifference() {
        return this.maxHeight - this.minHeight;
    }

    @Override
    public int getGain() {
        return this.gain;
    }

    @Override
    public double getDistance() {
        return this.dist;
    }

    protected void setDistance(double dist) {
        this.dist = dist;
    }

    @Override
    public long getTimeDifference() {
        WayPoint wp1 = this.getStartWayPoint();
        WayPoint wp2 = this.getEndWayPoint();
        if (wp1 != null && wp2 != null) {
            Instant wp1Date = wp1.getInstant();
            Instant wp2Date = wp2.getInstant();
            if (wp1Date != null && wp2Date != null) {
                return wp2Date.toEpochMilli() - wp1Date.toEpochMilli();
            }
            Logging.warn((String)("Waypoints without date: " + String.valueOf(wp1) + " / " + String.valueOf(wp2)));
        }
        return 0L;
    }

    @Override
    public IElevationProfile getParent() {
        return this.parent;
    }

    @Override
    public Instant getStart() {
        return this.start;
    }

    @Override
    public WayPoint getEndWayPoint() {
        return this.importantWayPoints[1];
    }

    @Override
    public WayPoint getMaxWayPoint() {
        return this.importantWayPoints[3];
    }

    @Override
    public WayPoint getMinWayPoint() {
        return this.importantWayPoints[2];
    }

    @Override
    public WayPoint getStartWayPoint() {
        return this.importantWayPoints[0];
    }

    @Override
    public List<WayPoint> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public int getNumberOfWayPoints() {
        return this.numWayPoints;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean hasElevationData() {
        return this.minHeight != this.maxHeight;
    }

    @Override
    public void visitWayPoint(WayPoint wp) {
        if (wp == null) {
            return;
        }
        if (wp.hasDate()) {
            if (wp.getInstant().isAfter(this.end)) {
                this.setEnd(wp);
            }
            if (wp.getInstant().isBefore(this.start)) {
                this.setStart(wp);
            }
        }
        if (this.bounds == null) {
            this.bounds = new Bounds(wp.getCoor());
        } else {
            this.bounds.extend(wp.getCoor());
        }
        int ele = (int)ElevationHelper.getElevation(wp);
        if (!ElevationProfile.isIgnoreZeroHeight() || ele > 0) {
            if (ele > this.maxHeight) {
                this.setMaxWayPoint(wp);
            }
            if (ele < this.minHeight) {
                this.setMinWayPoint(wp);
            }
            if (ele > this.lastEle) {
                this.gain += ele - this.lastEle;
            }
            this.sumEle += ele;
            this.lastEle = ele;
        }
    }

    public String toString() {
        return this.name;
    }
}

