/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity.time;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Time;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.quantity.time.TimeQuantities;
import tech.units.indriya.unit.Units;

public final class TimeUnitQuantity
extends AbstractQuantity<Time> {
    private static final long serialVersionUID = -5840251813363744230L;
    private final TimeUnit timeUnit;
    private final Number value;

    TimeUnitQuantity(TimeUnit timeUnit, Number value) {
        super(TimeUnitQuantity.toUnit(timeUnit));
        this.timeUnit = timeUnit;
        this.value = value;
    }

    public static TimeUnitQuantity of(Number number, TimeUnit timeUnit) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TimeUnitQuantity of(Quantity<Time> quantity) {
        Quantity<Time> seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue());
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return TimeUnitQuantity.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TimeUnitQuantity to(TimeUnit aTimeUnit) {
        Quantity<Time> time = this.toQuantity().to(TimeUnitQuantity.toUnit(aTimeUnit));
        return new TimeUnitQuantity(aTimeUnit, time.getValue().longValue());
    }

    private static Unit<Time> toUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECONDS: {
                return TimeQuantities.MICROSECOND;
            }
            case MILLISECONDS: {
                return TimeQuantities.MILLISECOND;
            }
            case NANOSECONDS: {
                return TimeQuantities.NANOSECOND;
            }
            case SECONDS: {
                return Units.SECOND;
            }
            case MINUTES: {
                return Units.MINUTE;
            }
            case HOURS: {
                return Units.HOUR;
            }
            case DAYS: {
                return Units.DAY;
            }
        }
        throw new IllegalStateException("In TimeUnitQuantity just supports DAYS, HOURS, MICROSECONDS, MILLISECONDS, MINUTES, NANOSECONDS, SECONDS ");
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.timeUnit, this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TimeUnitQuantity.class.isInstance(obj)) {
            TimeUnitQuantity other = (TimeUnitQuantity)TimeUnitQuantity.class.cast(obj);
            return Objects.equals((Object)this.timeUnit, (Object)other.timeUnit) && Objects.equals(this.value, other.value);
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && Calculus.currentNumberSystem().compare(this.value, that.getValue()) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Time unit:" + (Object)((Object)this.timeUnit) + " value: " + this.value;
    }

    @Override
    public ComparableQuantity<Time> add(Quantity<Time> that) {
        UnitConverter thisToThat = this.getUnit().getConverterTo(that.getUnit());
        boolean thatUnitIsSmaller = Calculus.currentNumberSystem().compare(thisToThat.convert(1.0), 1.0) > 0;
        Unit<Time> preferedUnit = thatUnitIsSmaller ? that.getUnit() : this.getUnit();
        Number thisValueInPreferedUnit = TimeUnitQuantity.convertedQuantityValue(this, preferedUnit);
        Number thatValueInPreferedUnit = TimeUnitQuantity.convertedQuantityValue(that, preferedUnit);
        Number resultValueInPreferedUnit = Calculator.of(thisValueInPreferedUnit).add(thatValueInPreferedUnit).peek();
        return Quantities.getQuantity(resultValueInPreferedUnit, preferedUnit);
    }

    @Override
    public ComparableQuantity<Time> subtract(Quantity<Time> that) {
        return this.add((Quantity)that.negate());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, (a, b) -> Calculator.of(a).divide((Number)b).peek(), Unit::divide);
    }

    @Override
    public ComparableQuantity<Time> divide(Number that) {
        return this.applyMultiplicativeNumberOperation(that, (a, b) -> Calculator.of(a).divide((Number)b).peek());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, (a, b) -> Calculator.of(a).multiply((Number)b).peek(), Unit::multiply);
    }

    @Override
    public ComparableQuantity<Time> multiply(Number that) {
        return this.applyMultiplicativeNumberOperation(that, (a, b) -> Calculator.of(a).multiply((Number)b).peek());
    }

    @Override
    public ComparableQuantity<Frequency> inverse() {
        return Quantities.getQuantity(Calculator.of(this.value).reciprocal().peek(), TimeUnitQuantity.toUnit(this.timeUnit).inverse()).asType(Frequency.class);
    }

    @Override
    public Quantity<Time> negate() {
        return TimeUnitQuantity.of(Calculator.of(this.value).negate().peek(), this.getTimeUnit());
    }

    private static <R extends Quantity<R>> Number quantityValue(Quantity<R> that) {
        return TimeUnitQuantity.convertedQuantityValue(that, that.getUnit());
    }

    private static <R extends Quantity<R>> Number convertedQuantityValue(Quantity<R> that, Unit<R> unit) {
        return that.getUnit().getConverterTo(unit).convert(that.getValue());
    }

    private ComparableQuantity<?> applyMultiplicativeQuantityOperation(Quantity<?> that, BinaryOperator<Number> valueOperator, BinaryOperator<Unit<?>> unitOperator) {
        Number thisValue = TimeUnitQuantity.quantityValue(this);
        Number thatValue = TimeUnitQuantity.quantityValue(that);
        Number result = (Number)valueOperator.apply(thisValue, thatValue);
        Unit resultUnit = (Unit)unitOperator.apply(this.getUnit(), that.getUnit());
        return Quantities.getQuantity(result, resultUnit);
    }

    private ComparableQuantity<Time> applyMultiplicativeNumberOperation(Number that, BinaryOperator<Number> valueOperator) {
        Number thisValue = this.getValue();
        Number thatValue = that;
        Number result = (Number)valueOperator.apply(thisValue, thatValue);
        return Quantities.getQuantity(result, this.getUnit());
    }
}

