/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectZip;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemDisk;
import org.h2.util.New;

public class FileSystemZip
extends FileSystem {
    private static final FileSystemZip INSTANCE = new FileSystemZip();

    private FileSystemZip() {
    }

    public static FileSystemZip getInstance() {
        return INSTANCE;
    }

    public boolean canWrite(String string) {
        return false;
    }

    public void copy(String string, String string2) throws SQLException {
        throw Message.getUnsupportedException("write");
    }

    public void createDirs(String string) {
    }

    public boolean createNewFile(String string) throws SQLException {
        throw Message.getUnsupportedException("write");
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        if (!bl2) {
            throw new IOException("File system is read-only");
        }
        return FileSystemDisk.getInstance().createTempFile(string, string2, bl, true);
    }

    public void delete(String string) throws SQLException {
        throw Message.getUnsupportedException("write");
    }

    public void deleteRecursive(String string, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("write");
    }

    public boolean exists(String string) {
        try {
            String string2 = this.getEntryName(string);
            if (string2.length() == 0) {
                return true;
            }
            ZipFile zipFile = this.openZipFile(string);
            return zipFile.getEntry(string2) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean fileStartsWith(String string, String string2) {
        return string.startsWith(string2);
    }

    public String getAbsolutePath(String string) {
        return string;
    }

    public String getFileName(String string) {
        int n;
        if ((string = this.getEntryName(string)).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(47)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public long getLastModified(String string) {
        return 0L;
    }

    public String getParent(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public boolean isAbsolute(String string) {
        return true;
    }

    public boolean isDirectory(String string) {
        try {
            String string2 = this.getEntryName(string);
            if (string2.length() == 0) {
                return true;
            }
            ZipFile zipFile = this.openZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (string3.equals(string2)) {
                    return zipEntry.isDirectory();
                }
                if (!string3.startsWith(string2) || string3.length() != string2.length() + 1 || !string3.equals(string2 + "/")) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReadOnly(String string) {
        return true;
    }

    public long length(String string) {
        try {
            ZipFile zipFile = this.openZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(this.getEntryName(string));
            return zipEntry == null ? 0L : zipEntry.getSize();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public String[] listFiles(String string) throws SQLException {
        try {
            String[] stringArray;
            if (string.indexOf(33) < 0) {
                string = string + "!";
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            ZipFile zipFile = this.openZipFile(string);
            String string2 = this.getEntryName(string);
            String string3 = string.substring(0, string.length() - string2.length());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ArrayList<String> arrayList = New.arrayList();
            while (enumeration.hasMoreElements()) {
                int n;
                stringArray = enumeration.nextElement();
                String string4 = stringArray.getName();
                if (!string4.startsWith(string2) || string4.length() <= string2.length() || (n = string4.indexOf(47, string2.length())) >= 0 && n < string4.length() - 1) continue;
                arrayList.add(string3 + string4);
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "listFiles " + string);
        }
    }

    public String normalize(String string) {
        return string;
    }

    public InputStream openFileInputStream(String string) throws IOException {
        FileObject fileObject = this.openFileObject(string, "r");
        return new FileObjectInputStream(fileObject);
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        ZipFile zipFile = this.openZipFile(this.translateFileName(string));
        ZipEntry zipEntry = zipFile.getEntry(this.getEntryName(string));
        if (zipEntry == null) {
            throw new FileNotFoundException(string);
        }
        return new FileObjectZip(zipFile, zipEntry);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("write");
    }

    public void rename(String string, String string2) throws SQLException {
        throw Message.getUnsupportedException("write");
    }

    public boolean tryDelete(String string) {
        return false;
    }

    private String translateFileName(String string) {
        int n;
        if (string.startsWith("zip:")) {
            string = string.substring("zip:".length());
        }
        if ((n = string.indexOf(33)) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String getEntryName(String string) {
        int n = string.indexOf(33);
        string = n <= 0 ? "" : string.substring(n + 1);
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private ZipFile openZipFile(String string) throws IOException {
        string = this.translateFileName(string);
        return new ZipFile(string);
    }
}

