/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Property;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.PropertyExtractor;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingVisitorDispatch;
import org.geotools.xsd.impl.GetPropertiesExecutor;
import org.geotools.xsd.impl.GetPropertyExecutor;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Element;

public class BindingPropertyExtractor
implements PropertyExtractor {
    Encoder encoder;
    MutablePicoContainer context;

    public BindingPropertyExtractor(Encoder encoder, MutablePicoContainer context) {
        this.encoder = encoder;
        this.context = context;
    }

    @Override
    public boolean canHandle(Object object) {
        return true;
    }

    public void setContext(MutablePicoContainer context) {
        this.context = context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List properties(Object object, XSDElementDeclaration element) {
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        List<XSDParticle> children = this.encoder.getSchemaIndex().getChildElementParticles(element);
        if (this.isUnboundedSequence(object, element)) {
            this.processUnboundedSequence(object, properties, children);
        } else {
            for (XSDParticle particle : children) {
                Object child = (XSDElementDeclaration)particle.getContent();
                if (child.isElementDeclarationReference()) {
                    child = child.getResolvedElementDeclaration();
                }
                GetPropertyExecutor getPropertyExecutor = new GetPropertyExecutor(object, (XSDNamedComponent)child);
                BindingVisitorDispatch.walk(object, this.encoder.getBindingWalker(), element, getPropertyExecutor, this.context);
                if (getPropertyExecutor.getChildObject() == null) continue;
                properties.add(new Object[]{particle, getPropertyExecutor.getChildObject()});
            }
            GetPropertiesExecutor executor = new GetPropertiesExecutor(object, element);
            BindingVisitorDispatch.walk(object, this.encoder.getBindingWalker(), element, executor, this.context);
            if (!executor.getProperties().isEmpty()) {
                ArrayListValuedHashMap map = new ArrayListValuedHashMap();
                for (Object[] objectArray : executor.getProperties()) {
                    map.put(objectArray[0], objectArray[1]);
                }
                HashMap<QName, XSDParticle> particles = new HashMap<QName, XSDParticle>();
                for (Object key : map.keySet()) {
                    XSDParticle particle;
                    if (key instanceof XSDParticle) {
                        XSDParticle particle2 = (XSDParticle)key;
                        particles.put(Schemas.getParticleName(particle2), particle2);
                        continue;
                    }
                    QName name = (QName)key;
                    Collection values = map.get((Object)name);
                    if (Encoder.COMMENT.equals(name)) {
                        Element comment = this.encoder.getDocument().createElement(Encoder.COMMENT.getLocalPart());
                        for (Object value : values) {
                            comment.appendChild(this.encoder.getDocument().createTextNode(value.toString()));
                        }
                        particle = XSDFactory.eINSTANCE.createXSDParticle();
                        XSDElementDeclaration elementDecl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                        elementDecl.setTargetNamespace(Encoder.COMMENT.getNamespaceURI());
                        elementDecl.setName(Encoder.COMMENT.getLocalPart());
                        elementDecl.setElement(comment);
                        particle.setContent(elementDecl);
                        particles.put(name, particle);
                        continue;
                    }
                    XSDElementDeclaration elementDecl = this.encoder.getSchemaIndex().getElementDeclaration(name);
                    if (elementDecl == null && (particle = Schemas.getChildElementParticle(element.getType(), name.getLocalPart(), true)) != null) {
                        particles.put(name, particle);
                        continue;
                    }
                    if (elementDecl == null) {
                        elementDecl = this.encoder.getSchema().resolveElementDeclaration(name.getNamespaceURI(), name.getLocalPart());
                    }
                    XSDParticle reference = null;
                    for (XSDParticle particle3 : Schemas.getChildElementParticles(element.getType(), true)) {
                        XSDElementDeclaration el = (XSDElementDeclaration)particle3.getContent();
                        if (el.isElementDeclarationReference()) {
                            el = el.getResolvedElementDeclaration();
                        }
                        if (!Schemas.isBaseType(elementDecl, el)) continue;
                        reference = particle3;
                        break;
                    }
                    XSDParticle particle4 = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper.setResolvedElementDeclaration(elementDecl);
                    particle4.setContent(wrapper);
                    if (reference != null) {
                        particle4.setMaxOccurs(reference.getMaxOccurs());
                    } else if (values.size() > 1) {
                        particle4.setMaxOccurs(-1);
                    } else {
                        particle4.setMaxOccurs(1);
                    }
                    particles.put(name, particle4);
                }
                for (Object[] property : executor.getProperties()) {
                    Collection values = map.get(property[0]);
                    QName name = property[0] instanceof XSDParticle ? Schemas.getParticleName((XSDParticle)property[0]) : (QName)property[0];
                    XSDParticle particle = (XSDParticle)particles.get(name);
                    if (particle == null) continue;
                    if (values.size() > 1) {
                        properties.add(new Object[]{particle, values});
                    } else {
                        properties.add(new Object[]{particle, values.iterator().next()});
                    }
                    particles.remove(name);
                }
            }
        }
        if (properties.size() <= 1) {
            return properties;
        }
        if (object instanceof ComplexAttributeImpl && this.propertiesSortable(properties, children)) {
            ArrayList<Object[]> sortedProperties = new ArrayList<Object[]>();
            block6: for (int i = 0; i < children.size(); ++i) {
                XSDParticle particle = children.get(i);
                XSDElementDeclaration xSDElementDeclaration = (XSDElementDeclaration)particle.getContent();
                if (xSDElementDeclaration.getResolvedElementDeclaration() != null) {
                    XSDElementDeclaration xSDElementDeclaration2 = xSDElementDeclaration.getResolvedElementDeclaration();
                }
                for (Object[] prop : properties) {
                    void var8_18;
                    XSDParticle part = (XSDParticle)prop[0];
                    XSDElementDeclaration partContent = (XSDElementDeclaration)part.getContent();
                    if (partContent.getResolvedElementDeclaration() != null) {
                        partContent = partContent.getResolvedElementDeclaration();
                    }
                    if (!var8_18.getName().equals(partContent.getName()) || var8_18.getTargetNamespace() != null && partContent.getTargetNamespace() != null && !var8_18.getTargetNamespace().equals(partContent.getTargetNamespace())) continue;
                    sortedProperties.add(prop);
                    properties.remove(prop);
                    --i;
                    continue block6;
                }
            }
            return sortedProperties;
        }
        return properties;
    }

    private void processUnboundedSequence(Object object, List<Object[]> properties, List<XSDParticle> children) {
        ComplexAttribute complexAttr = (ComplexAttribute)object;
        Deque<Attribute> attrDeque = this.getChildrenAttributes(complexAttr);
        int tuplesNumber = children.size();
        ArrayList attributeTuples = new ArrayList();
        while (!attrDeque.isEmpty()) {
            ArrayList<Attribute> attrTuple = new ArrayList<Attribute>();
            for (int i = 0; i < tuplesNumber; ++i) {
                attrTuple.add(attrDeque.poll());
            }
            attributeTuples.add(attrTuple);
        }
        for (List list : attributeTuples) {
            if (list == null || list.isEmpty()) continue;
            for (XSDParticle particle : children) {
                XSDElementDeclaration childAux = (XSDElementDeclaration)particle.getContent();
                if (childAux.isElementDeclarationReference()) {
                    childAux = childAux.getResolvedElementDeclaration();
                }
                XSDElementDeclaration child = childAux;
                Optional<Attribute> attributeOpt = list.stream().filter(x -> this.attributeMatches((Attribute)x, child)).findFirst();
                if (!attributeOpt.isPresent()) continue;
                Attribute attribute = attributeOpt.get();
                properties.add(new Object[]{particle, attribute.getValue()});
            }
        }
    }

    private boolean attributeMatches(Attribute att, XSDElementDeclaration declaration) {
        return Optional.ofNullable(att).map(a -> a.getDescriptor()).map(a -> a.getName()).map(a -> a.getLocalPart()).isPresent() && Objects.equals(declaration.getName(), att.getDescriptor().getName().getLocalPart()) && Objects.equals(declaration.getTargetNamespace(), att.getDescriptor().getName().getNamespaceURI());
    }

    private boolean isUnboundedSequence(Object object, XSDElementDeclaration element) {
        XSDTypeDefinition anonymousTypeDefinition = element.getAnonymousTypeDefinition();
        if (anonymousTypeDefinition == null || anonymousTypeDefinition.getComplexType() == null || anonymousTypeDefinition.getComplexType().getMaxOccurs() != -1) {
            return false;
        }
        if (!(object instanceof ComplexAttribute)) {
            return false;
        }
        ComplexAttribute complexAttr = (ComplexAttribute)object;
        return Optional.ofNullable(complexAttr.getUserData().get("multi_value_type")).filter(x -> x instanceof String).map(x -> (String)x).filter(x -> x.equalsIgnoreCase("unbounded-multi-value")).isPresent();
    }

    private Deque<Attribute> getChildrenAttributes(ComplexAttribute complesAttribute) {
        Collection<Property> props = complesAttribute.getProperties();
        Deque attrDeque = props.stream().filter(x -> x instanceof Attribute).map(x -> (Attribute)x).collect(Collectors.toCollection(ArrayDeque::new));
        return attrDeque;
    }

    private boolean propertiesSortable(List properties, List children) {
        if (properties.size() > children.size()) {
            return false;
        }
        for (Object property : properties) {
            Object[] prop = (Object[])property;
            XSDParticle part = (XSDParticle)prop[0];
            XSDElementDeclaration partContent = (XSDElementDeclaration)part.getContent();
            if (partContent.getResolvedElementDeclaration() != null) {
                partContent = partContent.getResolvedElementDeclaration();
            }
            boolean notFound = true;
            for (Object o : children) {
                XSDParticle particle = (XSDParticle)o;
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child.getResolvedElementDeclaration() != null) {
                    child = child.getResolvedElementDeclaration();
                }
                if (!child.getName().equals(partContent.getName()) || !(child.getTargetNamespace() == null ? partContent.getTargetNamespace() == null : child.getTargetNamespace().equals(partContent.getTargetNamespace()))) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            return false;
        }
        return true;
    }
}

