/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class PointPlacementImpl
implements PointPlacement,
Cloneable {
    public static final AnchorPoint DEFAULT_ANCHOR_POINT = new AnchorPoint(){

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant AnchorPoint may not be modified");
        }

        @Override
        public void setAnchorPointX(Expression x) {
            this.cannotModifyConstant();
        }

        @Override
        public void setAnchorPointY(Expression y) {
            this.cannotModifyConstant();
        }

        @Override
        public void accept(StyleVisitor visitor) {
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object data) {
            this.cannotModifyConstant();
            return null;
        }

        @Override
        public Expression getAnchorPointX() {
            return ConstantExpression.constant(0.0);
        }

        @Override
        public Expression getAnchorPointY() {
            return ConstantExpression.constant(0.5);
        }
    };
    private static final Logger LOGGER = Logging.getLogger(PointPlacementImpl.class);
    private final FilterFactory filterFactory;
    private AnchorPointImpl anchorPoint = new AnchorPointImpl();
    private DisplacementImpl displacement = new DisplacementImpl();
    private Expression rotation = null;

    public PointPlacementImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public PointPlacementImpl(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.rotation = this.filterFactory.literal((Object)0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultPointPlacement: " + ife);
        }
    }

    @Override
    public AnchorPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    @Override
    public void setAnchorPoint(AnchorPoint anchorPoint) {
        if (this.anchorPoint == anchorPoint) {
            return;
        }
        this.anchorPoint = AnchorPointImpl.cast(anchorPoint);
    }

    @Override
    public Displacement getDisplacement() {
        return this.displacement;
    }

    @Override
    public void setDisplacement(Displacement displacement) {
        if (this.displacement == displacement) {
            return;
        }
        this.displacement = DisplacementImpl.cast(displacement);
    }

    @Override
    public Expression getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            PointPlacementImpl clone = (PointPlacementImpl)super.clone();
            clone.anchorPoint = (AnchorPointImpl)this.anchorPoint.clone();
            clone.displacement = (DisplacementImpl)this.displacement.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PointPlacementImpl) {
            PointPlacementImpl other = (PointPlacementImpl)obj;
            return Utilities.equals(this.anchorPoint, other.anchorPoint) && Utilities.equals(this.displacement, other.displacement) && Utilities.equals(this.rotation, other.rotation);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.anchorPoint != null) {
            result = result * 37 + this.anchorPoint.hashCode();
        }
        if (this.displacement != null) {
            result = result * 37 + this.displacement.hashCode();
        }
        if (this.rotation != null) {
            result = result * 37 + this.rotation.hashCode();
        }
        return result;
    }

    static PointPlacementImpl cast(LabelPlacement placement) {
        if (placement == null) {
            return null;
        }
        if (placement instanceof PointPlacementImpl) {
            return (PointPlacementImpl)placement;
        }
        if (placement instanceof PointPlacement) {
            PointPlacement pointPlacement = (PointPlacement)placement;
            PointPlacementImpl copy = new PointPlacementImpl();
            copy.setAnchorPoint(AnchorPointImpl.cast(pointPlacement.getAnchorPoint()));
            copy.setDisplacement(DisplacementImpl.cast(pointPlacement.getDisplacement()));
            return copy;
        }
        return null;
    }
}

