/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.math.Complex;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ModifiedParameterDescriptor;
import org.geotools.referencing.operation.projection.ProjectionException;

public class NewZealandMapGrid
extends MapProjection {
    private static final long serialVersionUID = 8394817836243729133L;
    private static final Complex[] A = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    private static final Complex[] B = new Complex[]{new Complex(1.3231270439, 0.0), new Complex(-0.577245789, -0.007809598), new Complex(0.508307513, -0.112208952), new Complex(-0.15094762, 0.18200602), new Complex(1.01418179, 1.64497696), new Complex(1.9660549, 2.5127645)};
    private static final double[] TPHI = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] TPSI = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};

    protected NewZealandMapGrid() {
        this(Provider.PARAMETERS.createValue());
    }

    protected NewZealandMapGrid(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    final boolean isExpectedParameter(Collection<GeneralParameterDescriptor> expected, ParameterDescriptor param) {
        return ModifiedParameterDescriptor.contains(expected, param);
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double dphi;
        double dphi_pow_i = dphi = (y - this.latitudeOfOrigin) * 2.0626480624709633;
        double dpsi = 0.0;
        for (double v : TPSI) {
            dpsi += v * dphi_pow_i;
            dphi_pow_i *= dphi;
        }
        Complex theta = new Complex(dpsi, x);
        Complex power = new Complex(theta);
        Complex z = new Complex();
        z.multiply(A[0], power);
        for (int i = 1; i < A.length; ++i) {
            power.multiply(power, theta);
            z.addMultiply(z, A[i], power);
        }
        if (ptDst != null) {
            ptDst.setLocation(z.imag, z.real);
            return ptDst;
        }
        return new Point2D.Double(z.imag, z.real);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double dpsi;
        Complex z = new Complex(y, x);
        Complex power = new Complex(z);
        Complex theta = new Complex();
        theta.multiply(B[0], z);
        for (int j = 1; j < B.length; ++j) {
            power.multiply(power, z);
            theta.addMultiply(theta, B[j], power);
        }
        Complex num = new Complex();
        Complex denom = new Complex();
        Complex t = new Complex();
        for (int j = 0; j < 3; ++j) {
            int k;
            power.power(theta, 2);
            num.addMultiply(z, A[1], power);
            for (k = 2; k < A.length; ++k) {
                power.multiply(power, theta);
                t.multiply(A[k], power);
                t.multiply(t, k);
                num.add(num, t);
            }
            power.real = 1.0;
            power.imag = 0.0;
            denom.copy(A[0]);
            for (k = 1; k < A.length; ++k) {
                power.multiply(power, theta);
                t.multiply(A[k], power);
                t.multiply(t, k + 1);
                denom.add(denom, t);
            }
            theta.divide(num, denom);
        }
        double dpsi_pow_i = dpsi = theta.real;
        double dphi = TPHI[0] * dpsi;
        for (int i = 1; i < TPHI.length; ++i) {
            dphi += TPHI[i] * (dpsi_pow_i *= dpsi);
        }
        dphi = dphi / 2.0626480624709633 + this.latitudeOfOrigin;
        if (ptDst != null) {
            ptDst.setLocation(theta.imag, dphi);
            return ptDst;
        }
        return new Point2D.Double(theta.imag, dphi);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -7716733400419275656L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "New_Zealand_Map_Grid"), new NamedIdentifier(Citations.EPSG, "New Zealand Map Grid"), new NamedIdentifier(Citations.EPSG, "27200")}, new ParameterDescriptor[]{new ModifiedParameterDescriptor(SEMI_MAJOR, 6378388.0), new ModifiedParameterDescriptor(SEMI_MINOR, 6356911.9461279465), new ModifiedParameterDescriptor(LATITUDE_OF_ORIGIN, -41.0), new ModifiedParameterDescriptor(CENTRAL_MERIDIAN, 173.0), new ModifiedParameterDescriptor(FALSE_EASTING, 2510000.0), new ModifiedParameterDescriptor(FALSE_NORTHING, 6023150.0)});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new NewZealandMapGrid(parameters);
        }
    }
}

