/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.XMatrix;

public final class MatrixFactory {
    private MatrixFactory() {
    }

    public static XMatrix create(int size) {
        switch (size) {
            case 1: {
                return new Matrix1();
            }
            case 2: {
                return new Matrix2();
            }
            case 3: {
                return new Matrix3();
            }
            case 4: {
                return new Matrix4();
            }
        }
        return new GeneralMatrix(size);
    }

    public static XMatrix create(int numRow, int numCol) {
        if (numRow == numCol) {
            return MatrixFactory.create(numRow);
        }
        return new GeneralMatrix(numRow, numCol);
    }

    public static XMatrix create(Matrix matrix) {
        int size = matrix.getNumRow();
        if (size == matrix.getNumCol()) {
            switch (size) {
                case 1: {
                    return new Matrix1(matrix);
                }
                case 2: {
                    return new Matrix2(matrix);
                }
                case 3: {
                    return new Matrix3(matrix);
                }
                case 4: {
                    return new Matrix4(matrix);
                }
            }
        }
        return new GeneralMatrix(matrix);
    }
}

