/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.bindings;

import java.lang.reflect.Field;
import javax.measure.Unit;
import javax.xml.namespace.QName;
import org.geotools.ows.v1_1.OWS;
import org.geotools.xsd.AbstractSimpleBinding;
import org.geotools.xsd.InstanceComponent;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.BaseUnit;

public class UnitBinding
extends AbstractSimpleBinding {
    @Override
    public QName getTarget() {
        return OWS.UOM;
    }

    public Class getType() {
        return Unit.class;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        Unit<?> valueOf = this.lookup((String)value);
        return valueOf;
    }

    private Unit<?> lookup(String name) {
        Unit<?> unit = this.lookup(SI.class, name);
        if (unit != null) {
            return unit;
        }
        unit = this.lookup(NonSI.class, name);
        if (unit != null) {
            return unit;
        }
        if (name.endsWith("s") || name.endsWith("S")) {
            return this.lookup(name.substring(0, name.length() - 1));
        }
        if (name.equalsIgnoreCase("feet")) {
            return this.lookup(NonSI.class, "foot");
        }
        if (name.equalsIgnoreCase("meters") || name.equalsIgnoreCase("meter")) {
            return this.lookup(SI.class, "m");
        }
        if (name.equalsIgnoreCase("unity")) {
            return AbstractUnit.ONE;
        }
        return null;
    }

    private Unit<?> lookup(Class<?> class1, String name) {
        Field[] fields;
        for (Field field : fields = class1.getDeclaredFields()) {
            String name2 = field.getName();
            if (!field.getType().isAssignableFrom(BaseUnit.class) && !field.getType().isAssignableFrom(AlternateUnit.class) || !name2.equalsIgnoreCase(name)) continue;
            try {
                Unit unit = (Unit)field.get(class1);
                return unit;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        return object.toString();
    }
}

