/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.jdbc.ConnectionLifecycleListener;
import org.geotools.jdbc.JDBCDataStore;

public class SessionCommandsListener
implements ConnectionLifecycleListener {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private Expression sqlOnBorrow;
    private Expression sqlOnRelease;

    public SessionCommandsListener(String sqlOnBorrow, String sqlOnRelease) {
        this.sqlOnBorrow = this.expandEviromentVariables(sqlOnBorrow);
        this.sqlOnRelease = this.expandEviromentVariables(sqlOnRelease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBorrow(JDBCDataStore store, Connection cx) throws SQLException {
        String command;
        if (this.sqlOnBorrow != null && !"".equals(command = this.sqlOnBorrow.evaluate(null, String.class))) {
            Statement st = null;
            try {
                st = cx.createStatement();
                st.execute(command);
            }
            finally {
                store.closeSafe(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRelease(JDBCDataStore store, Connection cx) throws SQLException {
        if (this.sqlOnRelease != null) {
            String command = this.sqlOnRelease.evaluate(null, String.class);
            Statement st = null;
            try {
                st = cx.createStatement();
                st.execute(command);
            }
            finally {
                store.closeSafe(st);
            }
        }
    }

    @Override
    public void onCommit(JDBCDataStore store, Connection cx) {
    }

    @Override
    public void onRollback(JDBCDataStore store, Connection cx) {
    }

    Expression expandEviromentVariables(String sql) {
        if (sql == null || "".equals(sql)) {
            return null;
        }
        boolean inEnvVariable = false;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sql.length(); ++i) {
            char next;
            char curr = sql.charAt(i);
            boolean last = i == sql.length() - 1;
            char c = next = last ? (char)'\u0000' : sql.charAt(i + 1);
            if (curr == '\\') {
                if (last) {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                if (next == '\\') {
                    sb.append('\\');
                } else if (next == '$') {
                    sb.append('$');
                } else if (next == '}') {
                    sb.append('}');
                } else {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                ++i;
                continue;
            }
            if (curr == '$') {
                if (last || next != '{') {
                    throw new IllegalArgumentException("Unescaped $ at position " + (i + 1));
                }
                if (inEnvVariable) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                if (sb.length() > 0) {
                    expressions.add(this.ff.literal(sb.toString()));
                    sb.setLength(0);
                }
                inEnvVariable = true;
                ++i;
                continue;
            }
            if (curr == '}' && inEnvVariable) {
                if (sb.length() == 0) {
                    throw new IllegalArgumentException("Invalid empty environment variable reference ${} at " + (i - 1));
                }
                String name = sb.toString();
                String defaultValue = null;
                int idx = name.indexOf(44);
                if (idx >= 0) {
                    if (idx == 0) {
                        throw new IllegalArgumentException("There is no variable name before the comma, the valid format is '${name,defaultValue}'");
                    }
                    if (idx < name.length() - 1) {
                        defaultValue = name.substring(idx + 1);
                        name = name.substring(0, idx);
                    }
                }
                Function env = defaultValue != null ? this.ff.function("env", this.ff.literal(name), this.ff.literal(defaultValue)) : this.ff.function("env", this.ff.literal(name));
                expressions.add(env);
                sb.setLength(0);
                inEnvVariable = false;
                continue;
            }
            sb.append(curr);
        }
        if (inEnvVariable) {
            throw new IllegalArgumentException("Unclosed environment variable reference '" + sb + "'");
        }
        if (sb.length() > 0) {
            expressions.add(this.ff.literal(sb.toString()));
        }
        if (expressions == null || expressions.isEmpty()) {
            throw new IllegalArgumentException("The SQL command appears to be empty: " + sql);
        }
        Expression result = (Expression)expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            result = this.ff.function("strConcat", result, (Expression)expressions.get(i));
        }
        return result;
    }
}

