/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.AbstractPosition;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;

public abstract class AbstractBounds
implements Bounds {
    protected AbstractBounds() {
    }

    static CoordinateReferenceSystem getCoordinateReferenceSystem(Position minDP, Position maxDP) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem crs1 = minDP.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crs2 = maxDP.getCoordinateReferenceSystem();
        if (crs1 == null) {
            return crs2;
        }
        if (crs2 != null && !crs1.equals(crs2)) {
            throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
        }
        return crs1;
    }

    @Override
    public Position getLowerCorner() {
        return new LowerCorner();
    }

    @Override
    public Position getUpperCorner() {
        return new UpperCorner();
    }

    public String toString() {
        return AbstractBounds.toString(this);
    }

    static String toString(Bounds envelope) {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(envelope));
        int dimension = envelope.getDimension();
        if (dimension != 0) {
            int i;
            String separator = "[(";
            for (i = 0; i < dimension; ++i) {
                buffer.append(separator).append(envelope.getMinimum(i));
                separator = ", ";
            }
            separator = "), (";
            for (i = 0; i < dimension; ++i) {
                buffer.append(separator).append(envelope.getMaximum(i));
                separator = ", ";
            }
            buffer.append(")]");
        }
        return buffer.toString();
    }

    public int hashCode() {
        int dimension = this.getDimension();
        int code = 1;
        boolean p = true;
        do {
            for (int i = 0; i < dimension; ++i) {
                long bits = Double.doubleToLongBits(p ? this.getMinimum(i) : this.getMaximum(i));
                code = 31 * code + ((int)bits ^ (int)(bits >>> 32));
            }
        } while (!(p = !p));
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            code += crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Bounds that = (Bounds)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Utilities.equals(this.getMinimum(i), that.getMinimum(i)) && Utilities.equals(this.getMaximum(i), that.getMaximum(i))) continue;
                    return false;
                }
                if (Utilities.equals(this.getCoordinateReferenceSystem(), that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }

    private final class UpperCorner
    extends Corner {
        private UpperCorner() {
        }

        @Override
        public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
            return AbstractBounds.this.getMaximum(dimension);
        }
    }

    private final class LowerCorner
    extends Corner {
        private LowerCorner() {
        }

        @Override
        public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
            return AbstractBounds.this.getMinimum(dimension);
        }
    }

    private abstract class Corner
    extends AbstractPosition {
        private Corner() {
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return AbstractBounds.this.getCoordinateReferenceSystem();
        }

        @Override
        public int getDimension() {
            return AbstractBounds.this.getDimension();
        }

        @Override
        public void setOrdinate(int dimension, double value) {
            throw new UnsupportedOperationException();
        }
    }
}

