/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Logger;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.logging.Logging;

public class FilterFunction_numberFormat
extends FunctionExpressionImpl {
    static final Logger LOGGER = Logging.getLogger(FilterFunction_numberFormat.class);
    static HashSet<String> languages = new HashSet();
    public static FunctionName NAME;

    public FilterFunction_numberFormat() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        Double number;
        String format;
        String localeString = "";
        try {
            format = this.getExpression(0).evaluate(feature, String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function NumberFormat argument #0 - expected type String");
        }
        try {
            number = this.getExpression(1).evaluate(feature, Double.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function NumberFormat argument #1 - expected type java.util.Double");
        }
        if (format == null || number == null) {
            return null;
        }
        try {
            if (this.params.size() > 2) {
                Expression second = this.getExpression(2);
                localeString = second.evaluate(feature, String.class);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function NumberFormat argument #2 - expected type String");
        }
        Locale locale = null;
        if (languages.contains(localeString)) {
            if (localeString != null && !localeString.isEmpty()) {
                locale = Locale.forLanguageTag(localeString);
            }
        } else {
            throw new IllegalArgumentException("Unknown language code '" + localeString + "' in numberFormat function");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        DecimalFormat numberFormat = new DecimalFormat(format, decimalFormatSymbols);
        return numberFormat.format(number);
    }

    static {
        for (Locale loc : Locale.getAvailableLocales()) {
            languages.add(loc.getLanguage());
        }
        NAME = new FunctionNameImpl("numberFormat", String.class, FunctionNameImpl.parameter("format", String.class), FunctionNameImpl.parameter("number", Number.class), FunctionNameImpl.parameter("language", String.class, 0, 1));
    }
}

