/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.RemappingFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShapefileSizeException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ShapefileDumper {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    static final Logger LOGGER = Logging.getLogger(ShapefileDumper.class);
    File targetDirectory;
    long maxShpSize = Integer.MAX_VALUE;
    long maxDbfSize = Integer.MAX_VALUE;
    boolean emptyShapefileAllowed = true;
    Charset charset = (Charset)ShapefileDataStoreFactory.DBFCHARSET.getDefaultValue();

    public ShapefileDumper(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public long getMaxShpSize() {
        return this.maxShpSize;
    }

    public void setMaxShpSize(long maxShapeSize) {
        this.maxShpSize = maxShapeSize;
    }

    public long getMaxDbfSize() {
        return this.maxDbfSize;
    }

    public void setMaxDbfSize(long maxDbfSize) {
        this.maxDbfSize = maxDbfSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isEmptyShapefileAllowed() {
        return this.emptyShapefileAllowed;
    }

    public void setEmptyShapefileAllowed(boolean emptyShapefileAllowed) {
        this.emptyShapefileAllowed = emptyShapefileAllowed;
    }

    public boolean dump(SimpleFeatureCollection fc) throws IOException {
        return this.dump(null, fc);
    }

    public boolean dump(String fileName, SimpleFeatureCollection fc) throws IOException {
        if (((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor() == null) {
            throw new DataSourceException("Cannot write geometryless shapefiles, yet " + fc.getSchema() + " has no geometry field");
        }
        List<SimpleFeatureCollection> geometryCollections = this.splitByGeometryColumn(fc);
        boolean featuresWritten = false;
        if (geometryCollections.size() == 1) {
            featuresWritten = this.dumpSingleGeometry(fileName, fc, null);
        } else {
            for (SimpleFeatureCollection geometryCollection : geometryCollections) {
                String geometryName = ((SimpleFeatureType)geometryCollection.getSchema()).getGeometryDescriptor().getLocalName();
                featuresWritten |= this.dumpSingleGeometry(fileName, geometryCollection, geometryName);
            }
        }
        return featuresWritten;
    }

    private List<SimpleFeatureCollection> splitByGeometryColumn(SimpleFeatureCollection fc) {
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        List geometryColumns = schema.getAttributeDescriptors().stream().filter(sd -> sd instanceof GeometryDescriptor).map(sd -> (GeometryDescriptor)sd).collect(Collectors.toList());
        if (geometryColumns.size() == 1) {
            return Collections.singletonList(fc);
        }
        ArrayList<SimpleFeatureCollection> result = new ArrayList<SimpleFeatureCollection>();
        List<AttributeDescriptor> otherColumns = schema.getAttributeDescriptors().stream().filter(sd -> !(sd instanceof GeometryDescriptor)).collect(Collectors.toList());
        for (GeometryDescriptor geometryColumn : geometryColumns) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName(schema.getName());
            tb.add(geometryColumn);
            tb.addAll(otherColumns);
            SimpleFeatureType ft = tb.buildFeatureType();
            SimpleFeatureCollection nonNullGeometries = DataUtilities.simple(new FilteringFeatureCollection<SimpleFeatureType, SimpleFeature>(fc, FF.not(FF.isNull(FF.property(geometryColumn.getName())))));
            ReTypingFeatureCollection split = new ReTypingFeatureCollection(nonNullGeometries, ft);
            result.add(split);
        }
        List<Filter> nullGeometryFilters = geometryColumns.stream().map(gd -> FF.isNull(FF.property(gd.getName()))).collect(Collectors.toList());
        And nullGeometryFilter = FF.and(nullGeometryFilters);
        SimpleFeatureCollection nullGeometries = DataUtilities.simple(new FilteringFeatureCollection<SimpleFeatureType, SimpleFeature>(fc, nullGeometryFilter));
        if (!nullGeometries.isEmpty()) {
            result.add(nullGeometries);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dumpSingleGeometry(String fileName, SimpleFeatureCollection fc, String geometryName) throws IOException {
        block28: {
            fc = RemappingFeatureCollection.getShapefileCompatibleCollection(fc);
            schema = (SimpleFeatureType)fc.getSchema();
            writers = new HashMap<Class<?>, StoreWriter>();
            featuresWritten = false;
            geomType = schema.getGeometryDescriptor().getType().getBinding();
            multiWriter = GeometryCollection.class.equals(geomType) != false || Geometry.class.equals(geomType) != false;
            nullStoreWriter = null;
            try {
                it = fc.features();
                ** try [egrp 1[TRYBLOCK] [1 : 85->267)] { 
lbl11:
                // 1 sources

                ** GOTO lbl-1000
lbl12:
                // 1 sources

                finally {
                    if (it != null) {
                        it.close();
                    }
                }
            }
            catch (ShapefileSizeException e) {
                try {
                    throw e;
                    catch (Exception ioe) {
                        ShapefileDumper.LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
                        throw new IOException(ioe);
                    }
                }
                catch (Throwable var15_21) {
                    stored = null;
                    writersValues = new ArrayList<V>(writers.values());
                    if (nullStoreWriter != null) {
                        writersValues.add(nullStoreWriter);
                    }
                    for (StoreWriter sw : writersValues) {
                        try {
                            writerSchema = sw.dstore.getSchema();
                            sw.writer.close();
                            sw.dstore.dispose();
                            this.shapefileDumped(writerSchema.getTypeName(), writerSchema);
                        }
                        catch (IOException e) {
                            stored = e;
                        }
                    }
                    if (stored != null) {
                        throw new IOException(stored);
                    }
                    throw var15_21;
                }
            }
lbl-1000:
            // 2 sources

            {
                while (it.hasNext()) {
                    f = (SimpleFeature)it.next();
                    if (multiWriter && f.getDefaultGeometry() == null) {
                        if (nullStoreWriter == null) {
                            nullStoreWriter = this.getStoreWriter(fileName, geometryName, schema, null, multiWriter, Point.class, "_NULL");
                        }
                        storeWriter = nullStoreWriter;
                    } else {
                        storeWriter = this.getStoreWriter(fileName, geometryName, f, writers, multiWriter);
                    }
                    try {
                        this.writeToShapefile(f, storeWriter.writer);
                    }
                    catch (ShapefileSizeException e) {
                        storeWriter.nextWriter();
                        this.writeToShapefile(f, storeWriter.writer);
                    }
                    featuresWritten = true;
                }
                if (featuresWritten || !this.emptyShapefileAllowed) break block28;
                if (multiWriter) {
                    this.getStoreWriter(fileName, geometryName, (SimpleFeatureType)fc.getSchema(), writers, true, Point.class, null);
                    break block28;
                }
                this.getStoreWriter(fileName, geometryName, (SimpleFeatureType)fc.getSchema(), writers, false, geomType, null);
            }
        }
        stored = null;
        writersValues = new ArrayList<V>(writers.values());
        if (nullStoreWriter != null) {
            writersValues.add(nullStoreWriter);
        }
        for (StoreWriter sw : writersValues) {
            try {
                writerSchema = sw.dstore.getSchema();
                sw.writer.close();
                sw.dstore.dispose();
                this.shapefileDumped(writerSchema.getTypeName(), writerSchema);
            }
            catch (IOException e) {
                stored = e;
            }
        }
        if (stored != null) {
            throw new IOException(stored);
        }
        return featuresWritten;
    }

    private void writeToShapefile(SimpleFeature f, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws IOException {
        SimpleFeature fw = writer.next();
        for (AttributeDescriptor d : fw.getFeatureType().getAttributeDescriptors()) {
            fw.setAttribute(d.getLocalName(), f.getAttribute(d.getLocalName()));
        }
        fw.setDefaultGeometry(f.getDefaultGeometry());
        writer.write();
    }

    protected void shapefileDumped(String fileName, SimpleFeatureType remappedSchema) throws IOException {
    }

    private ShapefileDataStore buildStore(SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
        File file = new File(this.targetDirectory, schema.getTypeName() + ".shp");
        ShapefileDataStore sfds = new ShapefileDataStore(URLs.fileToUrl(file));
        sfds.setCharset(this.charset);
        File charsetFile = new File(this.targetDirectory, schema.getTypeName() + ".cst");
        try (PrintWriter pw = new PrintWriter(charsetFile);){
            pw.write(this.charset.name());
        }
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new IOException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        try {
            if (schema.getCoordinateReferenceSystem() != null) {
                sfds.forceSchemaCRS(schema.getCoordinateReferenceSystem());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not properly create the .prj file", e);
        }
        sfds.setMaxShpSize(this.maxShpSize);
        sfds.setMaxDbfSize(this.maxDbfSize);
        return sfds;
    }

    private Map<String, Object> getGeometryType(SimpleFeature f) {
        Class<Point> target;
        String geometryType = null;
        Geometry g = (Geometry)f.getDefaultGeometry();
        if (g instanceof Point) {
            target = Point.class;
            geometryType = "Point";
        } else if (g instanceof MultiPoint) {
            target = MultiPoint.class;
            geometryType = "MPoint";
        } else if (g instanceof MultiPolygon || g instanceof Polygon) {
            target = MultiPolygon.class;
            geometryType = "Polygon";
        } else if (g instanceof LineString || g instanceof MultiLineString) {
            target = MultiLineString.class;
            geometryType = "Line";
        } else {
            throw new RuntimeException("This should never happen, I got a geometry of type " + g.getClass());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("target", target);
        map.put("geometryType", geometryType);
        return map;
    }

    private StoreWriter getStoreWriter(String fileName, String geometryName, SimpleFeature f, Map<Class<?>, StoreWriter> writers, boolean multiWriter) throws IOException {
        Class target = null;
        String geometryType = null;
        if (multiWriter) {
            Map<String, Object> map = this.getGeometryType(f);
            target = (Class)map.get("target");
            geometryType = (String)map.get("geometryType");
        } else {
            target = Geometry.class;
            geometryType = "Geometry";
        }
        return this.getStoreWriter(fileName, geometryName, f.getFeatureType(), writers, multiWriter, target, geometryType);
    }

    private StoreWriter getStoreWriter(String fileName, String geometryName, SimpleFeatureType original, Map<Class<?>, StoreWriter> writers, boolean multiWriter, Class<?> target, String geometryType) throws IOException {
        StoreWriter storeWriter;
        StoreWriter storeWriter2 = storeWriter = writers != null ? writers.get(target) : null;
        if (storeWriter == null) {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor d : original.getAttributeDescriptors()) {
                if (Geometry.class.isAssignableFrom(d.getType().getBinding()) && multiWriter) {
                    GeometryDescriptor gd = (GeometryDescriptor)d;
                    builder.add(gd.getLocalName(), target, gd.getCoordinateReferenceSystem());
                    builder.setDefaultGeometry(gd.getLocalName());
                    continue;
                }
                builder.add(d);
            }
            builder.setNamespaceURI(original.getName().getURI());
            fileName = multiWriter ? this.getShapeName(fileName, geometryName, original, geometryType) : this.getShapeName(fileName, geometryName, original, null);
            builder.setName(fileName);
            SimpleFeatureType retyped = builder.buildFeatureType();
            storeWriter = new StoreWriter(retyped);
            if (writers != null) {
                writers.put(target, storeWriter);
            }
        }
        return storeWriter;
    }

    protected String getShapeName(SimpleFeatureType schema, String geometryName, String geometryType) {
        if (geometryName == null) {
            return this.getShapeName(schema, geometryType);
        }
        return this.getShapeName(schema.getTypeName(), geometryName, geometryType);
    }

    @Deprecated
    protected String getShapeName(SimpleFeatureType schema, String geometryType) {
        return this.getShapeName(schema.getTypeName(), null, geometryType);
    }

    private String getShapeName(String fileName, String geometryName, SimpleFeatureType schema, String geometryType) {
        if (fileName == null) {
            return this.getShapeName(schema, geometryName, geometryType);
        }
        return this.getShapeName(fileName, geometryName, geometryType);
    }

    private String getShapeName(String fileName, String geometryName, String geometryType) {
        return Arrays.stream(new String[]{fileName, geometryName, geometryType}).filter(s -> s != null).collect(Collectors.joining(""));
    }

    private class StoreWriter {
        int currentFileId = 0;
        ShapefileDataStore dstore;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
        SimpleFeatureType schema;

        public StoreWriter(SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
            this.schema = schema;
            this.createStoreAndWriter(schema);
        }

        private void createStoreAndWriter(SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
            this.dstore = ShapefileDumper.this.buildStore(schema);
            this.writer = this.dstore.getFeatureWriter(schema.getTypeName(), Transaction.AUTO_COMMIT);
        }

        public void nextWriter() throws IOException {
            this.writer.close();
            this.dstore.dispose();
            ++this.currentFileId;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(this.schema);
            tb.setName(this.schema.getTypeName() + String.valueOf(this.currentFileId));
            SimpleFeatureType ft = tb.buildFeatureType();
            this.createStoreAndWriter(ft);
        }
    }
}

