/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.shadedrelief;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefAlgorithm;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.operator.BorderDescriptor;

class ShadedReliefOpImage
extends AreaOpImage {
    private static final BorderExtender EXTENDER = BorderExtender.createInstance(1);
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    protected final boolean hasNoData;
    protected Range srcNoData;
    protected final boolean caseA;
    protected final boolean caseB;
    protected final boolean caseC;
    protected final boolean hasROI;
    protected ROI roi;
    protected final Rectangle roiBounds;
    protected PlanarImage roiImage;
    protected double dstNoData;
    protected RenderedImage extendedIMG;
    protected Rectangle destBounds;
    private int maxX;
    private int maxY;
    private ShadedReliefAlgorithm.ShadedReliefParameters params;
    private static final int FIXED_PADDING = 1;

    public ShadedReliefOpImage(RenderedImage source, RenderingHints hints, ImageLayout l, ROI roi, Range srcNoData, double dstNoData, double resX, double resY, double verticalExaggeration, double verticalScale, double altitude, double azimuth, ShadedReliefAlgorithm algorithm) {
        super(source, l, hints, true, EXTENDER, 1, 1, 1, 1);
        this.maxX = this.minX + this.width - 1;
        this.maxY = this.minY + this.height - 1;
        if (roi != null) {
            this.hasROI = true;
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
            this.roiBounds = null;
        }
        int dataType = source.getSampleModel().getDataType();
        if (srcNoData != null) {
            this.hasNoData = true;
            this.srcNoData = srcNoData;
        } else {
            this.hasNoData = false;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        this.dstNoData = dstNoData;
        this.params = new ShadedReliefAlgorithm.ShadedReliefParameters(resX, resY, verticalExaggeration, verticalScale, altitude, azimuth, algorithm);
        if (this.extender != null) {
            RenderingHints borderHints = (RenderingHints)hints.clone();
            Object layout = borderHints.get(JAI.KEY_IMAGE_LAYOUT);
            ImageLayout il = null;
            if (layout != null && layout instanceof ImageLayout) {
                il = (ImageLayout)layout;
            } else {
                il = new ImageLayout(source.getMinX() - this.leftPadding, source.getMinY() - this.topPadding, source.getWidth() + this.leftPadding + this.rightPadding, source.getHeight() + this.topPadding + this.bottomPadding);
                borderHints.put(JAI.KEY_IMAGE_LAYOUT, il);
            }
            il.setTileGridXOffset(source.getTileGridXOffset());
            il.setTileGridYOffset(source.getTileGridYOffset());
            this.extendedIMG = BorderDescriptor.create(source, this.leftPadding, this.rightPadding, this.topPadding, this.bottomPadding, this.extender, borderHints);
            this.destBounds = this.getBounds();
        } else {
            int x0 = this.getMinX() + this.leftPadding;
            int y0 = this.getMinY() + this.topPadding;
            int w = this.getWidth() - this.leftPadding - this.rightPadding;
            w = Math.max(w, 0);
            int h = this.getHeight() - this.topPadding - this.bottomPadding;
            h = Math.max(h, 0);
            this.destBounds = new Rectangle(x0, y0, w, h);
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor src = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect(new ROIShape(srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create(roiIMG, null);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (dst.getDataType()) {
                case 0: {
                    this.byteLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.ushortLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.shortLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.intLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.floatLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.doubleLoop(src, dst, roiIter, roiContainsTile);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong Data Type defined");
                }
            }
            if (dst.isDataCopy()) {
                dst.clampDataArrays();
                dst.copyDataToRaster();
            }
        } else {
            double[] backgroundValues = new double[src.getNumBands()];
            Arrays.fill(backgroundValues, this.dstNoData);
            ImageUtil.fillBackground(dest, destRect, backgroundValues);
        }
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        if (!this.cobbleSources) {
            return super.computeTile(tileX, tileY);
        }
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle rect = new Rectangle(org.x, org.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle destRect = rect.intersection(this.destBounds);
        if (destRect.width <= 0 || destRect.height <= 0) {
            return dest;
        }
        PlanarImage s = this.getSourceImage(0);
        destRect = destRect.intersection(s.getBounds());
        Rectangle srcRect = new Rectangle(destRect);
        srcRect.x -= this.getLeftPadding();
        srcRect.width += this.getLeftPadding() + this.getRightPadding();
        srcRect.y -= this.getTopPadding();
        srcRect.height += this.getTopPadding() + this.getBottomPadding();
        IntegerSequence srcXSplits = new IntegerSequence();
        IntegerSequence srcYSplits = new IntegerSequence();
        s.getSplits(srcXSplits, srcYSplits, srcRect);
        IntegerSequence xSplits = new IntegerSequence(destRect.x, destRect.x + destRect.width);
        xSplits.insert(destRect.x);
        xSplits.insert(destRect.x + destRect.width);
        srcXSplits.startEnumeration();
        while (srcXSplits.hasMoreElements()) {
            int xsplit = srcXSplits.nextElement();
            int lsplit = xsplit - this.getLeftPadding();
            int rsplit = xsplit + this.getRightPadding();
            xSplits.insert(lsplit);
            xSplits.insert(rsplit);
        }
        IntegerSequence ySplits = new IntegerSequence(destRect.y, destRect.y + destRect.height);
        ySplits.insert(destRect.y);
        ySplits.insert(destRect.y + destRect.height);
        srcYSplits.startEnumeration();
        while (srcYSplits.hasMoreElements()) {
            int ysplit = srcYSplits.nextElement();
            int tsplit = ysplit - this.getBottomPadding();
            int bsplit = ysplit + this.getTopPadding();
            ySplits.insert(tsplit);
            ySplits.insert(bsplit);
        }
        Raster[] sources = new Raster[1];
        ySplits.startEnumeration();
        int y1 = ySplits.nextElement();
        while (ySplits.hasMoreElements()) {
            int y2 = ySplits.nextElement();
            int h = y2 - y1;
            int py1 = y1 - this.getTopPadding();
            int py2 = y2 + this.getBottomPadding();
            int ph = py2 - py1;
            xSplits.startEnumeration();
            int x1 = xSplits.nextElement();
            while (xSplits.hasMoreElements()) {
                int x2 = xSplits.nextElement();
                int w = x2 - x1;
                int px1 = x1 - this.getLeftPadding();
                int px2 = x2 + this.getRightPadding();
                int pw = px2 - px1;
                Rectangle srcSubRect = new Rectangle(px1, py1, pw, ph);
                sources[0] = this.extender != null ? this.extendedIMG.getData(srcSubRect) : s.getData(srcSubRect);
                Rectangle dstSubRect = new Rectangle(x1, y1, w, h);
                this.computeRect(sources, dest, dstSubRect);
                if (s.overlapsMultipleTiles(srcSubRect)) {
                    this.recycleTile(sources[0]);
                }
                x1 = x2;
            }
            y1 = y2;
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            ShadedReliefOpImage shadedReliefOpImage = this;
            synchronized (shadedReliefOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }

    protected void byteLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        byte destNoDataTyped = ImageUtil.clampRoundByte(this.dstNoData);
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        double[] window = new double[9];
        boolean[] roiMask = new boolean[9];
        byte[] dstData = dstDataArrays[0];
        byte[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        ShadedReliefAlgorithm.DataProcessorByte data = new ShadedReliefAlgorithm.DataProcessorByte(srcData, this.hasNoData, this.srcNoData, this.dstNoData, this.params);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    double destValue = data.processWindow(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = ImageUtil.clampRoundByte(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    if (inROI) {
                        int sX = x + dstX;
                        int sY = y + dstY;
                        ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                        double destValue = data.processWindowRoi(window, x, srcPixelOffset, centerScanlineOffset, currentCase, roiMask);
                        dstData[dstPixelOffset] = ImageUtil.clampRoundByte(destValue);
                    } else {
                        dstData[dstPixelOffset] = destNoDataTyped;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    double destValue = data.processWindowNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = Double.isNaN(destValue) ? destNoDataTyped : ImageUtil.clampRoundByte(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    int sY;
                    int sX;
                    ShadedReliefAlgorithm.ProcessingCase currentCase;
                    double destValue;
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    dstData[dstPixelOffset] = inROI ? (Double.isNaN(destValue = data.processWindowRoiNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase = this.getCase(sX = x + dstX, sY = y + dstY), roiMask)) ? destNoDataTyped : ImageUtil.clampRoundByte(destValue)) : destNoDataTyped;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        short destNoDataTyped = ImageUtil.clampRoundUShort(this.dstNoData);
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        double[] window = new double[9];
        boolean[] roiMask = new boolean[9];
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        double destValue = Double.NaN;
        ShadedReliefAlgorithm.DataProcessorShort data = new ShadedReliefAlgorithm.DataProcessorShort(srcData, this.hasNoData, this.srcNoData, this.dstNoData, this.params);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindow(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = ImageUtil.clampRoundUShort(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    if (inROI) {
                        int sX = x + dstX;
                        int sY = y + dstY;
                        ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                        destValue = data.processWindowRoi(window, x, srcPixelOffset, centerScanlineOffset, currentCase, roiMask);
                        dstData[dstPixelOffset] = ImageUtil.clampRoundUShort(destValue);
                    } else {
                        dstData[dstPixelOffset] = destNoDataTyped;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindowNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = Double.isNaN(destValue) ? destNoDataTyped : ImageUtil.clampRoundUShort(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    int sY;
                    int sX;
                    ShadedReliefAlgorithm.ProcessingCase currentCase;
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    dstData[dstPixelOffset] = inROI ? (Double.isNaN(destValue = data.processWindowRoiNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase = this.getCase(sX = x + dstX, sY = y + dstY), roiMask)) ? destNoDataTyped : ImageUtil.clampRoundUShort(destValue)) : destNoDataTyped;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    protected void shortLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        short destNoDataTyped = ImageUtil.clampRoundShort(this.dstNoData);
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        double[] window = new double[9];
        boolean[] roiMask = new boolean[9];
        short[] dstData = dstDataArrays[0];
        short[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        double destValue = Double.NaN;
        ShadedReliefAlgorithm.DataProcessorShort data = new ShadedReliefAlgorithm.DataProcessorShort(srcData, this.hasNoData, this.srcNoData, this.dstNoData, this.params);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    int sX = i + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindow(window, i, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = ImageUtil.clampRoundShort(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    if (inROI) {
                        int sX = x + dstX;
                        int sY = y + dstY;
                        ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                        destValue = data.processWindowRoi(window, x, srcPixelOffset, centerScanlineOffset, currentCase, roiMask);
                        dstData[dstPixelOffset] = ImageUtil.clampRoundShort(destValue);
                    } else {
                        dstData[dstPixelOffset] = destNoDataTyped;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindowNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = Double.isNaN(destValue) ? destNoDataTyped : ImageUtil.clampRoundShort(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    int sY;
                    int sX;
                    ShadedReliefAlgorithm.ProcessingCase currentCase;
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    dstData[dstPixelOffset] = inROI ? (Double.isNaN(destValue = data.processWindowRoiNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase = this.getCase(sX = x + dstX, sY = y + dstY), roiMask)) ? destNoDataTyped : ImageUtil.clampRoundShort(destValue)) : destNoDataTyped;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    protected void intLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int destNoDataTyped = ImageUtil.clampRoundInt(this.dstNoData);
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        double[] window = new double[9];
        boolean[] roiMask = new boolean[9];
        int[] dstData = dstDataArrays[0];
        int[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        double destValue = Double.NaN;
        ShadedReliefAlgorithm.DataProcessorInt data = new ShadedReliefAlgorithm.DataProcessorInt(srcData, this.hasNoData, this.srcNoData, this.dstNoData, this.params);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindow(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = ImageUtil.clampRoundInt(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    if (inROI) {
                        int sX = x + dstX;
                        int sY = y + dstY;
                        ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                        destValue = data.processWindowRoi(window, x, srcPixelOffset, centerScanlineOffset, currentCase, roiMask);
                        dstData[dstPixelOffset] = ImageUtil.clampRoundInt(destValue);
                    } else {
                        dstData[dstPixelOffset] = destNoDataTyped;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindowNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = Double.isNaN(destValue) ? destNoDataTyped : ImageUtil.clampRoundInt(destValue);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    int sY;
                    int sX;
                    ShadedReliefAlgorithm.ProcessingCase currentCase;
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    dstData[dstPixelOffset] = inROI ? (Double.isNaN(destValue = data.processWindowRoiNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase = this.getCase(sX = x + dstX, sY = y + dstY), roiMask)) ? destNoDataTyped : ImageUtil.clampRoundInt(destValue)) : destNoDataTyped;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    protected void floatLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        float destNoDataTyped = ImageUtil.clampFloat(this.dstNoData);
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        double[] window = new double[9];
        boolean[] roiMask = new boolean[9];
        float[] dstData = dstDataArrays[0];
        float[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        double destValue = Double.NaN;
        ShadedReliefAlgorithm.DataProcessorFloat data = new ShadedReliefAlgorithm.DataProcessorFloat(srcData, this.hasNoData, this.srcNoData, this.dstNoData, this.params);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindow(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = (float)destValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    if (inROI) {
                        int sX = x + dstX;
                        int sY = y + dstY;
                        ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                        destValue = data.processWindowRoi(window, x, srcPixelOffset, centerScanlineOffset, currentCase, roiMask);
                        dstData[dstPixelOffset] = (float)destValue;
                    } else {
                        dstData[dstPixelOffset] = destNoDataTyped;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindowNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = Double.isNaN(destValue) ? destNoDataTyped : (float)destValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    int sY;
                    int sX;
                    ShadedReliefAlgorithm.ProcessingCase currentCase;
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    dstData[dstPixelOffset] = inROI ? (Double.isNaN(destValue = data.processWindowRoiNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase = this.getCase(sX = x + dstX, sY = y + dstY), roiMask)) ? destNoDataTyped : (float)destValue) : destNoDataTyped;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    protected void doubleLoop(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcScanlineStride;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        double destNoDataTyped = this.dstNoData;
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int centerScanlineOffset = srcScanlineStride = src.getScanlineStride();
        int dstX = dst.getX();
        int dstY = dst.getY();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        double[] window = new double[9];
        boolean[] roiMask = new boolean[9];
        double[] dstData = dstDataArrays[0];
        double[] srcData = srcDataArrays[0];
        int srcScanlineOffset = srcBandOffsets[0];
        int dstScanlineOffset = dstBandOffsets[0];
        double destValue = Double.NaN;
        ShadedReliefAlgorithm.DataProcessorDouble data = new ShadedReliefAlgorithm.DataProcessorDouble(srcData, this.hasNoData, this.srcNoData, this.dstNoData, this.params);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    dstData[dstPixelOffset] = destValue = data.processWindow(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    if (inROI) {
                        int sX = x + dstX;
                        int sY = y + dstY;
                        ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                        dstData[dstPixelOffset] = destValue = data.processWindowRoi(window, x, srcPixelOffset, centerScanlineOffset, currentCase, roiMask);
                    } else {
                        dstData[dstPixelOffset] = destNoDataTyped;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int x = 0; x < dwidth; ++x) {
                    int sX = x + dstX;
                    int sY = y + dstY;
                    ShadedReliefAlgorithm.ProcessingCase currentCase = this.getCase(sX, sY);
                    destValue = data.processWindowNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase);
                    dstData[dstPixelOffset] = Double.isNaN(destValue) ? destNoDataTyped : destValue;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        } else {
            for (int y = 0; y < dheight; ++y) {
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                y0 = srcY + y;
                for (int x = 0; x < dwidth; ++x) {
                    int sY;
                    int sX;
                    ShadedReliefAlgorithm.ProcessingCase currentCase;
                    x0 = srcX + x;
                    boolean inROI = false;
                    for (int dy = 0; dy < 3; ++dy) {
                        int yI = y0 + dy;
                        for (int dx = 0; dx < 3; ++dx) {
                            int xI = x0 + dx;
                            if (this.roiBounds.contains(xI, yI) && roiIter.getSample(xI, yI, 0) > 0) {
                                inROI = true;
                                roiMask[dx + 3 * dy] = true;
                                continue;
                            }
                            roiMask[dx + 3 * dy] = false;
                        }
                    }
                    dstData[dstPixelOffset] = inROI ? (Double.isNaN(destValue = data.processWindowRoiNoData(window, x, srcPixelOffset, centerScanlineOffset, currentCase = this.getCase(sX = x + dstX, sY = y + dstY), roiMask)) ? destNoDataTyped : destValue) : destNoDataTyped;
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcScanlineOffset += srcScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }

    private ShadedReliefAlgorithm.ProcessingCase getCase(int x, int y) {
        if (y == this.minY) {
            if (x == this.minX) {
                return ShadedReliefAlgorithm.ProcessingCase.TOP_LEFT;
            }
            if (x == this.maxX) {
                return ShadedReliefAlgorithm.ProcessingCase.TOP_RIGHT;
            }
            return ShadedReliefAlgorithm.ProcessingCase.TOP;
        }
        if (y == this.maxY) {
            if (x == this.minX) {
                return ShadedReliefAlgorithm.ProcessingCase.BOTTOM_LEFT;
            }
            if (y == this.maxY) {
                return ShadedReliefAlgorithm.ProcessingCase.BOTTOM_RIGHT;
            }
            return ShadedReliefAlgorithm.ProcessingCase.BOTTOM;
        }
        if (x == this.minX) {
            return ShadedReliefAlgorithm.ProcessingCase.LEFT;
        }
        if (x == this.maxX) {
            return ShadedReliefAlgorithm.ProcessingCase.RIGHT;
        }
        return ShadedReliefAlgorithm.ProcessingCase.STANDARD;
    }
}

