/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.core;

import java.net.URI;
import java.net.URL;

public class BasicAuthURI {
    private URI uri;
    private boolean useCache = true;
    private String user;
    private String password;

    public BasicAuthURI(String uri) {
        this(URI.create(uri));
    }

    public BasicAuthURI(String uri, boolean useCache) {
        this(URI.create(uri), useCache);
    }

    public BasicAuthURI(URL url) {
        this(url.toString());
    }

    public BasicAuthURI(URL url, boolean useCache) {
        this(url.toString(), useCache);
    }

    public BasicAuthURI(URI uri) {
        this(uri, true);
    }

    public BasicAuthURI(URI uri, boolean useCache) {
        this(uri, useCache, null, null);
    }

    public BasicAuthURI(URI uri, boolean useCache, String user, String password) {
        String userInfo;
        this.setUri(uri);
        this.setUseCache(useCache);
        if (user == null && password == null && (userInfo = uri.getUserInfo()) != null && userInfo.contains(":")) {
            String[] userInfoArray = userInfo.split(":");
            user = userInfoArray[0];
            password = userInfoArray[1];
        }
        this.setUser(user);
        this.setPassword(password);
    }

    public URI getUri() {
        return this.uri;
    }

    public BasicAuthURI uri(URI uri) {
        this.setUri(uri);
        return this;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BasicAuthURI useCache(boolean useCache) {
        this.setUseCache(useCache);
        return this;
    }
}

