/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.core.datasets.SimpleDataSetHandler;
import org.openstreetmap.josm.tools.Logging;

public abstract class NamesFrUtils {
    private static final Map<String, String> dictionary = NamesFrUtils.initDictionary();

    public static String checkDictionary(String value) {
        StringBuilder result = new StringBuilder();
        for (String word : value.split(" ")) {
            if (result.length() != 0) {
                result.append(' ');
            }
            result.append(dictionary.getOrDefault(word, word));
        }
        return result.toString();
    }

    private static Map<String, String> initDictionary() {
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SimpleDataSetHandler.class.getResourceAsStream("/resources/org/openstreetmap/josm/plugins/opendata/core/resources/dictionary.fr.csv"), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            Logging.trace((String)line);
            while ((line = reader.readLine()) != null) {
                String[] tab = line.split(";");
                result.put(tab[0].replace("\"", ""), tab[1].replace("\"", ""));
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
        return result;
    }

    public static String getStreetLabel(String label) {
        if (label == null) {
            return null;
        }
        if (label.startsWith("All")) {
            return "All\u00e9e";
        }
        if ("Autoroute".equals(label)) {
            return label;
        }
        if (label.startsWith("Anc")) {
            return "Ancien";
        }
        if (label.startsWith("Av")) {
            return "Avenue";
        }
        if (label.startsWith("Barr")) {
            return "Barri\u00e8re";
        }
        if ("Bd".equals(label) || "Boulevard".equals(label)) {
            return "Boulevard";
        }
        if (label.startsWith("Bret")) {
            return "Bretelle";
        }
        if ("Bre".equals(label)) {
            return "Br\u00e9";
        }
        if ("Caminot".equals(label)) {
            return label;
        }
        if ("Carrefour".equals(label)) {
            return label;
        }
        if ("Carr\u00e9".equals(label)) {
            return label;
        }
        if (label.startsWith("Chemine")) {
            return "Cheminement";
        }
        if (label.startsWith("Che")) {
            return "Chemin";
        }
        if (label.startsWith("Cit")) {
            return "Cit\u00e9";
        }
        if ("Clos".equals(label)) {
            return label;
        }
        if ("Cote".equals(label) || "C\u00f4te".equals(label)) {
            return "C\u00f4te";
        }
        if ("Cours".equals(label)) {
            return label;
        }
        if (label.startsWith("Dep") || label.startsWith("D\u00e9p")) {
            return "D\u00e9partementale";
        }
        if (label.startsWith("Dom")) {
            return "Domaine";
        }
        if ("Dsc".equals(label) || label.startsWith("Desc")) {
            return "Descente";
        }
        if ("Esp".equals(label) || label.startsWith("Espl")) {
            return "Esplanade";
        }
        if (label.startsWith("Espa")) {
            return "Espace";
        }
        if ("Giratoire".equals(label)) {
            return label;
        }
        if ("Grande-rue".equals(label)) {
            return label;
        }
        if ("Hameau".equals(label)) {
            return label;
        }
        if (label.startsWith("Imp") || "Ipasse".equals(label)) {
            return "Impasse";
        }
        if (label.startsWith("Itin")) {
            return "Itin\u00e9raire";
        }
        if ("Jardin".equals(label)) {
            return label;
        }
        if (label.startsWith("L'") || "La".equals(label) || "Le".equals(label) || "Les".equals(label) || "Saint".equals(label)) {
            return label;
        }
        if (label.startsWith("Lot")) {
            return "Lotissement";
        }
        if ("Mail".equals(label)) {
            return label;
        }
        if ("Mas".equals(label)) {
            return label;
        }
        if (label.startsWith("Nat")) {
            return "Nationale";
        }
        if ("Parc".equals(label)) {
            return label;
        }
        if ("Passerelle".equals(label)) {
            return label;
        }
        if (label.startsWith("Pas")) {
            return "Passage";
        }
        if ("Pch".equals(label) || label.startsWith("Petit-chem")) {
            return "Petit-chemin";
        }
        if ("Petit".equals(label) || "Petite".equals(label)) {
            return label;
        }
        if ("Petite-all\u00e9e".equals(label)) {
            return label;
        }
        if ("Petite-rue".equals(label)) {
            return label;
        }
        if ("Plan".equals(label)) {
            return label;
        }
        if (label.startsWith("Pl")) {
            return "Place";
        }
        if ("Pont".equals(label)) {
            return label;
        }
        if ("Port".equals(label)) {
            return label;
        }
        if ("Porte".equals(label)) {
            return label;
        }
        if (label.startsWith("Prom")) {
            return "Promenade";
        }
        if ("Prv".equals(label) || label.startsWith("Parv")) {
            return "Parvis";
        }
        if (label.startsWith("Qu")) {
            return "Quai";
        }
        if ("Rampe".equals(label)) {
            return label;
        }
        if (label.startsWith("Res") || label.startsWith("R\u00e9s")) {
            return "R\u00e9sidence";
        }
        if ("Rocade".equals(label)) {
            return label;
        }
        if ("Rpt".equals(label) || label.startsWith("Ron")) {
            return "Rond-Point";
        }
        if ("Rte".equals(label) || "Route".equals(label)) {
            return "Route";
        }
        if ("Rue".equals(label) || "Rued".equals(label)) {
            return "Rue";
        }
        if ("Sentier".equals(label)) {
            return label;
        }
        if (label.startsWith("Sq")) {
            return "Square";
        }
        if ("Th\u00e9\u00e2tre".equals(label)) {
            return "Th\u00e9\u00e2tre";
        }
        if (label.startsWith("Tra")) {
            return "Traverse";
        }
        if ("Vieux".equals(label)) {
            return label;
        }
        if ("Voie".equals(label)) {
            return label;
        }
        if ("Zone".equals(label)) {
            return label;
        }
        Logging.warn((String)("unknown street label: " + label));
        return label;
    }

    public static String checkStreetName(OsmPrimitive p, String key) {
        Object value = null;
        if (p != null && (value = p.get(key)) != null) {
            String[] words;
            if ("Boulingrin".equals(value = WordUtils.capitalizeFully((String)value))) {
                value = "Sq Boulingrin";
            } else if (((String)value).matches("A[0-9]+")) {
                value = "Autoroute " + (String)value;
            } else if ("All A61".equals(value)) {
                value = "Autoroute A61";
            } else if (((String)value).startsWith("Che Vieux Che")) {
                value = ((String)value).replaceFirst("Che ", "");
            } else if (((String)value).startsWith("Petite Allee ")) {
                value = ((String)value).replaceFirst("Petite Allee ", "Petite-all\u00e9e ");
            } else if (((String)value).startsWith("Ld De ")) {
                value = ((String)value).replaceFirst("Ld De ", "");
            }
            while (((String)value).startsWith("Ld ")) {
                value = ((String)value).replaceFirst("Ld ", "");
            }
            if (((String)value).startsWith("L ")) {
                value = ((String)value).replaceFirst("L ", "L'");
            }
            if ((words = ((String)value).split(" ")).length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                List<String> list = Arrays.asList(words);
                words[0] = NamesFrUtils.getStreetLabel(words[0]);
                if ("Ancien".equals(words[0]) && words.length > 1 && "Che".equals(words[1])) {
                    words[1] = "Chemin";
                }
                for (int i = 0; i < words.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(' ');
                        if ("A".equals(words[i]) && list.contains("Bernard")) {
                            words[i] = "Arnaud";
                        } else if ("A".equals(words[i]) && list.contains("Passerieu")) {
                            words[i] = "Ariste";
                        } else if ("A".equals(words[i]) && list.contains("Bougainville")) {
                            words[i] = "Antoine";
                        } else if ("Ch".equals(words[i]) && list.contains("Leconte")) {
                            words[i] = "Charles";
                        } else if ("Frs".equals(words[i]) && list.contains("Dugua")) {
                            words[i] = "Fran\u00e7ois";
                        } else if ("G".equals(words[i]) && list.contains("Latecoere")) {
                            words[i] = "Georges";
                        } else if ("H".equals(words[i]) && list.contains("Lautrec")) {
                            words[i] = "Henri";
                        } else if ("J".equals(words[i]) && list.contains("Dieulafoy")) {
                            words[i] = "Jane";
                        } else if ("J".equals(words[i]) && (list.contains("Champollion") || list.contains("Stanislas"))) {
                            words[i] = "Jean";
                        } else if ("L".equals(words[i]) && list.contains("Zamenhof")) {
                            words[i] = "Ludwik";
                        } else if ("L".equals(words[i]) && list.contains("Sacha")) {
                            words[i] = "Lucien";
                            if (!list.contains("Et")) {
                                int n = i;
                                words[n] = words[n] + " et";
                            }
                        } else if ("L".equals(words[i]) && (list.contains("Vauquelin") || list.contains("Bougainville"))) {
                            words[i] = "Louis";
                        } else if ("M".equals(words[i]) && list.contains("Dieulafoy")) {
                            words[i] = "Marcel";
                        } else if ("M".equals(words[i]) && list.contains("Arifat")) {
                            words[i] = "Marie";
                        } else if ("N".equals(words[i]) && list.contains("Djamena")) {
                            words[i] = "N'";
                        } else if ("Oo".equals(words[i])) {
                            words[i] = "O\u00f4";
                        } else if ("Ph".equals(words[i]) && list.contains("Ravary")) {
                            words[i] = "Philippe";
                        } else if ("R".equals(words[i]) && list.contains("Folliot")) {
                            words[i] = "Rapha\u00ebl";
                        } else if ("W".equals(words[i]) && list.contains("Booth")) {
                            words[i] = "William";
                        } else if ("A".equals(words[i])) {
                            words[i] = "\u00e0";
                        } else if ("D".equals(words[i]) || "L".equals(words[i])) {
                            words[i] = words[i].toLowerCase(Locale.FRENCH) + "'";
                        } else if ("La".equals(words[i]) || "Le".equals(words[i])) {
                            words[i] = words[i].toLowerCase(Locale.FRENCH);
                        }
                    }
                    stringBuilder.append(words[i]);
                }
                value = stringBuilder.toString();
            }
            value = ((String)value).replace("' ", "'");
            value = NamesFrUtils.checkDictionary((String)value);
            p.put(key, (String)value);
        }
        return value;
    }
}

