/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.data.DataStore;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.locationtech.jts.geom.Point;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.NationalHandlers;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeotoolsConverter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ShpReader
extends GeographicReader {
    private final ShpHandler handler;
    private final Set<OsmPrimitive> featurePrimitives = new HashSet<OsmPrimitive>();

    public ShpReader(ShpHandler handler) {
        super(handler, NationalHandlers.DEFAULT_SHP_HANDLERS);
        this.handler = handler;
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new ShpReader(handler != null ? handler.getShpHandler() : null).parse(file, instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public DataSet parse(File file, ProgressMonitor instance) throws IOException {
        block20: {
            this.crs = null;
            this.transform = null;
            try {
                DataStore dataStore;
                Charset charset;
                HashMap<String, Object> params;
                block21: {
                    if (file == null) break block20;
                    params = new HashMap<String, Object>();
                    charset = null;
                    params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
                    if (this.handler != null && this.handler.getDbfCharset() != null) {
                        charset = this.handler.getDbfCharset();
                    } else {
                        Object path = file.getAbsolutePath();
                        Path cpg = new File((String)(path = ((String)path).substring(0, ((String)path).lastIndexOf(46)) + ".cpg")).toPath();
                        if (Files.exists(cpg, new LinkOption[0])) {
                            try (BufferedReader reader = Files.newBufferedReader(cpg, StandardCharsets.UTF_8);){
                                String cs = reader.readLine();
                                if (cs.matches("\\d+")) {
                                    for (String prefix : Arrays.asList("IBM", "IBM0", "IBM00", "x-IBM", "ISO-", "windows-", "x-windows-")) {
                                        try {
                                            charset = Charset.forName(prefix + cs);
                                            break block21;
                                        }
                                        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                                            Logging.trace((Throwable)e);
                                        }
                                    }
                                    break block21;
                                }
                                charset = Charset.forName(cs);
                            }
                            catch (IOException | IllegalCharsetNameException | UnsupportedCharsetException e) {
                                Logging.warn((Throwable)e);
                            }
                        }
                    }
                }
                if (charset != null) {
                    Logging.info((String)("Using charset " + String.valueOf(charset)));
                    params.put(ShapefileDataStoreFactory.DBFCHARSET.key, charset.name());
                }
                if ((dataStore = new ShapefileDataStoreFactory().createDataStore(params)) == null) {
                    throw new IOException(I18n.tr((String)"Unable to find a data store for file {0}", (Object[])new Object[]{file.getName()}));
                }
                new GeotoolsConverter(this, dataStore).convert(instance);
            }
            catch (IOException e) {
                Logging.error((Throwable)e);
                throw e;
            }
            catch (FactoryException | TransformException | GeoCrsException | GeoMathTransformException e) {
                Logging.error((Throwable)e);
                throw new IOException(e);
            }
        }
        return this.ds;
    }

    @Override
    protected Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        Node n = super.createOrGetNode(p);
        this.featurePrimitives.add((OsmPrimitive)n);
        return n;
    }

    @Override
    protected <T extends OsmPrimitive> T addOsmPrimitive(T p) {
        this.featurePrimitives.add(p);
        return super.addOsmPrimitive(p);
    }
}

